/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.core;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLFingerprintViolationEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.logging.Level;
import mods.railcraft.api.fuel.FuelManager;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.blocks.aesthetics.post.BlockPostMetal;
import mods.railcraft.common.blocks.aesthetics.post.EnumPost;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.carts.LinkageManager;
import mods.railcraft.common.core.CommonProxy;
import mods.railcraft.common.core.StartupChecks;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.plugins.craftguide.CraftGuidePlugin;
import mods.railcraft.common.plugins.forge.CreeperPlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.plugins.forge.LetsGoFishingPlugin;
import mods.railcraft.common.util.inventory.filters.StackFilter;
import mods.railcraft.common.util.misc.BallastRegistry;
import mods.railcraft.common.util.misc.BlinkTick;
import mods.railcraft.common.util.misc.EnumColor;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.RailcraftPacketHandler;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

@Mod(modid="Railcraft", name="Railcraft", version="8.3.2.0", certificateFingerprint="a0c255ac501b2749537d5824bb0f0588bf0320fa", acceptedMinecraftVersions="[1.6.4,1.7)", dependencies="required-after:Forge@[9.11.1.965,);after:BuildCraft|Core[4.0.1,);after:BuildCraft|Energy;after:BuildCraft|Builders;after:BuildCraft|Factory;after:Forestry;after:Thaumcraft;after:IC2@[2.0.140,)")
@NetworkMod(channels={"RC"}, clientSideRequired=true, serverSideRequired=true, packetHandler=RailcraftPacketHandler.class)
public final class Railcraft {
    public static final String MOD_ID = "Railcraft";
    public static final String VERSION = "8.3.2.0";
    @Mod.Instance(value="Railcraft")
    public static Railcraft instance;
    private File configFolder;
    @SidedProxy(clientSide="mods.railcraft.client.core.ClientProxy", serverSide="mods.railcraft.common.core.CommonProxy")
    public static CommonProxy proxy;
    public static boolean thisIsFalse;

    public static CommonProxy getProxy() {
        return proxy;
    }

    public static Railcraft getMod() {
        return instance;
    }

    public static String getModId() {
        return MOD_ID;
    }

    public static String getVersion() {
        return VERSION;
    }

    public File getConfigFolder() {
        return this.configFolder;
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        Splitter splitter = Splitter.on((String)"@").trimResults();
        for (FMLInterModComms.IMCMessage mess : event.getMessages()) {
            String[] tokens;
            if (mess.key.equals("ballast")) {
                tokens = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)mess.getStringValue()), String.class);
                if (tokens.length != 2) {
                    Game.log(Level.WARNING, String.format("Mod %s attempted to register a ballast, but failed: %s", mess.getSender(), mess.getStringValue()), new Object[0]);
                    continue;
                }
                Integer blockId = Ints.tryParse((String)tokens[0]);
                Integer metadata = Ints.tryParse((String)tokens[1]);
                if (blockId == null || metadata == null) {
                    Game.log(Level.WARNING, String.format("Mod %s attempted to register a ballast, but failed: %s", mess.getSender(), mess.getStringValue()), new Object[0]);
                    continue;
                }
                BallastRegistry.registerBallast(blockId, metadata);
                Game.log(Level.INFO, String.format("Mod %s registered %s as a valid ballast", mess.getSender(), mess.getStringValue()), new Object[0]);
                continue;
            }
            if (mess.key.equals("boiler-fuel-liquid")) {
                tokens = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)mess.getStringValue()), String.class);
                if (tokens.length != 2) {
                    Game.log(Level.WARNING, String.format("Mod %s attempted to register a liquid Boiler fuel, but failed: %s", mess.getSender(), mess.getStringValue()), new Object[0]);
                    continue;
                }
                Fluid fluid = FluidRegistry.getFluid((String)tokens[0]);
                Integer fuel = Ints.tryParse((String)tokens[1]);
                if (fluid == null || fuel == null) {
                    Game.log(Level.WARNING, String.format("Mod %s attempted to register a liquid Boiler fuel, but failed: %s", mess.getSender(), mess.getStringValue()), new Object[0]);
                    continue;
                }
                FuelManager.addBoilerFuel(fluid, fuel);
                Game.log(Level.INFO, String.format("Mod %s registered %s as a valid liquid Boiler fuel", mess.getSender(), mess.getStringValue()), new Object[0]);
                continue;
            }
            if (!mess.key.equals("securityViolation")) continue;
            CreeperPlugin.doFix();
            Game.log(Level.SEVERE, "{0} asked for a bailout!", mess.getSender());
        }
    }

    @Mod.EventHandler
    public void fingerprintError(FMLFingerprintViolationEvent event) {
        if (thisIsFalse) {
            double largest = Double.NEGATIVE_INFINITY;
            double smallest = Double.POSITIVE_INFINITY;
            while (true) {
                double input = 1.0;
                if (1.0 != 0.0) {
                    if (input > largest && (largest = input) != input || !(input < smallest) || (smallest = input) == input) continue;
                    continue;
                }
                if (largest != Double.NEGATIVE_INFINITY) break;
                largest = 0.0;
                if (0.0 != 0.0) break;
                smallest = 0.0;
                if (0.0 == 0.0) break;
            }
        }
        if (Game.isObfuscated()) {
            CreeperPlugin.pluckTheWeb("Tampering Detected. Please re-download Railcraft.");
            Runtime.getRuntime().halt(1);
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Game.log(Level.FINE, "Pre-Init Phase", new Object[0]);
        LetsGoFishingPlugin.reel$ItIn();
        this.configFolder = new File(event.getModConfigurationDirectory(), "railcraft");
        StartupChecks.checkForNewVersion();
        StackFilter.initialize();
        ModuleManager.preInit();
        proxy.preInitClient();
        FMLInterModComms.sendMessage((String)"OpenBlocks", (String)"donateUrl", (String)"http://www.railcraft.info/donate/");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Game.log(Level.FINE, "Init Phase", new Object[0]);
        ModuleManager.init();
        TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)new BlinkTick(), (Side)Side.CLIENT);
        for (EnumMachineAlpha enumMachineAlpha : EnumMachineAlpha.values()) {
            if (!enumMachineAlpha.isAvaliable()) continue;
            ItemRegistry.registerItemStack(enumMachineAlpha.getTag(), enumMachineAlpha.getItem());
        }
        for (Enum enum_ : EnumMachineBeta.values()) {
            if (!((EnumMachineBeta)enum_).isAvaliable()) continue;
            ItemRegistry.registerItemStack(((EnumMachineBeta)enum_).getTag(), ((EnumMachineBeta)enum_).getItem());
        }
        for (Enum enum_ : EnumMachineGamma.values()) {
            if (!((EnumMachineGamma)enum_).isAvaliable()) continue;
            ItemRegistry.registerItemStack(((EnumMachineGamma)enum_).getTag(), ((EnumMachineGamma)enum_).getItem());
        }
        for (Enum enum_ : EnumSignal.values()) {
            if (!((EnumSignal)enum_).isEnabled()) continue;
            ItemRegistry.registerItemStack(((EnumSignal)enum_).getTag(), ((EnumSignal)enum_).getItem());
        }
        for (Enum enum_ : EnumCube.values()) {
            if (!((EnumCube)enum_).isEnabled()) continue;
            ItemRegistry.registerItemStack(((EnumCube)enum_).getTag(), ((EnumCube)enum_).getItem());
        }
        for (Enum enum_ : EnumPost.values()) {
            if (!((EnumPost)enum_).isEnabled()) continue;
            ItemRegistry.registerItemStack(((EnumPost)enum_).getTag(), ((EnumPost)enum_).getItem());
        }
        if (RailcraftBlocks.getBlockPostMetal() != null) {
            for (Enum enum_ : EnumColor.values()) {
                ItemRegistry.registerItemStack("post.metal." + ((EnumColor)enum_).getBasicTag(), BlockPostMetal.getItem(1, enum_.ordinal()));
            }
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Game.log(Level.FINE, "Post-Init Phase", new Object[0]);
        ModuleManager.postInit();
        proxy.initClient();
        CraftGuidePlugin.init();
    }

    @Mod.EventHandler
    public void serverCleanUp(FMLServerStoppingEvent event) {
        LinkageManager.reset();
    }

    static {
        thisIsFalse = false;
    }
}

