/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.tracks.ITrackSwitch;
import mods.railcraft.common.blocks.tracks.EnumTrackMeta;
import mods.railcraft.common.blocks.tracks.TrackBaseRailcraft;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.BlockRailBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class TrackSwitchBase
extends TrackBaseRailcraft
implements ITrackSwitch {
    private static final int SPRING_DURATION = 30;
    protected boolean mirrored;
    protected boolean switched;
    private byte sprung;
    private byte locked;

    @Override
    public boolean canMakeSlopes() {
        return false;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public boolean isFlexibleRail() {
        return false;
    }

    @Override
    public boolean isMirrored() {
        return this.mirrored;
    }

    @Override
    public boolean isSwitched() {
        return !this.isLocked() && (this.switched || this.isSprung());
    }

    public boolean isLocked() {
        return this.locked > 0;
    }

    @Override
    public void onBlockPlaced() {
        this.determineTrackMeta();
        this.determineMirror();
    }

    protected void determineTrackMeta() {
        int x = this.tileEntity.field_70329_l;
        int y = this.tileEntity.field_70330_m;
        int z = this.tileEntity.field_70327_n;
        int meta = this.tileEntity.func_70322_n();
        if (BlockRailBase.func_72180_d_((World)this.getWorld(), (int)(x + 1), (int)y, (int)z) && BlockRailBase.func_72180_d_((World)this.getWorld(), (int)(x - 1), (int)y, (int)z)) {
            if (meta != EnumTrackMeta.EAST_WEST.ordinal()) {
                this.getWorld().func_72921_c(x, y, z, EnumTrackMeta.EAST_WEST.ordinal(), 3);
            }
        } else if (BlockRailBase.func_72180_d_((World)this.getWorld(), (int)x, (int)y, (int)(z + 1)) && BlockRailBase.func_72180_d_((World)this.getWorld(), (int)x, (int)y, (int)(z - 1))) {
            if (meta != EnumTrackMeta.NORTH_SOUTH.ordinal()) {
                this.getWorld().func_72921_c(x, y, z, EnumTrackMeta.NORTH_SOUTH.ordinal(), 3);
            }
        } else if (meta != EnumTrackMeta.NORTH_SOUTH.ordinal()) {
            this.getWorld().func_72921_c(x, y, z, EnumTrackMeta.NORTH_SOUTH.ordinal(), 3);
        }
    }

    protected void determineMirror() {
        int x = this.tileEntity.field_70329_l;
        int y = this.tileEntity.field_70330_m;
        int z = this.tileEntity.field_70327_n;
        int meta = this.tileEntity.func_70322_n();
        boolean prevValue = this.isMirrored();
        if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
            int otherMeta;
            int ii = x;
            if (BlockRailBase.func_72180_d_((World)this.getWorld(), (int)(x - 1), (int)y, (int)z)) {
                --ii;
                this.mirrored = true;
            } else {
                ++ii;
                this.mirrored = false;
            }
            if (BlockRailBase.func_72180_d_((World)this.getWorld(), (int)ii, (int)y, (int)z) && (otherMeta = this.getWorld().func_72805_g(ii, y, z)) == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
                this.getWorld().func_72921_c(ii, y, z, EnumTrackMeta.EAST_WEST.ordinal(), 3);
            }
        } else if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
            this.mirrored = BlockRailBase.func_72180_d_((World)this.getWorld(), (int)x, (int)y, (int)(z - 1));
        }
        if (prevValue != this.isMirrored()) {
            this.sendUpdateToClient();
        }
    }

    @Override
    public void onNeighborBlockChange(int id) {
        if (Game.isHost(this.getWorld())) {
            this.determineTrackMeta();
            this.determineMirror();
        }
        super.onNeighborBlockChange(id);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("Direction", this.mirrored);
        data.func_74757_a("Switched", this.switched);
        data.func_74774_a("sprung", this.sprung);
        data.func_74774_a("locked", this.locked);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.mirrored = data.func_74767_n("Direction");
        this.switched = data.func_74767_n("Switched");
        this.sprung = data.func_74771_c("sprung");
        this.locked = data.func_74771_c("locked");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.mirrored);
        data.writeBoolean(this.switched);
        data.writeByte(this.locked);
        data.writeByte(this.sprung);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.mirrored = data.readBoolean();
        this.switched = data.readBoolean();
        this.locked = data.readByte();
        this.sprung = data.readByte();
        this.markBlockNeedsUpdate();
    }

    @Override
    public void setSwitched(boolean switched) {
        if (this.switched != switched) {
            this.switched = switched;
            this.sendUpdateToClient();
        }
    }

    public boolean isSprung() {
        return this.sprung > 0;
    }

    @Override
    public void updateEntity() {
        boolean springState;
        boolean wasLocked;
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        boolean bl = wasLocked = this.locked == 0;
        if (this.locked > 0) {
            this.locked = (byte)(this.locked - 1);
        }
        if (this.shouldLockSwitch()) {
            this.locked = (byte)30;
        }
        boolean bl2 = springState = this.sprung == 0;
        if (this.sprung > 0) {
            this.sprung = (byte)(this.sprung - 1);
        }
        if (!this.isLocked() && this.shouldSpringSwitch()) {
            this.sprung = (byte)30;
        }
        if (springState != (this.sprung == 0) || wasLocked != (this.locked == 0)) {
            this.sendUpdateToClient();
        }
    }

    protected abstract boolean shouldLockSwitch();

    protected abstract boolean shouldSpringSwitch();
}

