/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.TileBoxBase;
import mods.railcraft.common.blocks.signals.TileBoxCapacitor;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public class TileBoxSequencer
extends TileBoxBase {
    private static final int MAX_ITERATIONS = 64;
    private ForgeDirection sideOutput = ForgeDirection.NORTH;
    private boolean powerState = false;
    private boolean neighborState = false;

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.BOX_SEQUENCER;
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        boolean p = PowerPlugin.isBlockBeingPoweredByRepeater(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (!this.powerState && p) {
            this.powerState = p;
            this.incrementSequencer(true, new HashSet(), 0);
        } else {
            this.powerState = p;
        }
    }

    @Override
    public void onNeighborStateChange(TileBoxBase neighbor, ForgeDirection side) {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        if (neighbor instanceof TileBoxSequencer) {
            return;
        }
        if (neighbor instanceof TileBoxCapacitor) {
            return;
        }
        boolean p = neighbor.isEmitingRedstone(side);
        if (!this.neighborState && p) {
            this.neighborState = p;
            this.incrementSequencer(true, new HashSet(), 0);
        } else {
            this.neighborState = p;
        }
    }

    private void incrementSequencer(boolean firstPass, Set visitedFirstPass, int numberOfIterations) {
        ForgeDirection newSide;
        if (firstPass) {
            visitedFirstPass.add(this);
            TileEntity tile = this.tileCache.getTileOnSide(this.sideOutput);
            if (tile instanceof TileBoxSequencer && !visitedFirstPass.contains(tile)) {
                TileBoxSequencer box = (TileBoxSequencer)tile;
                box.incrementSequencer(true, visitedFirstPass, numberOfIterations);
                return;
            }
        }
        for (newSide = this.sideOutput.getRotation(ForgeDirection.UP); newSide != this.sideOutput && !this.canOutputToSide(newSide); newSide = newSide.getRotation(ForgeDirection.UP)) {
        }
        this.sideOutput = newSide;
        this.updateNeighbors();
        if (numberOfIterations >= 64) {
            return;
        }
        TileEntity tile = this.tileCache.getTileOnSide(this.sideOutput);
        if (tile instanceof TileBoxSequencer) {
            TileBoxSequencer box = (TileBoxSequencer)tile;
            box.incrementSequencer(false, visitedFirstPass, numberOfIterations + 1);
        }
    }

    private boolean canOutputToSide(ForgeDirection side) {
        TileEntity tile = this.tileCache.getTileOnSide(side);
        if (tile instanceof TileBoxSequencer) {
            return true;
        }
        if (tile instanceof TileBoxBase) {
            return ((TileBoxBase)tile).canReceiveAspect();
        }
        Block block = WorldPlugin.getBlockOnSide((IBlockAccess)this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, side);
        if (block == Block.field_72075_av) {
            return true;
        }
        if (block == Block.field_72010_bh || block == Block.field_72011_bi) {
            int facing = BlockDirectional.func_72217_d((int)MiscTools.getBlockMetadataOnSide((IBlockAccess)this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, side));
            switch (side) {
                case NORTH: {
                    return facing == 0;
                }
                case SOUTH: {
                    return facing == 2;
                }
                case EAST: {
                    return facing == 1;
                }
                case WEST: {
                    return facing == 3;
                }
            }
        }
        return false;
    }

    private void updateNeighbors() {
        this.sendUpdateToClient();
        this.notifyBlocksOfNeighborChange();
        this.updateNeighborBoxes();
    }

    @Override
    public int getPowerOutput(int side) {
        TileEntity tile = this.tileCache.getTileOnSide(MiscTools.getOppositeSide(side));
        if (tile instanceof TileBoxBase) {
            return 0;
        }
        return this.sideOutput.getOpposite().ordinal() == side ? 15 : 0;
    }

    @Override
    public boolean isEmitingRedstone(ForgeDirection side) {
        return this.sideOutput == side;
    }

    @Override
    public SignalAspect getBoxSignalAspect(ForgeDirection side) {
        return this.sideOutput == side ? SignalAspect.GREEN : SignalAspect.RED;
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74774_a("sideOutput", (byte)this.sideOutput.ordinal());
        data.func_74757_a("powerState", this.powerState);
        data.func_74757_a("neighborState", this.neighborState);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.sideOutput = ForgeDirection.getOrientation((int)data.func_74771_c("sideOutput"));
        this.powerState = data.func_74767_n("powerState");
        this.neighborState = data.func_74767_n("neighborState");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.sideOutput.ordinal());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.sideOutput = ForgeDirection.getOrientation((int)data.readByte());
        this.markBlockForUpdate();
    }

    @Override
    public boolean isConnected(ForgeDirection side) {
        TileEntity tile = this.tileCache.getTileOnSide(side);
        if (tile instanceof TileBoxSequencer) {
            return true;
        }
        if (tile instanceof TileBoxBase) {
            return ((TileBoxBase)tile).canReceiveAspect() || ((TileBoxBase)tile).canTransferAspect();
        }
        return false;
    }

    @Override
    public boolean canTransferAspect() {
        return true;
    }

    @Override
    public boolean canReceiveAspect() {
        return true;
    }
}

