/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.common.blocks.signals.TileSignalFoundation;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public abstract class TileBoxBase
extends TileSignalFoundation {
    private static final float BOUND = 0.1f;

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess world, int i, int j, int k) {
        this.func_70311_o().func_71905_a(0.1f, 0.0f, 0.1f, 0.9f, 0.95f, 0.9f);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)i + 0.1f), (double)j, (double)((float)k + 0.1f), (double)((float)(i + 1) - 0.1f), (double)((float)(j + 1) - 0.05f), (double)((float)(k + 1) - 0.1f));
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)i + 0.1f), (double)j, (double)((float)k + 0.1f), (double)((float)(i + 1) - 0.1f), (double)((float)(j + 1) - 0.05f), (double)((float)(k + 1) - 0.1f));
    }

    public boolean canUpdate() {
        return true;
    }

    public abstract boolean isConnected(ForgeDirection var1);

    public abstract SignalAspect getBoxSignalAspect(ForgeDirection var1);

    public boolean canTransferAspect() {
        return false;
    }

    public boolean canReceiveAspect() {
        return false;
    }

    public void onNeighborStateChange(TileBoxBase neighbor, ForgeDirection side) {
    }

    public final void updateNeighborBoxes() {
        for (int side = 2; side < 6; ++side) {
            ForgeDirection forgeSide = ForgeDirection.getOrientation((int)side);
            TileEntity tile = this.tileCache.getTileOnSide(forgeSide);
            if (!(tile instanceof TileBoxBase)) continue;
            TileBoxBase box = (TileBoxBase)tile;
            box.onNeighborStateChange(this, forgeSide);
        }
    }

    public boolean isEmitingRedstone(ForgeDirection side) {
        return false;
    }

    public boolean canEmitingRedstone(ForgeDirection side) {
        return false;
    }

    @Override
    public boolean isBlockSolidOnSide(World world, int i, int j, int k, ForgeDirection side) {
        return side == ForgeDirection.UP;
    }

    @Override
    public boolean canConnectRedstone(int dir) {
        return true;
    }
}

