/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Level;
import mods.railcraft.api.core.items.ITrackItem;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.machine.BlockMachine;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.items.IActivationBlockingItem;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.AdjacentTileCache;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRail;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public abstract class TileMachineBase
extends RailcraftTileEntity {
    private boolean checkedBlock = false;
    protected final AdjacentTileCache tileCache = new AdjacentTileCache(this);

    public abstract IEnumMachine getMachineType();

    @Override
    public String func_70303_b() {
        return RailcraftLanguage.translate(this.getMachineType().getTag());
    }

    @Override
    public final short getId() {
        return (short)this.getMachineType().ordinal();
    }

    public boolean canCreatureSpawn(EnumCreatureType type) {
        return true;
    }

    public ArrayList getBlockDropped(int fortune) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(this.getMachineType().getItem());
        return items;
    }

    public ArrayList getBlockDroppedSilkTouch(int fortune) {
        return this.getBlockDropped(fortune);
    }

    public boolean canSilkHarvest(EntityPlayer player) {
        return false;
    }

    public void initFromItem(ItemStack stack) {
    }

    public void onBlockAdded() {
    }

    public void onBlockRemoval() {
        if (this instanceof IInventory) {
            InvTools.dropInventory((IInventory)this, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    public boolean blockActivated(EntityPlayer player, int side) {
        if (player.func_70093_af()) {
            return false;
        }
        ItemStack stack = player.func_71045_bC();
        if (stack != null) {
            if (stack.func_77973_b() instanceof IActivationBlockingItem) {
                return false;
            }
            if (stack.func_77973_b() instanceof ITrackItem) {
                return false;
            }
            if (stack.field_77993_c < Block.field_71973_m.length && BlockRail.func_72184_d((int)stack.field_77993_c)) {
                return false;
            }
        }
        return this.openGui(player);
    }

    public boolean rotateBlock(ForgeDirection axis) {
        return false;
    }

    public ForgeDirection[] getValidRotations() {
        return ForgeDirection.VALID_DIRECTIONS;
    }

    public boolean isBlockSolidOnSide(ForgeDirection side) {
        return true;
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (Game.isNotHost(this.field_70331_k)) {
            return;
        }
        if (!this.checkedBlock) {
            this.checkedBlock = true;
            if (!this.getMachineType().isAvaliable()) {
                this.field_70331_k.func_94571_i(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                return;
            }
            if (this.func_70311_o() != this.getMachineType().getBlock()) {
                Game.log(Level.INFO, "Updating Machine Tile Block Id: {0}, [{1}, {2}, {3}]", this.getClass().getSimpleName(), this.field_70329_l, this.field_70330_m, this.field_70327_n);
                this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getMachineType().getBlockId(), (int)this.getId(), 3);
                this.func_70312_q();
                this.field_70331_k.func_72837_a(this.field_70329_l, this.field_70330_m, this.field_70327_n, (TileEntity)this);
                this.func_70321_h();
            }
            if (this.func_70311_o() != null && this.getClass() != ((BlockMachine)this.func_70311_o()).getMachineProxy().getTileClass(this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n))) {
                this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getMachineType().getBlockId(), (int)this.getId(), 3);
                Game.log(Level.INFO, "Updating Machine Tile Metadata: {0}, [{1}, {2}, {3}]", this.getClass().getSimpleName(), this.field_70329_l, this.field_70330_m, this.field_70327_n);
                this.func_70321_h();
            }
        }
    }

    public void func_70313_j() {
        this.tileCache.purge();
        super.func_70313_j();
    }

    public void func_70312_q() {
        this.tileCache.purge();
        super.func_70312_q();
    }

    public void onNeighborBlockChange(int id) {
        this.tileCache.onNeighborChange();
    }

    public boolean openGui(EntityPlayer player) {
        return false;
    }

    public Icon getIcon(int side) {
        return null;
    }

    public int getLightValue() {
        return 0;
    }

    public float getResistance(Entity exploder) {
        return 4.5f;
    }

    public float getHardness() {
        return 2.0f;
    }

    public boolean isPoweringTo(int side) {
        return false;
    }

    public boolean canConnectRedstone(int dir) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(Random rand) {
    }

    public int colorMultiplier() {
        return 0xFFFFFF;
    }

    public boolean recolourBlock(int color) {
        return false;
    }
}

