/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.slab;

import mods.railcraft.common.blocks.aesthetics.slab.BlockRailcraftSlab;
import mods.railcraft.common.blocks.aesthetics.slab.EnumSlab;
import mods.railcraft.common.blocks.aesthetics.slab.TileSlab;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class ItemSlab
extends ItemBlock {
    public ItemSlab(int id) {
        super(id);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77655_b("railcraft.slab");
    }

    public String func_77667_c(ItemStack stack) {
        return EnumSlab.fromOrdinal(stack.func_77960_j()).getTag();
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (stack.field_77994_a == 0) {
            return false;
        }
        if (!player.func_82247_a(x, y, z, side, stack)) {
            return false;
        }
        if (this.isSingleSlab(world, x, y, z, side)) {
            this.tryAddSlab(world, x, y, z, stack);
            return true;
        }
        if (this.isSingleSlabShifted(world, x, y, z, side)) {
            ForgeDirection s = ForgeDirection.getOrientation((int)side);
            x = MiscTools.getXOnSide(x, s);
            y = MiscTools.getYOnSide(y, s);
            z = MiscTools.getZOnSide(z, s);
            this.tryAddSlab(world, x, y, z, stack);
            return true;
        }
        return super.func_77648_a(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    private boolean isSingleSlab(World world, int x, int y, int z, int side) {
        TileSlab slab;
        if (world.func_72798_a(x, y, z) == this.func_77883_f() && (slab = BlockRailcraftSlab.getSlabTile((IBlockAccess)world, x, y, z)) != null) {
            boolean up = slab.isTopSlab();
            if ((side == 1 && !up || side == 0 && up) && !slab.isDoubleSlab()) {
                return true;
            }
        }
        return false;
    }

    private boolean isSingleSlabShifted(World world, int x, int y, int z, int side) {
        TileSlab slab;
        ForgeDirection s = ForgeDirection.getOrientation((int)side);
        return world.func_72798_a(x = MiscTools.getXOnSide(x, s), y = MiscTools.getYOnSide(y, s), z = MiscTools.getZOnSide(z, s)) == this.func_77883_f() && (slab = BlockRailcraftSlab.getSlabTile((IBlockAccess)world, x, y, z)) != null && !slab.isDoubleSlab();
    }

    private void tryAddSlab(World world, int x, int y, int z, ItemStack stack) {
        BlockRailcraftSlab block;
        TileSlab slab = BlockRailcraftSlab.getSlabTile((IBlockAccess)world, x, y, z);
        if (slab != null && world.func_72855_b((block = BlockRailcraftSlab.getBlock()).func_71872_e(world, x, y, z)) && slab.addSlab(EnumSlab.fromOrdinal(stack.func_77960_j()))) {
            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), ((Block)block).field_72020_cn.func_82593_b(), (((Block)block).field_72020_cn.func_72677_b() + 1.0f) / 2.0f, ((Block)block).field_72020_cn.func_72678_c() * 0.8f);
            --stack.field_77994_a;
        }
    }

    public boolean func_77884_a(World world, int x, int y, int z, int side, EntityPlayer par6EntityPlayer, ItemStack stack) {
        if (this.isSingleSlab(world, x, y, z, side)) {
            return true;
        }
        if (this.isSingleSlabShifted(world, x, y, z, side)) {
            return true;
        }
        return super.func_77884_a(world, x, y, z, side, par6EntityPlayer, stack);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        int blockID = this.func_77883_f();
        Block block = Block.field_71973_m[blockID];
        if (!world.func_72855_b(block.func_71872_e(world, x, y, z))) {
            return false;
        }
        if (!world.func_94575_c(x, y, z, blockID)) {
            return false;
        }
        if (world.func_72798_a(x, y, z) == blockID) {
            TileSlab slab = BlockRailcraftSlab.getSlabTile((IBlockAccess)world, x, y, z);
            if (slab != null) {
                if (side != 0 && (side == 1 || (double)hitY <= 0.5)) {
                    slab.setBottomSlab(EnumSlab.fromOrdinal(stack.func_77960_j()));
                } else {
                    slab.setTopSlab(EnumSlab.fromOrdinal(stack.func_77960_j()));
                }
            }
            Block.field_71973_m[blockID].func_71860_a(world, x, y, z, (EntityLivingBase)player, stack);
            Block.field_71973_m[blockID].func_85105_g(world, x, y, z, metadata);
        }
        return true;
    }
}

