/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.post;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mods.railcraft.api.core.IPostConnection;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.aesthetics.post.BlockPostBase;
import mods.railcraft.common.blocks.aesthetics.post.BlockPostMetal;
import mods.railcraft.common.blocks.aesthetics.post.EnumPost;
import mods.railcraft.common.blocks.aesthetics.post.ItemPost;
import mods.railcraft.common.blocks.aesthetics.post.TilePostEmblem;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.EnumColor;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;

public class BlockPost
extends BlockPostBase
implements IPostConnection {
    protected BlockPost(int id, int renderType) {
        super(id, renderType);
        this.func_71864_b("railcraft.post");
    }

    public static Block make(int id, int renderType) {
        BlockPost block = new BlockPost(id, renderType);
        GameRegistry.registerBlock((Block)block, ItemPost.class, (String)block.func_71917_a());
        MinecraftForge.setBlockHarvestLevel((Block)block, (String)"crowbar", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)block, (int)EnumPost.WOOD.ordinal(), (String)"axe", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)block, (int)EnumPost.STONE.ordinal(), (String)"pickaxe", (int)1);
        MinecraftForge.setBlockHarvestLevel((Block)block, (int)EnumPost.METAL.ordinal(), (String)"pickaxe", (int)2);
        MinecraftForge.setBlockHarvestLevel((Block)block, (int)EnumPost.EMBLEM.ordinal(), (String)"pickaxe", (int)2);
        ForestryPlugin.addBackpackItem("builder", block);
        return block;
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (EnumPost post : EnumPost.values()) {
            if (post == EnumPost.EMBLEM) continue;
            list.add(post.getItem());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        EnumPost.WOOD.setTexture(iconRegister.func_94245_a("railcraft:post.wood"));
        EnumPost.STONE.setTexture(iconRegister.func_94245_a("railcraft:concrete"));
        EnumPost.METAL.setTexture(iconRegister.func_94245_a("railcraft:post.metal"));
        EnumPost.EMBLEM.setTexture(iconRegister.func_94245_a("railcraft:post.metal"));
    }

    public Icon func_71858_a(int side, int meta) {
        return EnumPost.fromId(meta).getIcon();
    }

    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        TilePostEmblem post;
        EnumColor color;
        TileEntity tile;
        int meta = world.func_72805_g(x, y, z);
        if (meta == EnumPost.EMBLEM.ordinal() && (tile = world.func_72796_p(x, y, z)) instanceof TilePostEmblem && (color = (post = (TilePostEmblem)tile).getColor()) != null && BlockPostMetal.textures != null) {
            return BlockPostMetal.textures[color.ordinal()];
        }
        return super.func_71895_b(world, x, y, z, side);
    }

    @Override
    public int func_71899_b(int meta) {
        return meta;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 1;
    }

    public ArrayList getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        TileEntity tile;
        if (metadata == EnumPost.EMBLEM.ordinal() && (tile = world.func_72796_p(x, y, z)) instanceof TilePostEmblem) {
            TilePostEmblem post = (TilePostEmblem)tile;
            ArrayList drops = super.getBlockDropped(world, x, y, z, metadata, fortune);
            InvTools.setItemColor((ItemStack)drops.get(0), post.getColor());
            ItemPost.setEmblem((ItemStack)drops.get(0), post.getEmblem());
            return drops;
        }
        return super.getBlockDropped(world, x, y, z, metadata, fortune);
    }

    public void func_71893_a(World world, EntityPlayer entityplayer, int i, int j, int k, int l) {
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        player.func_71064_a(StatList.field_75934_C[this.field_71990_ca], 1);
        player.func_71020_j(0.025f);
        if (Game.isHost(world) && !player.field_71075_bZ.field_75098_d) {
            this.func_71897_c(world, x, y, z, world.func_72805_g(x, y, z), 0);
        }
        return world.func_94571_i(x, y, z);
    }

    @Override
    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == EnumPost.EMBLEM.ordinal()) {
            return false;
        }
        return side == ForgeDirection.DOWN || side == ForgeDirection.UP;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata == EnumPost.EMBLEM.ordinal()) {
            return new TilePostEmblem();
        }
        return null;
    }

    public boolean hasTileEntity(int metadata) {
        return metadata == EnumPost.EMBLEM.ordinal();
    }

    public int getFireSpreadSpeed(World world, int x, int y, int z, int metadata, ForgeDirection face) {
        if (metadata == EnumPost.WOOD.ordinal()) {
            return 300;
        }
        return 0;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        if (metadata == EnumPost.WOOD.ordinal()) {
            return 5;
        }
        return 0;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return metadata == EnumPost.WOOD.ordinal();
    }

    public boolean recolourBlock(World world, int x, int y, int z, ForgeDirection side, int colour) {
        TileEntity tile;
        Block block;
        int meta = world.func_72805_g(x, y, z);
        if (meta == EnumPost.METAL.ordinal() && (block = RailcraftBlocks.getBlockPostMetal()) != null) {
            world.func_72832_d(x, y, z, block.field_71990_ca, 15 - colour, 3);
            return true;
        }
        if (meta == EnumPost.EMBLEM.ordinal() && (tile = world.func_72796_p(x, y, z)) instanceof TilePostEmblem) {
            TilePostEmblem tileEmblem = (TilePostEmblem)tile;
            tileEmblem.setColor(EnumColor.fromId(15 - colour));
            return true;
        }
        return false;
    }

    @Override
    public boolean connectsAt(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    @Override
    public IPostConnection.ConnectStyle connectsToPost(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        TilePostEmblem tileEmblem;
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TilePostEmblem && (tileEmblem = (TilePostEmblem)tile).getFacing() == side) {
            return IPostConnection.ConnectStyle.NONE;
        }
        return IPostConnection.ConnectStyle.TWO_THIN;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        TileEntity tile;
        super.func_71860_a(world, x, y, z, entity, stack);
        int meta = world.func_72805_g(x, y, z);
        if (meta == EnumPost.EMBLEM.ordinal() && (tile = world.func_72796_p(x, y, z)) instanceof TilePostEmblem) {
            TilePostEmblem post = (TilePostEmblem)tile;
            post.setFacing(MiscTools.getHorizontalSideClosestToPlayer(world, x, y, z, entity));
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt != null) {
                if (nbt.func_74764_b("color")) {
                    post.setColor(EnumColor.fromId(nbt.func_74771_c("color")));
                }
                if (nbt.func_74764_b("emblem")) {
                    post.setEmblem(nbt.func_74779_i("emblem"));
                }
            }
        }
    }
}

