/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.util.textures;

import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.io.IOException;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.Resource;
import net.minecraft.client.resources.ResourceManager;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;

public class TextureAtlasSheet
extends TextureAtlasSprite {
    private final int index;
    private final int rows;
    private final int columns;

    public static Icon[] unstitchIcons(IconRegister iconRegister, String name, int numIcons) {
        return TextureAtlasSheet.unstitchIcons(iconRegister, name, numIcons, 1);
    }

    public static Icon[] unstitchIcons(IconRegister iconRegister, String name, int columns, int rows) {
        TextureMap textureMap = (TextureMap)iconRegister;
        int numIcons = rows * columns;
        Icon[] icons = new Icon[numIcons];
        for (int i = 0; i < numIcons; ++i) {
            String texName = name + "." + i;
            TextureAtlasSheet texture = new TextureAtlasSheet(texName, i, rows, columns);
            textureMap.setTextureEntry(texName, (TextureAtlasSprite)texture);
            icons[i] = texture;
        }
        return icons;
    }

    private TextureAtlasSheet(String name, int index, int rows, int columns) {
        super(name);
        this.index = index;
        this.rows = rows;
        this.columns = columns;
    }

    public boolean load(ResourceManager manager, ResourceLocation location) throws IOException {
        BufferedImage subImage;
        BufferedImage image;
        String fileName = location.func_110623_a().replace("." + this.index, "");
        try {
            Resource res = manager.func_110536_a(new ResourceLocation(location.func_110624_b(), fileName));
            image = ImageIO.read(res.func_110527_b());
        }
        catch (IOException ex) {
            Game.log(Level.WARNING, "Failed to load sub-texture from {0}: {1}", fileName, ex.getLocalizedMessage());
            return true;
        }
        int size = image.getHeight() / this.rows;
        int x = this.index % this.columns;
        int y = this.index / this.columns;
        try {
            subImage = image.getSubimage(x * size, y * size, size, size);
        }
        catch (RasterFormatException ex) {
            Game.log(Level.WARNING, "Failed to load sub-texture from {0} - {1}x{2}: {3}", fileName, image.getWidth(), image.getHeight(), ex.getLocalizedMessage());
            throw ex;
        }
        this.field_130224_d = subImage.getHeight();
        this.field_130223_c = subImage.getWidth();
        int[] imageData = new int[this.field_130224_d * this.field_130223_c];
        subImage.getRGB(0, 0, this.field_130223_c, this.field_130224_d, imageData, 0, this.field_130223_c);
        this.field_110976_a.add(imageData);
        return true;
    }
}

