/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import mods.railcraft.client.gui.GuiTools;
import mods.railcraft.client.gui.TileGui;
import mods.railcraft.client.gui.buttons.GuiMultiButton;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.tracks.TrackRouting;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.gui.buttons.LockButtonState;
import mods.railcraft.common.gui.containers.ContainerTrackRouting;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.StatCollector;

public class GuiTrackRouting
extends TileGui {
    private GuiMultiButton lockButton;
    private final EntityPlayer player;
    private final TrackRouting track;
    private ToolTip lockedToolTips;
    private ToolTip unlockedToolTips;
    private ToolTip notownedToolTips;
    private String owner = "[Unknown]";

    public GuiTrackRouting(InventoryPlayer inv, TrackRouting track) {
        super((RailcraftTileEntity)track.getTile(), new ContainerTrackRouting(inv, track), "railcraft:textures/gui/gui_track_routing.png");
        this.field_74195_c = 140;
        this.track = track;
        this.player = inv.field_70458_d;
        this.lockedToolTips = ToolTip.buildToolTip("gui.tip.button.lock.locked", "{owner}=" + this.owner);
        this.unlockedToolTips = ToolTip.buildToolTip("gui.tip.button.lock.unlocked", "{owner}=" + this.owner);
        this.notownedToolTips = ToolTip.buildToolTip("gui.tip.button.lock.notowner", "{owner}=" + this.owner);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.track == null) {
            return;
        }
        this.field_73887_h.clear();
        int w = (this.field_73880_f - this.field_74194_b) / 2;
        int h = (this.field_73881_g - this.field_74195_c) / 2;
        this.lockButton = new GuiMultiButton(8, w + 152, h + 8, 16, this.track.getLockController());
        this.field_73887_h.add(this.lockButton);
        this.lockButton.field_73742_g = ((ContainerTrackRouting)this.container).canLock;
    }

    protected void func_73875_a(GuiButton guibutton) {
        if (this.track == null) {
            return;
        }
        this.updateButtons();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.updateButtons();
    }

    private void updateButtons() {
        this.lockButton.field_73742_g = ((ContainerTrackRouting)this.container).canLock;
        String o = ((ContainerTrackRouting)this.container).owner;
        if (!this.owner.equals(o)) {
            this.owner = o;
            this.lockedToolTips = ToolTip.buildToolTip("gui.tip.button.lock.locked", "{owner}=" + this.owner);
            this.unlockedToolTips = ToolTip.buildToolTip("gui.tip.button.lock.unlocked", "{owner}=" + this.owner);
            this.notownedToolTips = ToolTip.buildToolTip("gui.tip.button.lock.notowner", "{owner}=" + this.owner);
        }
        this.lockButton.setToolTip(this.track.getLockController().getButtonState() == LockButtonState.LOCKED ? this.lockedToolTips : (this.lockButton.field_73742_g ? this.unlockedToolTips : this.notownedToolTips));
    }

    public void func_73874_b() {
        this.sendUpdatePacket();
    }

    private void sendUpdatePacket() {
        PacketBuilder.instance().sendGuiReturnPacket((IGuiReturnHandler)this.track.getTile());
    }

    protected void func_74189_g(int mouseX, int mouseY) {
        GuiTools.drawCenteredString(this.field_73886_k, this.track.func_70303_b(), 6);
        this.field_73886_k.func_78276_b(RailcraftLanguage.translate("routing.track.slot.label"), 64, 29, 0x404040);
        this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), 8, this.field_74195_c - 96 + 2, 0x404040);
    }
}

