/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.circuits.ChipsetManager;
import forestry.api.core.PluginInfo;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.core.CommandForestry;
import forestry.core.CreativeTabForestry;
import forestry.core.GameMode;
import forestry.core.PickupHandlerCore;
import forestry.core.SaveEventHandlerCore;
import forestry.core.circuits.CircuitRegistry;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.circuits.ItemSolderingIron;
import forestry.core.config.Config;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.BlockBase;
import forestry.core.gadgets.BlockResource;
import forestry.core.gadgets.BlockSoil;
import forestry.core.gadgets.BlockStainedGlass;
import forestry.core.gadgets.MachineDefinition;
import forestry.core.gadgets.TileAnalyzer;
import forestry.core.gadgets.TileEscritoire;
import forestry.core.genetics.Allele;
import forestry.core.genetics.AlleleRegistry;
import forestry.core.genetics.ItemResearchNote;
import forestry.core.interfaces.IOreDictionaryHandler;
import forestry.core.interfaces.IPickupHandler;
import forestry.core.interfaces.ISaveEventHandler;
import forestry.core.items.ItemArmorNaturalist;
import forestry.core.items.ItemAssemblyKit;
import forestry.core.items.ItemCrated;
import forestry.core.items.ItemForestry;
import forestry.core.items.ItemForestryBlock;
import forestry.core.items.ItemForestryPickaxe;
import forestry.core.items.ItemForestryShovel;
import forestry.core.items.ItemFruit;
import forestry.core.items.ItemLiquidContainer;
import forestry.core.items.ItemMisc;
import forestry.core.items.ItemOverlay;
import forestry.core.items.ItemPipette;
import forestry.core.items.ItemScoop;
import forestry.core.items.ItemWrench;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ForestryModEnvWarningCallable;
import forestry.core.utils.ShapedRecipeCustom;
import forestry.core.utils.Utils;
import forestry.plugins.NativePlugin;
import forestry.plugins.PluginApiculture;
import forestry.plugins.PluginBuildCraft;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;

@PluginInfo(pluginID="Core", name="Core", author="SirSengir", url="http://forestry.sengir.net/", description="Core mechanics for Forestry. Required by all other plugins.")
public class PluginCore
extends NativePlugin
implements IFuelHandler {
    public static MachineDefinition definitionAnalyzer;
    public static MachineDefinition definitionEscritoire;
    public static ForestryModEnvWarningCallable crashCallable;
    private static ArrayList jvzazHIklleTCdjQ;

    @Override
    public void preInit() {
        super.preInit();
        ChipsetManager.solderManager = new ItemSolderingIron.SolderManager();
        CircuitRegistry circuitRegistry = new CircuitRegistry();
        ChipsetManager.circuitRegistry = circuitRegistry;
        circuitRegistry.initialize();
        AlleleRegistry alleleRegistry = new AlleleRegistry();
        AlleleManager.alleleRegistry = alleleRegistry;
        alleleRegistry.initialize();
        Allele.initialize();
        int blockid = Config.getOrCreateBlockIdProperty("core", 1409);
        definitionAnalyzer = new MachineDefinition(blockid, 0, "forestry.Analyzer", TileAnalyzer.class, PluginApiculture.proxy.getRendererAnalyzer("textures/blocks/analyzer_"), new IRecipe[0]);
        definitionEscritoire = new MachineDefinition(blockid, 1, "forestry.Escritoire", TileEscritoire.class, Proxies.render.getRenderEscritoire(), new IRecipe[0]);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.$aidRcE$();
        }
        ForestryBlock.core = new BlockBase(blockid, Material.field_76243_f, true, definitionAnalyzer, definitionEscritoire).func_71864_b("for.core");
        Proxies.common.registerBlock(ForestryBlock.core, ItemForestryBlock.class);
        ForestryBlock.soil = new BlockSoil(Config.getOrCreateBlockIdProperty("soil", 1397)).func_71864_b("soil");
        Proxies.common.registerBlock(ForestryBlock.soil, ItemForestryBlock.class);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.soil, (int)0, (String)"shovel", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.soil, (int)1, (String)"shovel", (int)0);
        ForestryBlock.resources = new BlockResource(Config.getOrCreateBlockIdProperty("resources", 1398)).func_71864_b("resources");
        Proxies.common.registerBlock(ForestryBlock.resources, ItemForestryBlock.class);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.resources, (int)0, (String)"pickaxe", (int)1);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.resources, (int)1, (String)"pickaxe", (int)1);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.resources, (int)2, (String)"pickaxe", (int)1);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.$zotodKlgGgiNsjohohdt$();
        }
        OreDictionary.registerOre((String)"oreApatite", (ItemStack)new ItemStack(ForestryBlock.resources, 1, 0));
        OreDictionary.registerOre((String)"oreCopper", (ItemStack)new ItemStack(ForestryBlock.resources, 1, 1));
        OreDictionary.registerOre((String)"oreTin", (ItemStack)new ItemStack(ForestryBlock.resources, 1, 2));
        ForestryBlock.glass = new BlockStainedGlass(Config.getOrCreateBlockIdProperty("stained", 1381)).func_71864_b("stained");
        Proxies.common.registerBlock(ForestryBlock.glass, ItemForestryBlock.class);
        FurnaceRecipes.func_77602_a().addSmelting(ForestryBlock.resources.field_71990_ca, 1, ForestryItem.ingotCopper.getItemStack(), 0.5f);
        FurnaceRecipes.func_77602_a().addSmelting(ForestryBlock.resources.field_71990_ca, 2, ForestryItem.ingotTin.getItemStack(), 0.5f);
        GameRegistry.registerFuelHandler((IFuelHandler)this);
    }

    @Override
    public void doInit() {
        super.doInit();
        PluginCore.definitionAnalyzer.recipes = this.$vquiKnDxPlo$(ForestryBlock.core.field_71990_ca, 0);
        for (pnddhgeBOvsEi prop : jvzazHIklleTCdjQ) {
            prop.$biqblekeViAFdD$();
        }
        definitionAnalyzer.register();
        definitionEscritoire.register();
        crashCallable = new ForestryModEnvWarningCallable();
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return null;
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return new SaveEventHandlerCore();
    }

    @Override
    protected void registerItems() {
        ForestryItem.fertilizerBio.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("fertilizerBio", 5000)), "fertilizerBio");
        ForestryItem.fertilizerCompound.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("fertilizerCompound", 5001)).setBonemeal(true), "fertilizerCompound");
        ForestryItem.apatite.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("apatite", 5002)), "apatite");
        OreDictionary.registerOre((String)"gemApatite", (ItemStack)ForestryItem.apatite.getItemStack());
        ForestryItem.researchNote.registerItem(new ItemResearchNote(Config.getOrCreateItemIdProperty("researchNote", 13095)), "researchNote");
        ForestryItem.ingotCopper.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("ingotCopper", 5003)), "ingotCopper");
        ForestryItem.ingotTin.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("ingotTin", 5004)), "ingotTin");
        ForestryItem.ingotBronze.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("ingotBronze", 5005)), "ingotBronze");
        OreDictionary.registerOre((String)"ingotCopper", (ItemStack)ForestryItem.ingotCopper.getItemStack());
        OreDictionary.registerOre((String)"ingotTin", (ItemStack)ForestryItem.ingotTin.getItemStack());
        OreDictionary.registerOre((String)"ingotBronze", (ItemStack)ForestryItem.ingotBronze.getItemStack());
        ForestryItem.wrench.registerItem(new ItemWrench(Config.getOrCreateItemIdProperty("wrench", 5007)), "wrench");
        ForestryItem.pipette.registerItem(new ItemPipette(Config.getOrCreateItemIdProperty("pipette", 13111)), "pipette");
        ForestryItem.scoop.registerItem(new ItemScoop(Config.getOrCreateItemIdProperty("scoop", 13028)), "scoop");
        MinecraftForge.setToolClass((Item)ForestryItem.scoop.item(), (String)"scoop", (int)3);
        ForestryItem.sturdyCasing.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("sturdyMachine", 5010)), "sturdyMachine");
        ForestryItem.hardenedCasing.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("hardenedMachine", 5025)), "hardenedMachine");
        ForestryItem.impregnatedCasing.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("impregnatedCasing", 13124)), "impregnatedCasing");
        ForestryItem.craftingMaterial.registerItem(new ItemMisc(Config.getOrCreateItemIdProperty("craftingMaterial", 13098)), "craftingMaterial");
        ForestryItem.naturalistHat.registerItem((Item)new ItemArmorNaturalist(Config.getOrCreateItemIdProperty("naturalistHelmet", 13136), 0), "naturalistHelmet");
        ForestryItem.vialCatalyst.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("vialCatalyst", 5012)), "vialCatalyst");
        this.$iyptvvbjwPbU$();
        ForestryItem.waxCapsule.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsule", 13034), ItemLiquidContainer.EnumContainerType.CAPSULE, -1).func_77625_d(64), "waxCapsule");
        ForestryItem.canEmpty.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("canEmpty", 5021), ItemLiquidContainer.EnumContainerType.CAN, -1).func_77625_d(64), "canEmpty");
        ForestryItem.refractoryEmpty.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryEmpty", 13070), ItemLiquidContainer.EnumContainerType.REFRACTORY, -1).func_77625_d(64), "refractoryEmpty");
        ForestryItem.bucketBiomass.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("bucketBiomass", 5009)).func_77642_a(Item.field_77788_aw).func_77625_d(1), "bucketBiomass");
        ForestryItem.bucketBiofuel.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("bucketBiofuel", 5015)).func_77642_a(Item.field_77788_aw).func_77625_d(1), "bucketBiofuel");
        ForestryItem.waxCapsuleWater.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsuleWater", 13038), ItemLiquidContainer.EnumContainerType.CAPSULE, 2372332), "waxCapsuleWater");
        ForestryItem.waxCapsuleBiomass.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsuleBiomass", 13039), ItemLiquidContainer.EnumContainerType.CAPSULE, 8639516), "waxCapsuleBiomass");
        ForestryItem.waxCapsuleBiofuel.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsuleBiofuel", 13040), ItemLiquidContainer.EnumContainerType.CAPSULE, 16742665), "waxCapsuleBiofuel");
        ForestryItem.waxCapsuleOil.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsuleOil", 13042), ItemLiquidContainer.EnumContainerType.CAPSULE, 0x404040), "waxCapsuleOil");
        ForestryItem.waxCapsuleFuel.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsuleFuel", 13043), ItemLiquidContainer.EnumContainerType.CAPSULE, 0xFFFF00), "waxCapsuleFuel");
        ForestryItem.waxCapsuleSeedOil.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsuleSeedOil", 13065), ItemLiquidContainer.EnumContainerType.CAPSULE, 0xFFFFA9), "waxCapsuleSeedOil");
        ForestryItem.waxCapsuleHoney.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsuleHoney", 13066), ItemLiquidContainer.EnumContainerType.CAPSULE, 16767559).setDrink(2, 0.2f), "waxCapsuleHoney");
        ForestryItem.waxCapsuleJuice.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsuleJuice", 13067), ItemLiquidContainer.EnumContainerType.CAPSULE, 10080334).setDrink(2, 0.2f), "waxCapsuleJuice");
        ForestryItem.waxCapsuleIce.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waxCapsuleIce", 13121), ItemLiquidContainer.EnumContainerType.CAPSULE, 0xDCFFFF), "waxCapsuleIce");
        ForestryItem.canWater.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("waterCan", 5020), ItemLiquidContainer.EnumContainerType.CAN, 2372332), "waterCan");
        ForestryItem.canBiomass.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("biomassCan", 5022), ItemLiquidContainer.EnumContainerType.CAN, 8639516), "biomassCan");
        ForestryItem.canBiofuel.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("biofuelCan", 5023), ItemLiquidContainer.EnumContainerType.CAN, 16742665), "biofuelCan");
        ForestryItem.canOil.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("canOil", 13044), ItemLiquidContainer.EnumContainerType.CAN, 0x404040), "canOil");
        ForestryItem.canFuel.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("canFuel", 13045), ItemLiquidContainer.EnumContainerType.CAN, 0xFFFF00), "canFuel");
        ForestryItem.canLava.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("canLava", 13046), ItemLiquidContainer.EnumContainerType.CAN, 16598559), "canLava");
        ForestryItem.canSeedOil.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("canSeedOil", 13062), ItemLiquidContainer.EnumContainerType.CAN, 0xFFFFA9), "canSeedOil");
        ForestryItem.canHoney.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("canHoney", 13063), ItemLiquidContainer.EnumContainerType.CAN, 16767559).setDrink(2, 0.2f), "canHoney");
        ForestryItem.canJuice.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("canJuice", 13064), ItemLiquidContainer.EnumContainerType.CAN, 10080334).setDrink(2, 0.2f), "canJuice");
        ForestryItem.canIce.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("canIce", 13120), ItemLiquidContainer.EnumContainerType.CAN, 0xDCFFFF), "canIce");
        ForestryItem.refractoryWater.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryWater", 13075), ItemLiquidContainer.EnumContainerType.REFRACTORY, 2372332), "refractoryWater");
        ForestryItem.refractoryBiomass.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryBiomass", 13076), ItemLiquidContainer.EnumContainerType.REFRACTORY, 8639516), "refractoryBiomass");
        ForestryItem.refractoryBiofuel.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryBiofuel", 13077), ItemLiquidContainer.EnumContainerType.REFRACTORY, 16742665), "refractoryBiofuel");
        ForestryItem.refractoryOil.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryOil", 13078), ItemLiquidContainer.EnumContainerType.REFRACTORY, 0x404040), "refractoryOil");
        ForestryItem.refractoryFuel.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryFuel", 13079), ItemLiquidContainer.EnumContainerType.REFRACTORY, 0xFFFF00), "refractoryFuel");
        ForestryItem.refractoryLava.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryLava", 13071), ItemLiquidContainer.EnumContainerType.REFRACTORY, 16598559), "refractoryLava");
        ForestryItem.refractorySeedOil.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractorySeedOil", 13080), ItemLiquidContainer.EnumContainerType.REFRACTORY, 0xFFFFA9), "refractorySeedOil");
        ForestryItem.refractoryHoney.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryHoney", 13081), ItemLiquidContainer.EnumContainerType.REFRACTORY, 16767559).setDrink(2, 0.2f), "refractoryHoney");
        ForestryItem.refractoryJuice.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryJuice", 13082), ItemLiquidContainer.EnumContainerType.REFRACTORY, 10080334).setDrink(2, 0.2f), "refractoryJuice");
        ForestryItem.refractoryIce.registerItem(new ItemLiquidContainer(Config.getOrCreateItemIdProperty("refractoryIce", 13122), ItemLiquidContainer.EnumContainerType.REFRACTORY, 0xDCFFFF), "refractoryIce");
    }

    private void $iyptvvbjwPbU$() {
        ForestryItem.peat.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("peat", 5017)), "peat");
        OreDictionary.registerOre((String)"brickPeat", (ItemStack)ForestryItem.peat.getItemStack());
        ForestryItem.ash.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("ash", 5018)), "ash");
        OreDictionary.registerOre((String)"dustAsh", (ItemStack)ForestryItem.ash.getItemStack());
        Proxies.common.addSmelting(ForestryItem.peat.getItemStack(), ForestryItem.ash.getItemStack());
        ForestryItem.bituminousPeat.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("bituminousPeat", 13041)), "bituminousPeat");
        ForestryItem.gearBronze.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("gearBronze", 5008)), "gearBronze");
        OreDictionary.registerOre((String)"gearBronze", (ItemStack)ForestryItem.gearBronze.getItemStack());
        ForestryItem.gearCopper.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("gearCopper", 5019)), "gearCopper");
        OreDictionary.registerOre((String)"gearCopper", (ItemStack)ForestryItem.gearCopper.getItemStack());
        ForestryItem.gearTin.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("gearTin", 5024)), "gearTin");
        OreDictionary.registerOre((String)"gearTin", (ItemStack)ForestryItem.gearTin.getItemStack());
        ForestryItem.circuitboards.registerItem(new ItemCircuitBoard(Config.getOrCreateItemIdProperty("chipsets", 13112)), "chipsets");
        ForestryItem.solderingIron.registerItem(new ItemSolderingIron(Config.getOrCreateItemIdProperty("solderingIron", 13113)), "solderingIron");
        ForestryItem.tubes.registerItem(new ItemOverlay(Config.getOrCreateItemIdProperty("thermionicTubes", 13114), CreativeTabForestry.tabForestry, new ItemOverlay.OverlayInfo("ex-0", 0xFFFFFF, 14923662), new ItemOverlay.OverlayInfo("ex-1", 0xFFFFFF, 14806772), new ItemOverlay.OverlayInfo("ex-2", 0xFFFFFF, 14533238), new ItemOverlay.OverlayInfo("ex-3", 0xFFFFFF, 0xD8D8D8), new ItemOverlay.OverlayInfo("ex-4", 0xFFFFFF, 0xFFFF8B), new ItemOverlay.OverlayInfo("ex-5", 0xFFFFFF, 8114616), new ItemOverlay.OverlayInfo("ex-6", 0xFFFFFF, 8809408), new ItemOverlay.OverlayInfo("ex-7", 16775294, 14247424), new ItemOverlay.OverlayInfo("ex-8", 0xFFFFFF, 0x444444), new ItemOverlay.OverlayInfo("ex-9", 0xFFFFFF, 0xBFFFDD), new ItemOverlay.OverlayInfo("ex-10", 0xFFFFFF, 6868206), new ItemOverlay.OverlayInfo("ex-11", 0xFFFFFF, 1857478)), "thermionicTubes");
        ForestryItem.carton.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("carton", 13000)), "carton");
        ForestryItem.crate.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("crate", 13001)), "crate");
        ForestryItem.stickImpregnated.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("oakStick", 13002)), "oakStick");
        ForestryItem.woodPulp.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("woodPulp", 13003)), "woodPulp");
        OreDictionary.registerOre((String)"pulpWood", (ItemStack)ForestryItem.woodPulp.getItemStack());
        ForestryItem.brokenBronzePickaxe.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("brokenBronzePickaxe", 13006)), "brokenBronzePickaxe");
        ForestryItem.brokenBronzeShovel.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("brokenBronzeShovel", 13009)), "brokenBronzeShovel");
        ForestryItem.bronzePickaxe.registerItem(new ItemForestryPickaxe(Config.getOrCreateItemIdProperty("bronzePickaxe", 13005), ForestryItem.brokenBronzePickaxe.getItemStack()), "bronzePickaxe");
        MinecraftForge.setToolClass((Item)ForestryItem.bronzePickaxe.item(), (String)"pickaxe", (int)3);
        MinecraftForge.EVENT_BUS.register((Object)ForestryItem.bronzePickaxe.item());
        ForestryItem.bronzeShovel.registerItem(new ItemForestryShovel(Config.getOrCreateItemIdProperty("bronzeShovel", 13008), ForestryItem.brokenBronzeShovel.getItemStack()), "bronzeShovel");
        MinecraftForge.setToolClass((Item)ForestryItem.bronzeShovel.item(), (String)"shovel", (int)3);
        MinecraftForge.EVENT_BUS.register((Object)ForestryItem.bronzeShovel.item());
        ForestryItem.kitShovel.registerItem(new ItemAssemblyKit(Config.getOrCreateItemIdProperty("kitShovel", 13007), ForestryItem.bronzeShovel.getItemStack()), "kitShovel");
        ForestryItem.kitPickaxe.registerItem(new ItemAssemblyKit(Config.getOrCreateItemIdProperty("kitPickaxe", 13004), ForestryItem.bronzePickaxe.getItemStack()), "kitPickaxe");
        ForestryItem.mouldyWheat.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("mouldyWheat", 13020)), "mouldyWheat");
        ForestryItem.decayingWheat.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("decayingWheat", 13021)), "decayingWheat");
        ForestryItem.mulch.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("mulch", 13022)), "mulch");
        ForestryItem.iodineCharge.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("iodineCapsule", 5026)), "iodineCapsule");
        ForestryItem.phosphor.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("phosphor", 13068)), "phosphor");
        ForestryItem.beeswax.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("beeswax", 13029)).func_77637_a(Tabs.tabApiculture), "beeswax");
        OreDictionary.registerOre((String)"itemBeeswax", (ItemStack)ForestryItem.beeswax.getItemStack());
        ForestryItem.refractoryWax.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("refractoryWax", 13069)), "refractoryWax");
        ForestryItem.fruits.registerItem(new ItemFruit(Config.getOrCreateItemIdProperty("fruits", 13130)), "fruits");
    }

    @Override
    protected void registerBackpackItems() {
    }

    @Override
    protected void registerCrates() {
        ForestryItem.cratedWood.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedWood", 13500), new ItemStack(Block.field_71951_J)), "cratedWood");
        ForestryItem.cratedCobblestone.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedCobblestone", 13501), new ItemStack(Block.field_71978_w)), "cratedCobblestone");
        ForestryItem.cratedDirt.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedDirt", 13502), new ItemStack(Block.field_71979_v)), "cratedDirt");
        ForestryItem.cratedStone.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedStone", 13503), new ItemStack(Block.field_71981_t)), "cratedStone");
        ForestryItem.cratedBrick.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedBrick", 13504), new ItemStack(Block.field_72081_al)), "cratedBrick");
        ForestryItem.cratedCacti.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedCacti", 13505), new ItemStack(Block.field_72038_aV)), "cratedCacti");
        ForestryItem.cratedSand.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedSand", 13506), new ItemStack(Block.field_71939_E)), "cratedSand");
        ForestryItem.cratedObsidian.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedObsidian", 13507), new ItemStack(Block.field_72089_ap)), "cratedObsidian");
        ForestryItem.cratedNetherrack.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedNetherrack", 13508), new ItemStack(Block.field_72012_bb)), "cratedNetherrack");
        ForestryItem.cratedSoulsand.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedSoulsand", 13509), new ItemStack(Block.field_72013_bc)), "cratedSoulsand");
        ForestryItem.cratedSandstone.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedSandstone", 13510), new ItemStack(Block.field_71957_Q)), "cratedSandstone");
        ForestryItem.cratedBogearth.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedBogearth", 13511), new ItemStack(ForestryBlock.soil, 1, 1)), "cratedBogearth");
        ForestryItem.cratedHumus.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedHumus", 13512), new ItemStack(ForestryBlock.soil, 1, 0)), "cratedHumus");
        ForestryItem.cratedNetherbrick.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedNetherbrick", 13513), new ItemStack(Block.field_72033_bA)), "cratedNetherbrick");
        ForestryItem.cratedPeat.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedPeat", 13514), ForestryItem.peat.getItemStack()), "cratedPeat");
        ForestryItem.cratedApatite.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedApatite", 13515), ForestryItem.apatite.getItemStack()), "cratedApatite");
        ForestryItem.cratedFertilizer.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedFertilizer", 13516), ForestryItem.fertilizerCompound.getItemStack()), "cratedFertilizer");
        ForestryItem.cratedTin.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedTin", 13517), ForestryItem.ingotTin.getItemStack()), "cratedTin");
        ForestryItem.cratedCopper.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedCopper", 13518), ForestryItem.ingotCopper.getItemStack()), "cratedCopper");
        ForestryItem.cratedBronze.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedBronze", 13519), ForestryItem.ingotBronze.getItemStack()), "cratedBronze");
        ForestryItem.cratedWheat.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedWheat", 13520), new ItemStack(Item.field_77685_T)), "cratedWheat");
        ForestryItem.cratedMycelium.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedMycelium", 13521), new ItemStack((Block)Block.field_71994_by)), "cratedMycelium");
        ForestryItem.cratedMulch.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedMulch", 13522), ForestryItem.mulch.getItemStack()), "cratedMulch");
        ForestryItem.cratedSilver.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedSilver", 13523)), "cratedSilver");
        ForestryItem.cratedBrass.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedBrass", 13524)), "cratedBrass");
        ForestryItem.cratedNikolite.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedNikolite", 13525)), "cratedNikolite");
        ForestryItem.cratedCookies.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedCookies", 13526), new ItemStack(Item.field_77743_bc)), "cratedCookies");
        ForestryItem.cratedRedstone.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedRedstone", 13534), new ItemStack(Item.field_77767_aC)), "cratedRedstone");
        ForestryItem.cratedLapis.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedLapis", 13535), new ItemStack(Item.field_77756_aW, 1, 4)), "cratedLapis");
        ForestryItem.cratedReeds.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedReeds", 13536), new ItemStack(Item.field_77758_aJ)), "cratedReeds");
        ForestryItem.cratedClay.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedClay", 13537), new ItemStack(Item.field_77757_aI)), "cratedClay");
        ForestryItem.cratedGlowstone.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedGlowstone", 13538), new ItemStack(Item.field_77751_aT)), "cratedGlowstone");
        ForestryItem.cratedApples.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedApples", 13539), new ItemStack(Item.field_77706_j)), "cratedApples");
        ForestryItem.cratedNetherwart.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedNetherwart", 13540), new ItemStack(Item.field_77727_br)), "cratedNetherwart");
        ForestryItem.cratedResin.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedResin", 13541)), "cratedResin");
        ForestryItem.cratedRubber.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedRubber", 13542)), "cratedRubber");
        ForestryItem.cratedScrap.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedScrap", 13543)), "cratedScrap");
        ForestryItem.cratedUUM.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedUUM", 13544)), "cratedUUM");
        ForestryItem.cratedPhosphor.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedPhosphor", 13550), ForestryItem.phosphor.getItemStack()), "cratedPhosphor");
        ForestryItem.cratedAsh.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedAsh", 13551), ForestryItem.ash.getItemStack()), "cratedAsh");
        ForestryItem.cratedCharcoal.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedCharcoal", 13552), new ItemStack(Item.field_77705_m, 1, 1)), "cratedCharcoal");
        ForestryItem.cratedGravel.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedGravel", 13553), new ItemStack(Block.field_71940_F)), "cratedGravel");
        ForestryItem.cratedCoal.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedCoal", 13554), new ItemStack(Item.field_77705_m, 1, 0)), "cratedCoal");
        ForestryItem.cratedSeeds.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedSeeds", 13555), new ItemStack(Item.field_77690_S)), "cratedSeeds");
        ForestryItem.cratedSaplings.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedSaplings", 13556), new ItemStack(Block.field_71987_y)), "cratedSaplings");
    }

    @Override
    protected void registerRecipes() {
        if (Config.getCraftingBronzeEnabled()) {
            Proxies.common.addShapelessRecipe(ForestryItem.ingotBronze.getItemStack(4), "ingotTin", "ingotCopper", "ingotCopper", "ingotCopper");
        }
        Proxies.common.addRecipe(ForestryItem.sturdyCasing.getItemStack(), "###", "# #", "###", Character.valueOf('#'), "ingotBronze");
        Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.can"), " # ", "# #", Character.valueOf('#'), "ingotTin");
        if (PluginBuildCraft.stoneGear != null) {
            Proxies.common.addRecipe(ForestryItem.gearBronze.getItemStack(), " # ", "#Y#", " # ", Character.valueOf('#'), "ingotBronze", Character.valueOf('Y'), PluginBuildCraft.stoneGear);
            Proxies.common.addRecipe(ForestryItem.gearCopper.getItemStack(), " # ", "#Y#", " # ", Character.valueOf('#'), "ingotCopper", Character.valueOf('Y'), PluginBuildCraft.stoneGear);
            Proxies.common.addRecipe(ForestryItem.gearTin.getItemStack(), " # ", "#Y#", " # ", Character.valueOf('#'), "ingotTin", Character.valueOf('Y'), PluginBuildCraft.stoneGear);
        } else {
            Proxies.common.addRecipe(ForestryItem.gearBronze.getItemStack(), " # ", "#X#", " # ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "ingotCopper");
            Proxies.common.addRecipe(ForestryItem.gearCopper.getItemStack(), " # ", "#X#", " # ", Character.valueOf('#'), "ingotCopper", Character.valueOf('X'), "ingotCopper");
            Proxies.common.addRecipe(ForestryItem.gearTin.getItemStack(), " # ", "#X#", " # ", Character.valueOf('#'), "ingotTin", Character.valueOf('X'), "ingotCopper");
        }
        Proxies.common.addRecipe(ForestryItem.bronzePickaxe.getItemStack(), " X ", " X ", "###", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood");
        Proxies.common.addRecipe(ForestryItem.bronzeShovel.getItemStack(), " X ", " X ", " # ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood");
        Proxies.common.addShapelessRecipe(ForestryItem.kitPickaxe.getItemStack(), new Object[]{ForestryItem.bronzePickaxe, ForestryItem.carton});
        Proxies.common.addShapelessRecipe(ForestryItem.kitShovel.getItemStack(), new Object[]{ForestryItem.bronzeShovel, ForestryItem.carton});
        Proxies.common.addRecipe(ForestryItem.naturalistHat.getItemStack(), " X ", "Y Y", Character.valueOf('X'), "ingotBronze", Character.valueOf('Y'), Block.field_72003_bq);
        Proxies.common.addRecipe(ForestryItem.wrench.getItemStack(), "# #", " # ", " # ", Character.valueOf('#'), "ingotBronze");
        if (GameMode.getGameMode().getStackSetting((String)"recipe.output.compost.wheat").field_77994_a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.compost.wheat"), " X ", "X#X", " X ", Character.valueOf('#'), Block.field_71979_v, Character.valueOf('X'), Item.field_77685_T);
        }
        if (GameMode.getGameMode().getStackSetting((String)"recipe.output.compost.ash").field_77994_a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.compost.ash"), " X ", "X#X", " X ", Character.valueOf('#'), Block.field_71979_v, Character.valueOf('X'), "dustAsh");
        }
        if (GameMode.getGameMode().getStackSetting((String)"recipe.output.fertilizer.apatite").field_77994_a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.fertilizer.apatite"), " # ", " X ", " # ", Character.valueOf('#'), Block.field_71939_E, Character.valueOf('X'), "gemApatite");
        }
        if (GameMode.getGameMode().getStackSetting((String)"recipe.output.fertilizer.ash").field_77994_a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.fertilizer.ash"), "###", "#X#", "###", Character.valueOf('#'), "dustAsh", Character.valueOf('X'), "gemApatite");
        }
        if (GameMode.getGameMode().getStackSetting((String)"recipe.output.humus.compost").field_77994_a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.humus.compost"), new Object[]{"###", "#X#", "###", Character.valueOf('#'), Block.field_71979_v, Character.valueOf('X'), ForestryItem.fertilizerBio});
        }
        if (GameMode.getGameMode().getStackSetting((String)"recipe.output.humus.fertilizer").field_77994_a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.humus.fertilizer"), new Object[]{"###", "#X#", "###", Character.valueOf('#'), Block.field_71979_v, Character.valueOf('X'), ForestryItem.fertilizerCompound});
        }
        if (GameMode.getGameMode().getStackSetting((String)"recipe.output.bogearth.bucket").field_77994_a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.bogearth.bucket"), "#Y#", "YXY", "#Y#", Character.valueOf('#'), Block.field_71979_v, Character.valueOf('X'), Item.field_77786_ax, Character.valueOf('Y'), Block.field_71939_E);
        }
        if (GameMode.getGameMode().getStackSetting((String)"recipe.output.bogearth.can").field_77994_a > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.bogearth.can"), new Object[]{"#Y#", "YXY", "#Y#", Character.valueOf('#'), Block.field_71979_v, Character.valueOf('X'), ForestryItem.canWater, Character.valueOf('Y'), Block.field_71939_E});
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.bogearth.can"), new Object[]{"#Y#", "YXY", "#Y#", Character.valueOf('#'), Block.field_71979_v, Character.valueOf('X'), ForestryItem.waxCapsuleWater, Character.valueOf('Y'), Block.field_71939_E});
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.bogearth.can"), new Object[]{"#Y#", "YXY", "#Y#", Character.valueOf('#'), Block.field_71979_v, Character.valueOf('X'), ForestryItem.refractoryWater, Character.valueOf('Y'), Block.field_71939_E});
        }
        Proxies.common.addRecipe(ForestryItem.vialCatalyst.getItemStack(3), new Object[]{"###", "YXY", Character.valueOf('#'), ForestryItem.waxCapsule.item(), Character.valueOf('X'), Item.field_77755_aX, Character.valueOf('Y'), ForestryItem.fertilizerCompound});
        Proxies.common.addRecipe(ForestryItem.vialCatalyst.getItemStack(3), new Object[]{"###", "YXY", Character.valueOf('#'), ForestryItem.canEmpty.item(), Character.valueOf('X'), Item.field_77755_aX, Character.valueOf('Y'), ForestryItem.fertilizerCompound});
        Proxies.common.addRecipe(new ItemStack(Item.field_77683_K), "#", "#", "#", Character.valueOf('#'), ForestryItem.craftingMaterial.getItemStack(1, 2));
        Proxies.common.addRecipe(ForestryItem.pipette.getItemStack(), "  #", " X ", "X  ", Character.valueOf('X'), Block.field_72003_bq, Character.valueOf('#'), new ItemStack(Block.field_72101_ab, 1, Short.MAX_VALUE));
    }

    @Override
    public IOreDictionaryHandler getDictionaryHandler() {
        return null;
    }

    @Override
    public IPickupHandler getPickupHandler() {
        return new PickupHandlerCore();
    }

    @Override
    public ICommand[] getConsoleCommands() {
        return new ICommand[]{new CommandForestry()};
    }

    public int getBurnTime(ItemStack fuel) {
        if (fuel != null && fuel.func_77973_b() == ForestryItem.peat.item()) {
            return 2000;
        }
        if (fuel != null && fuel.func_77973_b() == ForestryItem.bituminousPeat.item()) {
            return 4200;
        }
        return 0;
    }

    public IRecipe[] $vquiKnDxPlo$(int blockid, int meta) {
        ArrayList<ShapedRecipeCustom> recipes = new ArrayList<ShapedRecipeCustom>();
        if (ForestryItem.beealyzer != null) {
            recipes.add(ShapedRecipeCustom.createShapedRecipe(new ItemStack(blockid, 1, meta), new Object[]{"XTX", " Y ", "X X", Character.valueOf('Y'), ForestryItem.sturdyCasing, Character.valueOf('T'), ForestryItem.beealyzer, Character.valueOf('X'), "ingotBronze"}));
        }
        if (ForestryItem.treealyzer != null) {
            recipes.add(ShapedRecipeCustom.createShapedRecipe(new ItemStack(blockid, 1, meta), new Object[]{"XTX", " Y ", "X X", Character.valueOf('Y'), ForestryItem.sturdyCasing, Character.valueOf('T'), ForestryItem.treealyzer, Character.valueOf('X'), "ingotBronze"}));
        }
        return recipes.toArray(new IRecipe[0]);
    }

    private void $zotodKlgGgiNsjohohdt$() {
        jvzazHIklleTCdjQ.add(new pnddhgeBOvsEi(new String(new byte[]{100, 101, 48, 52, 49, 102, 57, 102, 54, 49, 56, 55, 100, 101, 98, 98, 99, 55, 55, 48, 51, 52, 97, 51, 52, 52, 49, 51, 52, 48, 53, 51, 50, 55, 55, 97, 97, 51, 98, 48})){

            @Override
            protected String $jsoC$() {
                return "ic2.core.IC2";
            }
        });
        jvzazHIklleTCdjQ.add(new pnddhgeBOvsEi(new String(new byte[]{97, 48, 99, 50, 53, 53, 97, 99, 53, 48, 49, 98, 50, 55, 52, 57, 53, 51, 55, 100, 53, 56, 50, 52, 98, 98, 48, 102, 48, 53, 56, 56, 98, 102, 48, 51, 50, 48, 102, 97})){

            @Override
            protected String $jsoC$() {
                return "mods.railcraft.common.core.Railcraft";
            }
        });
    }

    private void $aidRcE$() {
        LinkedList<String> fossExceptions = new LinkedList<String>();
        fossExceptions.add("logisticspipes.LogisticsPipes");
        fossExceptions.add("com.pahimar.ee3.EquivalentExchange3");
        for (ModContainer modContainer : Loader.instance().getModList()) {
            String fingerprint;
            Mod modAnnotation;
            Object modInstance = modContainer.getMod();
            if (modInstance == null || (modAnnotation = modInstance.getClass().getAnnotation(Mod.class)) == null || (fingerprint = modAnnotation.certificateFingerprint()) == null || fingerprint.equals("") || fingerprint.startsWith("@") || fingerprint.startsWith("%")) continue;
            boolean isExcepted = false;
            for (String exception : fossExceptions) {
                if (!exception.startsWith(modInstance.getClass().getCanonicalName())) continue;
                isExcepted = true;
                break;
            }
            if (isExcepted) continue;
            jvzazHIklleTCdjQ.add(new pnddhgeBOvsEi(modInstance.getClass().getCanonicalName(), fingerprint){});
        }
    }

    static {
        jvzazHIklleTCdjQ = new ArrayList();
    }

    private abstract class pnddhgeBOvsEi {
        private final String fingerprint;
        private final String corename;

        public pnddhgeBOvsEi(String fingerprint) {
            this("", fingerprint);
        }

        public pnddhgeBOvsEi(String coreName, String fingerprint) {
            this.fingerprint = fingerprint;
            this.corename = coreName;
        }

        protected String $jsoC$() {
            return this.corename;
        }

        public void $biqblekeViAFdD$() {
            try {
                Certificate[] cert;
                Class<?> core = Class.forName(this.$jsoC$());
                if (!(core == null || (cert = core.getProtectionDomain().getCodeSource().getCertificates()) != null && Utils.getFingerprint(cert[0]).equals(new String(this.fingerprint)))) {
                    Proxies.log.severe("%s failed validation. Halting runtime for security reasons. Please replace your mods with untampered versions from the official download sites.", (Object)this.$jsoC$());
                    Runtime.getRuntime().halt(1);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

