/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.PluginInfo;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IClassification;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.IBackpackDefinition;
import forestry.arboriculture.CommandSpawnForest;
import forestry.arboriculture.CommandSpawnTree;
import forestry.arboriculture.CommandTreekeepingMode;
import forestry.arboriculture.EventHandlerArboriculture;
import forestry.arboriculture.FruitProviderNone;
import forestry.arboriculture.FruitProviderPod;
import forestry.arboriculture.FruitProviderRandom;
import forestry.arboriculture.FruitProviderRipening;
import forestry.arboriculture.GuiHandlerArboriculture;
import forestry.arboriculture.PacketHandlerArboriculture;
import forestry.arboriculture.VillageHandlerArboriculture;
import forestry.arboriculture.WoodType;
import forestry.arboriculture.gadgets.BlockArbFence;
import forestry.arboriculture.gadgets.BlockArbStairs;
import forestry.arboriculture.gadgets.BlockFruitPod;
import forestry.arboriculture.gadgets.BlockLeaves;
import forestry.arboriculture.gadgets.BlockLog;
import forestry.arboriculture.gadgets.BlockPlanks;
import forestry.arboriculture.gadgets.BlockSapling;
import forestry.arboriculture.gadgets.BlockSlab;
import forestry.arboriculture.gadgets.TileArboristChest;
import forestry.arboriculture.gadgets.TileFruitPod;
import forestry.arboriculture.gadgets.TileLeaves;
import forestry.arboriculture.gadgets.TileSapling;
import forestry.arboriculture.gadgets.TileStairs;
import forestry.arboriculture.genetics.AlleleFruit;
import forestry.arboriculture.genetics.AlleleGrowth;
import forestry.arboriculture.genetics.AlleleLeafEffectNone;
import forestry.arboriculture.genetics.AlleleTreeSpecies;
import forestry.arboriculture.genetics.BranchTrees;
import forestry.arboriculture.genetics.GrowthProvider;
import forestry.arboriculture.genetics.GrowthProviderTropical;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.genetics.TreeHelper;
import forestry.arboriculture.genetics.TreeMutation;
import forestry.arboriculture.genetics.TreeTemplates;
import forestry.arboriculture.genetics.TreekeepingMode;
import forestry.arboriculture.items.ItemGermlingGE;
import forestry.arboriculture.items.ItemGrafter;
import forestry.arboriculture.items.ItemStairs;
import forestry.arboriculture.items.ItemTreealyzer;
import forestry.arboriculture.items.ItemWoodBlock;
import forestry.arboriculture.proxy.ProxyArboriculture;
import forestry.arboriculture.worldgen.WorldGenAcacia;
import forestry.arboriculture.worldgen.WorldGenBalsa;
import forestry.arboriculture.worldgen.WorldGenBaobab;
import forestry.arboriculture.worldgen.WorldGenBirch;
import forestry.arboriculture.worldgen.WorldGenCherry;
import forestry.arboriculture.worldgen.WorldGenChestnut;
import forestry.arboriculture.worldgen.WorldGenDate;
import forestry.arboriculture.worldgen.WorldGenEbony;
import forestry.arboriculture.worldgen.WorldGenGiganteum;
import forestry.arboriculture.worldgen.WorldGenGreenheart;
import forestry.arboriculture.worldgen.WorldGenJungle;
import forestry.arboriculture.worldgen.WorldGenKapok;
import forestry.arboriculture.worldgen.WorldGenLarch;
import forestry.arboriculture.worldgen.WorldGenLemon;
import forestry.arboriculture.worldgen.WorldGenLime;
import forestry.arboriculture.worldgen.WorldGenMahoe;
import forestry.arboriculture.worldgen.WorldGenMahogany;
import forestry.arboriculture.worldgen.WorldGenMaple;
import forestry.arboriculture.worldgen.WorldGenOak;
import forestry.arboriculture.worldgen.WorldGenPapaya;
import forestry.arboriculture.worldgen.WorldGenPine;
import forestry.arboriculture.worldgen.WorldGenPlum;
import forestry.arboriculture.worldgen.WorldGenPoplar;
import forestry.arboriculture.worldgen.WorldGenSequoia;
import forestry.arboriculture.worldgen.WorldGenSpruce;
import forestry.arboriculture.worldgen.WorldGenTeak;
import forestry.arboriculture.worldgen.WorldGenWalnut;
import forestry.arboriculture.worldgen.WorldGenWenge;
import forestry.arboriculture.worldgen.WorldGenWillow;
import forestry.core.GameMode;
import forestry.core.config.Config;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.BlockBase;
import forestry.core.gadgets.MachineDefinition;
import forestry.core.genetics.Allele;
import forestry.core.genetics.FruitFamily;
import forestry.core.interfaces.IOreDictionaryHandler;
import forestry.core.interfaces.IPacketHandler;
import forestry.core.interfaces.ISaveEventHandler;
import forestry.core.items.ItemForestryBlock;
import forestry.core.items.ItemFruit;
import forestry.core.proxy.Proxies;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.RecipeUtil;
import forestry.core.utils.ShapedRecipeCustom;
import forestry.plugins.NativePlugin;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;

@PluginInfo(pluginID="Arboriculture", name="Arboriculture", author="Binnie & SirSengir", url="http://forestry.sengir.net/", description="Adds additional tree species and products.")
public class PluginArboriculture
extends NativePlugin
implements IFuelHandler {
    @SidedProxy(clientSide="forestry.arboriculture.proxy.ClientProxyArboriculture", serverSide="forestry.arboriculture.proxy.ProxyArboriculture")
    public static ProxyArboriculture proxy;
    public static String treekeepingMode;
    public static int modelIdSaplings;
    public static int modelIdLeaves;
    public static int modelIdFences;
    public static int modelIdPods;
    public static ITreeRoot treeInterface;
    public static MachineDefinition definitionChest;
    public static List validFenceIDs;

    @Override
    public boolean isAvailable() {
        return !Config.disableArboriculture;
    }

    @Override
    public void preInit() {
        int i;
        super.preInit();
        ForestryBlock.log1 = new BlockLog(Config.getOrCreateBlockIdProperty("log1", 1388), BlockLog.LogCat.CAT0).func_71864_b("for.log1");
        Proxies.common.registerBlock(ForestryBlock.log1, ItemWoodBlock.class);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.log1, (String)"axe", (int)0);
        for (i = 0; i < 4; ++i) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Transport", (String)"add-facade", (String)(ForestryBlock.log1.field_71990_ca + "@" + i));
        }
        ForestryBlock.log2 = new BlockLog(Config.getOrCreateBlockIdProperty("log2", 1389), BlockLog.LogCat.CAT1).func_71864_b("for.log2");
        Proxies.common.registerBlock(ForestryBlock.log2, ItemWoodBlock.class);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.log2, (String)"axe", (int)0);
        for (i = 0; i < 4; ++i) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Transport", (String)"add-facade", (String)(ForestryBlock.log2.field_71990_ca + "@" + i));
        }
        ForestryBlock.log3 = new BlockLog(Config.getOrCreateBlockIdProperty("log3", 1390), BlockLog.LogCat.CAT2).func_71864_b("for.log3");
        Proxies.common.registerBlock(ForestryBlock.log3, ItemWoodBlock.class);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.log3, (String)"axe", (int)0);
        for (i = 0; i < 4; ++i) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Transport", (String)"add-facade", (String)(ForestryBlock.log3.field_71990_ca + "@" + i));
        }
        ForestryBlock.log4 = new BlockLog(Config.getOrCreateBlockIdProperty("log4", 1391), BlockLog.LogCat.CAT3).func_71864_b("for.log4");
        Proxies.common.registerBlock(ForestryBlock.log4, ItemWoodBlock.class);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.log4, (String)"axe", (int)0);
        for (i = 0; i < 4; ++i) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Transport", (String)"add-facade", (String)(ForestryBlock.log4.field_71990_ca + "@" + i));
        }
        ForestryBlock.log5 = new BlockLog(Config.getOrCreateBlockIdProperty("log5", 1411), BlockLog.LogCat.CAT4).func_71864_b("for.log5");
        Proxies.common.registerBlock(ForestryBlock.log5, ItemWoodBlock.class);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.log5, (String)"axe", (int)0);
        for (i = 0; i < 4; ++i) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Transport", (String)"add-facade", (String)(ForestryBlock.log5.field_71990_ca + "@" + i));
        }
        ForestryBlock.log6 = new BlockLog(Config.getOrCreateBlockIdProperty("log6", 1412), BlockLog.LogCat.CAT5).func_71864_b("for.log6");
        Proxies.common.registerBlock(ForestryBlock.log6, ItemWoodBlock.class);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.log6, (String)"axe", (int)0);
        for (i = 0; i < 4; ++i) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Transport", (String)"add-facade", (String)(ForestryBlock.log6.field_71990_ca + "@" + i));
        }
        ForestryBlock.log7 = new BlockLog(Config.getOrCreateBlockIdProperty("log7", 1413), BlockLog.LogCat.CAT6).func_71864_b("for.log7");
        Proxies.common.registerBlock(ForestryBlock.log7, ItemWoodBlock.class);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.log7, (String)"axe", (int)0);
        OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(ForestryBlock.log1, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(ForestryBlock.log2, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(ForestryBlock.log3, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(ForestryBlock.log4, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(ForestryBlock.log5, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(ForestryBlock.log6, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(ForestryBlock.log7, 1, Short.MAX_VALUE));
        FurnaceRecipes.func_77602_a().func_77600_a(ForestryBlock.log1.field_71990_ca, new ItemStack(Item.field_77705_m, 1, 1), 0.15f);
        FurnaceRecipes.func_77602_a().func_77600_a(ForestryBlock.log2.field_71990_ca, new ItemStack(Item.field_77705_m, 1, 1), 0.15f);
        FurnaceRecipes.func_77602_a().func_77600_a(ForestryBlock.log3.field_71990_ca, new ItemStack(Item.field_77705_m, 1, 1), 0.15f);
        FurnaceRecipes.func_77602_a().func_77600_a(ForestryBlock.log4.field_71990_ca, new ItemStack(Item.field_77705_m, 1, 1), 0.15f);
        FurnaceRecipes.func_77602_a().func_77600_a(ForestryBlock.log5.field_71990_ca, new ItemStack(Item.field_77705_m, 1, 1), 0.15f);
        FurnaceRecipes.func_77602_a().func_77600_a(ForestryBlock.log6.field_71990_ca, new ItemStack(Item.field_77705_m, 1, 1), 0.15f);
        ForestryBlock.planks1 = new BlockPlanks(Config.getOrCreateBlockIdProperty("planks", 1380), BlockPlanks.PlankCat.CAT0).func_71864_b("for.planks");
        Proxies.common.registerBlock(ForestryBlock.planks1, ItemWoodBlock.class);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.planks1, (String)"axe", (int)0);
        ForestryBlock.planks2 = new BlockPlanks(Config.getOrCreateBlockIdProperty("planks2", 1417), BlockPlanks.PlankCat.CAT1).func_71864_b("for.planks2");
        Proxies.common.registerBlock(ForestryBlock.planks2, ItemWoodBlock.class);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.planks2, (String)"axe", (int)0);
        OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack(ForestryBlock.planks1, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack(ForestryBlock.planks2, 1, Short.MAX_VALUE));
        for (i = 0; i < 16; ++i) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Transport", (String)"add-facade", (String)(ForestryBlock.planks1.field_71990_ca + "@" + i));
        }
        ForestryBlock.slabs1 = new BlockSlab(Config.getOrCreateBlockIdProperty("slabs1", 1386), BlockSlab.SlabCat.CAT0).func_71864_b("for.slabs1");
        Proxies.common.registerBlock(ForestryBlock.slabs1, ItemWoodBlock.class);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.slabs1, (String)"axe", (int)0);
        ForestryBlock.slabs2 = new BlockSlab(Config.getOrCreateBlockIdProperty("slabs2", 1387), BlockSlab.SlabCat.CAT1).func_71864_b("for.slabs2");
        Proxies.common.registerBlock(ForestryBlock.slabs2, ItemWoodBlock.class);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.slabs2, (String)"axe", (int)0);
        ForestryBlock.slabs3 = new BlockSlab(Config.getOrCreateBlockIdProperty("slabs3", 1415), BlockSlab.SlabCat.CAT2).func_71864_b("for.slabs3");
        Proxies.common.registerBlock(ForestryBlock.slabs3, ItemWoodBlock.class);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.slabs3, (String)"axe", (int)0);
        OreDictionary.registerOre((String)"slabWood", (ItemStack)new ItemStack(ForestryBlock.slabs1, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"slabWood", (ItemStack)new ItemStack(ForestryBlock.slabs2, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"slabWood", (ItemStack)new ItemStack(ForestryBlock.slabs3, 1, Short.MAX_VALUE));
        ForestryBlock.fences1 = new BlockArbFence(Config.getOrCreateBlockIdProperty("fences", 1394), BlockArbFence.FenceCat.CAT0).func_71864_b("for.fences");
        Proxies.common.registerBlock(ForestryBlock.fences1, ItemWoodBlock.class);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.fences1, (String)"axe", (int)0);
        ForestryBlock.fences2 = new BlockArbFence(Config.getOrCreateBlockIdProperty("fences2", 1418), BlockArbFence.FenceCat.CAT1).func_71864_b("for.fences2");
        Proxies.common.registerBlock(ForestryBlock.fences2, ItemWoodBlock.class);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.fences2, (String)"axe", (int)0);
        ForestryBlock.stairs = new BlockArbStairs(Config.getOrCreateBlockIdProperty("stairs", 1396), ForestryBlock.planks1, 0).func_71864_b("for.stairs");
        Proxies.common.registerBlock(ForestryBlock.stairs, ItemStairs.class);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.stairs, (String)"axe", (int)0);
        ForestryBlock.saplingGE = new BlockSapling(Config.getOrCreateBlockIdProperty("saplingGE", 1392)).func_71864_b("saplingGE");
        Proxies.common.registerBlock(ForestryBlock.saplingGE, ItemForestryBlock.class);
        ForestryBlock.leaves = new BlockLeaves(Config.getOrCreateBlockIdProperty("leaves", 1393)).func_71864_b("leaves");
        Proxies.common.registerBlock(ForestryBlock.leaves, ItemForestryBlock.class);
        ForestryBlock.pods = new BlockFruitPod(Config.getOrCreateBlockIdProperty("pods", 1410)).func_71864_b("for.pods");
        Proxies.common.registerBlock(ForestryBlock.pods, ItemForestryBlock.class);
        int blockid = Config.getOrCreateBlockIdProperty("arboriculture", 1377);
        definitionChest = new MachineDefinition(blockid, 0, "forestry.ArbChest", TileArboristChest.class, ShapedRecipeCustom.createShapedRecipe(new ItemStack(blockid, 1, 0), " # ", "XYX", "XXX", Character.valueOf('#'), Block.field_71946_M, Character.valueOf('X'), "treeSapling", Character.valueOf('Y'), Block.field_72077_au)).setFaces(0, 1, 2, 3, 4, 4, 0, 7);
        ForestryBlock.arboriculture = new BlockBase(blockid, Material.field_76243_f, definitionChest).func_71864_b("for.arboriculture").func_71849_a(Tabs.tabArboriculture);
        Proxies.common.registerBlock(ForestryBlock.arboriculture, ItemForestryBlock.class);
        treeInterface = TreeManager.treeInterface = new TreeHelper();
        AlleleManager.alleleRegistry.registerSpeciesRoot(TreeManager.treeInterface);
        proxy.initializeRendering();
        this.createAlleles();
        validFenceIDs.add(ForestryBlock.fences1.field_71990_ca);
        validFenceIDs.add(ForestryBlock.fences2.field_71990_ca);
        validFenceIDs.add(Block.field_72031_aZ.field_71990_ca);
        validFenceIDs.add(Block.field_71993_bv.field_71990_ca);
        validFenceIDs.add(Block.field_72098_bB.field_71990_ca);
    }

    @Override
    public void doInit() {
        super.doInit();
        proxy.addLocalizations();
        GameRegistry.registerTileEntity(TileSapling.class, (String)"forestry.Sapling");
        GameRegistry.registerTileEntity(TileLeaves.class, (String)"forestry.Leaves");
        GameRegistry.registerTileEntity(TileStairs.class, (String)"forestry.Stairs");
        GameRegistry.registerTileEntity(TileFruitPod.class, (String)"forestry.Pods");
        definitionChest.register();
        this.createMutations();
        this.registerTemplates();
        this.registerErsatzGenomes();
        treeInterface.registerTreekeepingMode(TreekeepingMode.easy);
        treeInterface.registerTreekeepingMode(TreekeepingMode.normal);
        treeInterface.registerTreekeepingMode(TreekeepingMode.hard);
        treeInterface.registerTreekeepingMode(TreekeepingMode.hardcore);
        treeInterface.registerTreekeepingMode(TreekeepingMode.insane);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerArboriculture());
        VillagerRegistry.instance().registerVillagerId(81);
        Proxies.render.registerVillagerSkin(81, "textures/entity/lumberjack.png");
        VillagerRegistry.instance().registerVillageTradeHandler(81, (VillagerRegistry.IVillageTradeHandler)new VillageHandlerArboriculture());
    }

    @Override
    public void postInit() {
        super.postInit();
        this.registerDungeonLoot();
    }

    @Override
    protected void registerItems() {
        ForestryItem.sapling.registerItem(new ItemGermlingGE(Config.getOrCreateItemIdProperty("sapling", 13128), EnumGermlingType.SAPLING), "sapling");
        OreDictionary.registerOre((String)"treeSapling", (ItemStack)ForestryItem.sapling.getItemStack(1, -1));
        ForestryItem.pollenFertile.registerItem(new ItemGermlingGE(Config.getOrCreateItemIdProperty("pollenFertile", 13133), EnumGermlingType.POLLEN), "pollenFertile");
        ForestryItem.treealyzer.registerItem(new ItemTreealyzer(Config.getOrCreateItemIdProperty("treealyzer", 13129)), "treealyzer");
        ForestryItem.grafter.registerItem(new ItemGrafter(Config.getOrCreateItemIdProperty("grafter", 13131), 4), "grafter");
        ForestryItem.grafterProven.registerItem(new ItemGrafter(Config.getOrCreateItemIdProperty("grafterProven", 13132), 149), "grafterProven");
    }

    @Override
    protected void registerBackpackItems() {
        if (BackpackManager.backpackItems == null) {
            return;
        }
        ((IBackpackDefinition)BackpackManager.definitions.get("forester")).addValidItem(new ItemStack(ForestryBlock.log1, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("forester")).addValidItem(new ItemStack(ForestryBlock.log2, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("forester")).addValidItem(new ItemStack(ForestryBlock.log3, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("forester")).addValidItem(new ItemStack(ForestryBlock.log4, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("forester")).addValidItem(new ItemStack(ForestryBlock.log5, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("forester")).addValidItem(new ItemStack(ForestryBlock.log6, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("forester")).addValidItem(new ItemStack(ForestryBlock.log7, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("forester")).addValidItem(new ItemStack(ForestryItem.sapling.item(), 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("forester")).addValidItem(new ItemStack(ForestryItem.fruits.item(), 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("builder")).addValidItem(new ItemStack(ForestryBlock.stairs, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("builder")).addValidItem(new ItemStack(ForestryBlock.slabs1, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("builder")).addValidItem(new ItemStack(ForestryBlock.slabs2, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("builder")).addValidItem(new ItemStack(ForestryBlock.slabs3, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("builder")).addValidItem(new ItemStack(ForestryBlock.fences1, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("builder")).addValidItem(new ItemStack(ForestryBlock.fences2, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("builder")).addValidItem(new ItemStack(ForestryBlock.planks1, 1, Short.MAX_VALUE));
        ((IBackpackDefinition)BackpackManager.definitions.get("builder")).addValidItem(new ItemStack(ForestryBlock.planks2, 1, Short.MAX_VALUE));
    }

    @Override
    protected void registerCrates() {
    }

    @Override
    protected void registerRecipes() {
        ItemStack stairs;
        NBTTagCompound compound;
        WoodType type;
        int i;
        for (i = 0; i < 4; ++i) {
            Proxies.common.addShapelessRecipe(new ItemStack(ForestryBlock.planks1, 4, i), new ItemStack(ForestryBlock.log1, 1, i));
        }
        for (i = 0; i < 4; ++i) {
            Proxies.common.addShapelessRecipe(new ItemStack(ForestryBlock.planks1, 4, 4 + i), new ItemStack(ForestryBlock.log2, 1, i));
        }
        for (i = 0; i < 4; ++i) {
            Proxies.common.addShapelessRecipe(new ItemStack(ForestryBlock.planks1, 4, 8 + i), new ItemStack(ForestryBlock.log3, 1, i));
        }
        for (i = 0; i < 4; ++i) {
            Proxies.common.addShapelessRecipe(new ItemStack(ForestryBlock.planks1, 4, 12 + i), new ItemStack(ForestryBlock.log4, 1, i));
        }
        for (i = 0; i < 4; ++i) {
            Proxies.common.addShapelessRecipe(new ItemStack(ForestryBlock.planks2, 4, i), new ItemStack(ForestryBlock.log5, 1, i));
        }
        for (i = 0; i < 4; ++i) {
            Proxies.common.addShapelessRecipe(new ItemStack(ForestryBlock.planks2, 4, 4 + i), new ItemStack(ForestryBlock.log6, 1, i));
        }
        for (i = 0; i < 8; ++i) {
            Proxies.common.addPriorityRecipe(new ItemStack(ForestryBlock.slabs1, 6, i), "###", Character.valueOf('#'), new ItemStack(ForestryBlock.planks1, 1, i));
        }
        for (i = 0; i < 8; ++i) {
            Proxies.common.addPriorityRecipe(new ItemStack(ForestryBlock.slabs2, 6, i), "###", Character.valueOf('#'), new ItemStack(ForestryBlock.planks1, 1, 8 + i));
        }
        for (i = 0; i < 8; ++i) {
            Proxies.common.addPriorityRecipe(new ItemStack(ForestryBlock.slabs3, 6, i), "###", Character.valueOf('#'), new ItemStack(ForestryBlock.planks2, 1, i));
        }
        for (i = 0; i < 16; ++i) {
            Proxies.common.addRecipe(new ItemStack(ForestryBlock.fences1, 4, i), "###", "# #", Character.valueOf('#'), new ItemStack(ForestryBlock.planks1, 1, i));
        }
        for (i = 0; i < 8; ++i) {
            Proxies.common.addRecipe(new ItemStack(ForestryBlock.fences2, 4, i), "###", "# #", Character.valueOf('#'), new ItemStack(ForestryBlock.planks2, 1, i));
        }
        RecipeManagers.carpenterManager.addRecipe(100, LiquidHelper.getLiquid("water", 2000), null, ForestryItem.treealyzer.getItemStack(), new Object[]{"X#X", "X#X", "RDR", Character.valueOf('#'), Block.field_72003_bq, Character.valueOf('X'), "ingotCopper", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('D'), Item.field_77702_n});
        RecipeManagers.squeezerManager.addRecipe(20, new ItemStack[]{ForestryItem.fruits.getItemStack(1, ItemFruit.EnumFruit.CHERRY.ordinal())}, LiquidHelper.getLiquid("seedoil", 5 * GameMode.getGameMode().getIntegerSetting("squeezer.liquid.seed")), ForestryItem.mulch.getItemStack(), 5);
        RecipeManagers.squeezerManager.addRecipe(60, new ItemStack[]{ForestryItem.fruits.getItemStack(1, ItemFruit.EnumFruit.WALNUT.ordinal())}, LiquidHelper.getLiquid("seedoil", 18 * GameMode.getGameMode().getIntegerSetting("squeezer.liquid.seed")), ForestryItem.mulch.getItemStack(), 5);
        RecipeManagers.squeezerManager.addRecipe(70, new ItemStack[]{ForestryItem.fruits.getItemStack(1, ItemFruit.EnumFruit.CHESTNUT.ordinal())}, LiquidHelper.getLiquid("seedoil", 22 * GameMode.getGameMode().getIntegerSetting("squeezer.liquid.seed")), ForestryItem.mulch.getItemStack(), 2);
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ForestryItem.fruits.getItemStack(1, ItemFruit.EnumFruit.LEMON.ordinal())}, LiquidHelper.getLiquid("juice", GameMode.getGameMode().getIntegerSetting("squeezer.liquid.apple") * 2), ForestryItem.mulch.getItemStack(), (int)Math.floor((float)GameMode.getGameMode().getIntegerSetting("squeezer.mulch.apple") * 0.5f));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ForestryItem.fruits.getItemStack(1, ItemFruit.EnumFruit.PLUM.ordinal())}, LiquidHelper.getLiquid("juice", (int)Math.floor((float)GameMode.getGameMode().getIntegerSetting("squeezer.liquid.apple") * 0.5f)), ForestryItem.mulch.getItemStack(), GameMode.getGameMode().getIntegerSetting("squeezer.mulch.apple") * 3);
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ForestryItem.fruits.getItemStack(1, ItemFruit.EnumFruit.PAPAYA.ordinal())}, LiquidHelper.getLiquid("juice", GameMode.getGameMode().getIntegerSetting("squeezer.liquid.apple") * 3), ForestryItem.mulch.getItemStack(), (int)Math.floor((float)GameMode.getGameMode().getIntegerSetting("squeezer.mulch.apple") * 0.5f));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ForestryItem.fruits.getItemStack(1, ItemFruit.EnumFruit.DATES.ordinal())}, LiquidHelper.getLiquid("juice", (int)Math.floor((double)GameMode.getGameMode().getIntegerSetting("squeezer.liquid.apple") * 0.25)), ForestryItem.mulch.getItemStack(), (int)Math.floor(GameMode.getGameMode().getIntegerSetting("squeezer.mulch.apple")));
        RecipeUtil.injectLeveledRecipe(ForestryItem.sapling.getItemStack(), GameMode.getGameMode().getIntegerSetting("fermenter.yield.sapling"), "biomass");
        for (i = 0; i < 16; ++i) {
            type = WoodType.VALUES[i];
            compound = new NBTTagCompound("tag");
            type.saveToCompound(compound);
            stairs = new ItemStack(ForestryBlock.stairs, 4, 0);
            stairs.func_77982_d(compound);
            Proxies.common.addPriorityRecipe(stairs, "#  ", "## ", "###", Character.valueOf('#'), new ItemStack(ForestryBlock.planks1, 1, i));
        }
        for (i = 0; i < 8; ++i) {
            type = WoodType.VALUES[16 + i];
            compound = new NBTTagCompound("tag");
            type.saveToCompound(compound);
            stairs = new ItemStack(ForestryBlock.stairs, 4, 0);
            stairs.func_77982_d(compound);
            Proxies.common.addPriorityRecipe(stairs, "#  ", "## ", "###", Character.valueOf('#'), new ItemStack(ForestryBlock.planks2, 1, i));
        }
        Proxies.common.addRecipe(ForestryItem.grafter.getItemStack(), "  B", " # ", "#  ", Character.valueOf('B'), "ingotBronze", Character.valueOf('#'), Item.field_77669_D);
    }

    private void createAlleles() {
        IClassification angiosperms = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.DIVISION, "angiosperms", "Angiosperms");
        AlleleManager.alleleRegistry.getClassification("kingdom.plantae").addMemberGroup(angiosperms);
        IClassification pinophyta = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.DIVISION, "pinophyta", "Pinophyta");
        AlleleManager.alleleRegistry.getClassification("kingdom.plantae").addMemberGroup(pinophyta);
        IClassification magnoliophyta = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.DIVISION, "magnoliophyta", "Magnoliophyta");
        AlleleManager.alleleRegistry.getClassification("kingdom.plantae").addMemberGroup(magnoliophyta);
        IClassification rosids = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.CLASS, "rosids", "Rosids");
        angiosperms.addMemberGroup(rosids);
        IClassification asterids = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.CLASS, "asterids", "Asterids");
        angiosperms.addMemberGroup(asterids);
        IClassification pinopsida = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.CLASS, "pinopsida", "Pinopsida");
        pinophyta.addMemberGroup(pinopsida);
        IClassification magnoliopsida = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.CLASS, "magnoliopsida", "Magnoliopsida");
        pinophyta.addMemberGroup(magnoliopsida);
        IClassification fabales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "fabales", "Fabales");
        rosids.addMemberGroup(fabales);
        IClassification rosales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "rosales", "Rosales");
        rosids.addMemberGroup(rosales);
        IClassification fagales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "fagales", "Fagales");
        rosids.addMemberGroup(fagales);
        IClassification malvales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "malvales", "Malvales");
        rosids.addMemberGroup(malvales);
        IClassification malpighiales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "malpighiales", "Malpighiales");
        rosids.addMemberGroup(malpighiales);
        IClassification ericales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "ericales", "Ericales");
        asterids.addMemberGroup(ericales);
        IClassification lamiales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "lamiales", "Lamiales");
        asterids.addMemberGroup(lamiales);
        IClassification pinales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "pinales", "Pinales");
        pinopsida.addMemberGroup(pinales);
        IClassification laurales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "laurales", "Laurales");
        rosids.addMemberGroup(laurales);
        IClassification sapindales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "sapindales", "Sapindales");
        rosids.addMemberGroup(sapindales);
        IClassification brassicales = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "brassicales", "Brassicales");
        rosids.addMemberGroup(brassicales);
        IClassification betulaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "betulaceae", "Betulaceae");
        fagales.addMemberGroup(betulaceae);
        IClassification fagaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "fagaceae", "Fagaceae");
        fagales.addMemberGroup(fagaceae);
        IClassification juglandaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "juglandaceae", "Juglandaceae");
        fagales.addMemberGroup(juglandaceae);
        IClassification malvaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "malvaceae", "Malvaceae");
        malvales.addMemberGroup(malvaceae);
        IClassification dipterocarpaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "dipterocarpaceae", "Dipterocarpaceae");
        malvales.addMemberGroup(dipterocarpaceae);
        IClassification pinaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "pinaceae", "Pinaceae");
        pinales.addMemberGroup(pinaceae);
        IClassification cupressaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "cupressaceae", "Cupressaceae");
        pinales.addMemberGroup(cupressaceae);
        IClassification lamiaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "lamiaceae", "Lamiaceae");
        lamiales.addMemberGroup(lamiaceae);
        IClassification ebenaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "ebenaceae", "Ebenaceae");
        ericales.addMemberGroup(ebenaceae);
        IClassification fabaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "fabaceae", "Fabaceae");
        ericales.addMemberGroup(fabaceae);
        IClassification rosaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "rosaceae", "Rosaceae");
        rosales.addMemberGroup(rosaceae);
        IClassification salicaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "salicaceae", "Salicaceae");
        malpighiales.addMemberGroup(salicaceae);
        IClassification lauraceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "lauraceae", "Lauraceae");
        malpighiales.addMemberGroup(lauraceae);
        IClassification rutaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "rutaceae", "Rutaceae");
        sapindales.addMemberGroup(rutaceae);
        IClassification sapindaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "sapindaceae", "Sapindaceae");
        sapindales.addMemberGroup(sapindaceae);
        IClassification caricaceae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "caricaceae", "Caricaceae");
        brassicales.addMemberGroup(caricaceae);
        BranchTrees quercus = new BranchTrees("quercus", "Quercus");
        fagaceae.addMemberGroup(quercus);
        BranchTrees castanea = new BranchTrees("castanea", "Castanea");
        fagaceae.addMemberGroup(castanea);
        BranchTrees betula = new BranchTrees("betula", "Betula");
        betulaceae.addMemberGroup(betula);
        BranchTrees tilia = new BranchTrees("tilia", "Tilia");
        malvaceae.addMemberGroup(tilia);
        BranchTrees ceiba = new BranchTrees("ceiba", "Ceiba");
        malvaceae.addMemberGroup(ceiba);
        BranchTrees adansonia = new BranchTrees("adansonia", "Adansonia");
        malvaceae.addMemberGroup(adansonia);
        BranchTrees picea = new BranchTrees("picea", "Picea");
        pinaceae.addMemberGroup(picea);
        BranchTrees pinus = new BranchTrees("pinus", "Pinus");
        pinaceae.addMemberGroup(pinus);
        BranchTrees larix = new BranchTrees("larix", "Larix");
        pinaceae.addMemberGroup(larix);
        BranchTrees juglans = new BranchTrees("juglans", "Juglans");
        juglandaceae.addMemberGroup(juglans);
        BranchTrees sequoia = new BranchTrees("sequoia", "Sequoia");
        cupressaceae.addMemberGroup(sequoia);
        BranchTrees sequoiadendron = new BranchTrees("sequoiadendron", "Sequoiadendron");
        cupressaceae.addMemberGroup(sequoiadendron);
        BranchTrees tectona = new BranchTrees("tectona", "Tectona");
        lamiaceae.addMemberGroup(tectona);
        BranchTrees diospyros = new BranchTrees("ebony", "Diospyros");
        ebenaceae.addMemberGroup(diospyros);
        BranchTrees shorea = new BranchTrees("mahogany", "Shorea");
        dipterocarpaceae.addMemberGroup(shorea);
        BranchTrees acacia = new BranchTrees("acacia", "Acacia");
        fabaceae.addMemberGroup(acacia);
        BranchTrees millettia = new BranchTrees("millettia", "Millettia");
        fabaceae.addMemberGroup(millettia);
        BranchTrees ochroma = new BranchTrees("ochroma", "Ochroma");
        malvaceae.addMemberGroup(ochroma);
        BranchTrees prunus = new BranchTrees("prunus", "Prunus");
        rosaceae.addMemberGroup(prunus);
        BranchTrees salix = new BranchTrees("salix", "Salix");
        salicaceae.addMemberGroup(salix);
        BranchTrees chlorocardium = new BranchTrees("chlorocardium", "Chlorocardium");
        salicaceae.addMemberGroup(chlorocardium);
        BranchTrees talipariti = new BranchTrees("talipariti", "Talipariti");
        malvaceae.addMemberGroup(talipariti);
        BranchTrees populus = new BranchTrees("populus", "Populus");
        salicaceae.addMemberGroup(populus);
        BranchTrees citrus = new BranchTrees("citrus", "Citrus");
        rutaceae.addMemberGroup(citrus);
        BranchTrees acer = new BranchTrees("acer", "Acer");
        sapindaceae.addMemberGroup(acer);
        BranchTrees tropical = new BranchTrees("Tropical", "");
        BranchTrees carica = new BranchTrees("carica", "Carica");
        FruitFamily prunes = new FruitFamily("prunes", "Prunus domestica");
        FruitFamily pomes = new FruitFamily("pomes", "Pomum");
        FruitFamily jungle = new FruitFamily("jungle", "Tropicus");
        FruitFamily nux = new FruitFamily("nuts", "Nux");
        Allele.treeOak = new AlleleTreeSpecies("treeOak", false, "Apple Oak", quercus, "robur", proxy.getFoliageColorBasic(), WorldGenOak.class, new ItemStack(Block.field_71951_J, 1, 0)).addFruitFamily(pomes).setVanillaMap(0).setIsSecret();
        Allele.treeBirch = new AlleleTreeSpecies("treeBirch", false, "Silver Birch", betula, "pendula", proxy.getFoliageColorBirch(), 11585096, WorldGenBirch.class, new ItemStack(Block.field_71951_J, 1, 2)).setVanillaMap(2).setIsSecret();
        Allele.treeLime = new AlleleTreeSpecies("treeLime", true, "Silver Lime", tilia, "tomentosa", 6201607, WorldGenLime.class, new ItemStack(ForestryBlock.log1, 1, 3)).addFruitFamily(nux).addFruitFamily(prunes).addFruitFamily(pomes);
        Allele.treeWalnut = new AlleleTreeSpecies("treeWalnut", true, "Common Walnut", juglans, "regia", 7965781, 11585096, WorldGenWalnut.class, new ItemStack(ForestryBlock.log4, 1, 1)).addFruitFamily(nux).addFruitFamily(prunes).addFruitFamily(pomes).setGirth(2);
        Allele.treeChestnut = new AlleleTreeSpecies("treeChestnut", true, "Sweet Chestnut", castanea, "sativa", 6201607, 11585096, WorldGenChestnut.class, new ItemStack(ForestryBlock.log2, 1, 0)).addFruitFamily(nux).addFruitFamily(prunes).addFruitFamily(pomes).setGirth(2);
        Allele.treeCherry = new AlleleTreeSpecies("treeCherry", true, "Hill Cherry", prunus, "serrulata", 15110618, 15089241, WorldGenCherry.class, new ItemStack(ForestryBlock.log4, 1, 3)).addFruitFamily(prunes).addFruitFamily(pomes);
        Allele.treeLemon = new AlleleTreeSpecies("treeLemon", true, "Lemon", citrus, "limon", 8957780, 10729552, WorldGenLemon.class, new ItemStack(ForestryBlock.log6, 1, 3)).addFruitFamily(pomes).addFruitFamily(prunes);
        Allele.treePlum = new AlleleTreeSpecies("treePlum", true, "Plum", prunus, "domestica", 5804614, 10729552, WorldGenPlum.class, new ItemStack(ForestryBlock.log6, 1, 1)).addFruitFamily(pomes).addFruitFamily(prunes);
        Allele.treeMaple = new AlleleTreeSpecies("treeMaple", true, "Sugar Maple", acer, "saccharum", 13956133, 6396476, WorldGenMaple.class, new ItemStack(ForestryBlock.log6, 1, 2)).addFruitFamily(prunes).addFruitFamily(pomes).setLeafIndices("maple");
        Allele.treeSpruce = new AlleleTreeSpecies("treeSpruce", false, "Red Spruce", picea, "abies", proxy.getFoliageColorPine(), 5479698, WorldGenSpruce.class, new ItemStack(Block.field_71951_J, 1, 1)).setLeafIndices("conifers").setVanillaMap(1).setIsSecret();
        Allele.treeLarch = new AlleleTreeSpecies("treeLarch", true, "Mundane Larch", larix, "decidua", 6918032, 5675158, WorldGenLarch.class, new ItemStack(ForestryBlock.log1, 1, 0)).setLeafIndices("conifers");
        Allele.treePine = new AlleleTreeSpecies("treePine", true, "Bull Pine", pinus, "sabiniana", 0xFEFF8F, 16767375, WorldGenPine.class, new ItemStack(ForestryBlock.log6, 1, 0)).setLeafIndices("conifers");
        Allele.treeSequioa = new AlleleTreeSpecies("treeSequioa", false, "Coast Sequoia", sequoia, "sempervirens", 4296305, 5675158, WorldGenSequoia.class, new ItemStack(ForestryBlock.log2, 1, 3)).setLeafIndices("conifers").setGirth(3);
        Allele.treeGiganteum = new AlleleTreeSpecies("treeGigant", false, "Giant Sequoia", sequoiadendron, "giganteum", 7570484, WorldGenGiganteum.class, new ItemStack(ForestryBlock.log2, 1, 3)).setLeafIndices("conifers").setGirth(4);
        Allele.treeJungle = new AlleleTreeSpecies("treeJungle", false, "Jungle", tropical, "tectona", proxy.getFoliageColorBasic(), 5479698, WorldGenJungle.class, new ItemStack(Block.field_71951_J, 1, 3)).addFruitFamily(jungle).setLeafIndices("jungle").setVanillaMap(3).setIsSecret();
        Allele.treeTeak = new AlleleTreeSpecies("treeTeak", true, "Teak", tectona, "grandis", 0xFEFF8F, 16767375, WorldGenTeak.class, new ItemStack(ForestryBlock.log1, 1, 3)).addFruitFamily(jungle).setLeafIndices("jungle");
        Allele.treeKapok = new AlleleTreeSpecies("treeKapok", true, "Kapok", ceiba, "pentandra", 9017467, 9022110, WorldGenKapok.class, new ItemStack(ForestryBlock.log3, 1, 0)).addFruitFamily(jungle).addFruitFamily(prunes).setLeafIndices("jungle");
        Allele.treeEbony = new AlleleTreeSpecies("treeEbony", true, "Myrtle Ebony", diospyros, "pentamera", 10670666, 12898890, WorldGenEbony.class, new ItemStack(ForestryBlock.log3, 1, 1)).addFruitFamily(jungle).addFruitFamily(prunes).setGirth(3).setLeafIndices("jungle");
        Allele.treeMahogany = new AlleleTreeSpecies("treeMahogony", true, "Yellow Meranti", shorea, "gibbosa", 9089364, 11120980, WorldGenMahogany.class, new ItemStack(ForestryBlock.log3, 1, 2)).addFruitFamily(jungle).setGirth(2).setLeafIndices("jungle");
        Allele.treeAcacia = new AlleleTreeSpecies("treeAcacia", true, "Desert Acacia", acacia, "erioloba", 0x616101, 11776770, WorldGenAcacia.class, new ItemStack(ForestryBlock.log1, 1, 2)).addFruitFamily(jungle).addFruitFamily(nux);
        Allele.treeBalsa = new AlleleTreeSpecies("treeBalsa", true, "Balsa", ochroma, "pyramidale", 5876736, 0xFEFF8F, WorldGenBalsa.class, new ItemStack(ForestryBlock.log3, 1, 3)).addFruitFamily(jungle).addFruitFamily(nux);
        Allele.treeWenge = new AlleleTreeSpecies("treeWenge", true, "Wenge", millettia, "laurentii", 11379031, 11373143, WorldGenWenge.class, new ItemStack(ForestryBlock.log2, 1, 1)).addFruitFamily(jungle).addFruitFamily(nux).setGirth(2);
        Allele.treeBaobab = new AlleleTreeSpecies("treeBaobab", true, "Grandidier's Baobab", adansonia, "digitata", 0xFEFF8F, 16767375, WorldGenBaobab.class, new ItemStack(ForestryBlock.log2, 1, 2)).addFruitFamily(jungle).addFruitFamily(nux).setGirth(3);
        Allele.treeMahoe = new AlleleTreeSpecies("treeMahoe", true, "Blue Mahoe", talipariti, "elatum", 10533403, 7971189, WorldGenMahoe.class, new ItemStack(ForestryBlock.log5, 1, 0)).addFruitFamily(jungle).addFruitFamily(pomes).addFruitFamily(prunes);
        Allele.treeWillow = new AlleleTreeSpecies("treeWillow", true, "White Willow", salix, "alba", 10729637, 10729552, WorldGenWillow.class, new ItemStack(ForestryBlock.log4, 1, 0)).addFruitFamily(nux).addFruitFamily(prunes).addFruitFamily(pomes).setLeafIndices("willow");
        Allele.treeSipiri = new AlleleTreeSpecies("treeSipiri", true, "Sipiri", chlorocardium, "rodiei", 6785297, 7971189, WorldGenGreenheart.class, new ItemStack(ForestryBlock.log3, 1, 2)).addFruitFamily(jungle);
        Allele.treePapaya = new AlleleTreeSpecies("treePapaya", true, "Papaya", carica, "papaya", 7184216, 10413695, WorldGenPapaya.class, new ItemStack(ForestryBlock.log5, 1, 3)).addFruitFamily(jungle).addFruitFamily(nux).setLeafIndices("palm");
        Allele.treeDate = new AlleleTreeSpecies("treeDate", true, "Date Palm", null, "dactylifera", 13356409, 15790991, WorldGenDate.class, new ItemStack(ForestryBlock.log4, 1, 2)).addFruitFamily(jungle).addFruitFamily(nux).setLeafIndices("palm");
        Allele.treePoplar = new AlleleTreeSpecies("treePoplar", true, "White Poplar", populus, "alba", 10729637, 5479698, WorldGenPoplar.class, new ItemStack(ForestryBlock.log5, 1, 1)).addFruitFamily(pomes).addFruitFamily(prunes);
        Allele.fruitNone = new AlleleFruit("fruitNone", new FruitProviderNone("none", null));
        Allele.fruitApple = new AlleleFruit("fruitApple", new FruitProviderRandom("apple", pomes, new ItemStack(Item.field_77706_j), 1.0f).setColour(0xFF2E2E).setOverlay("pomes"));
        Allele.fruitCocoa = new AlleleFruit("fruitCocoa", new FruitProviderPod("cocoa", jungle, FruitProviderPod.EnumPodType.COCOA, new ItemStack[0]));
        Allele.fruitChestnut = new AlleleFruit("fruitChestnut", new FruitProviderRipening("chestnut", nux, ForestryItem.fruits.getItemStack(1, ItemFruit.EnumFruit.CHESTNUT.ordinal()), 1.0f).setRipeningPeriod(6).setColours(8336189, 12898890).setOverlay("nuts"), true);
        Allele.fruitWalnut = new AlleleFruit("fruitWalnut", new FruitProviderRipening("walnut", nux, ForestryItem.fruits.getItemStack(1, ItemFruit.EnumFruit.WALNUT.ordinal()), 1.0f).setRipeningPeriod(8).setColours(16491080, 12898890).setOverlay("nuts"), true);
        Allele.fruitCherry = new AlleleFruit("fruitCherry", new FruitProviderRipening("cherry", prunes, ForestryItem.fruits.getItemStack(1, ItemFruit.EnumFruit.CHERRY.ordinal()), 1.0f).setColours(0xFF2E2E, 12898890).setOverlay("berries"), true);
        Allele.fruitDates = new AlleleFruit("fruitDates", new FruitProviderPod("dates", jungle, FruitProviderPod.EnumPodType.DATES, ForestryItem.fruits.getItemStack(4, ItemFruit.EnumFruit.DATES.ordinal())));
        Allele.fruitPapaya = new AlleleFruit("fruitPapaya", new FruitProviderPod("papaya", jungle, FruitProviderPod.EnumPodType.PAPAYA, ForestryItem.fruits.getItemStack(1, ItemFruit.EnumFruit.PAPAYA.ordinal())));
        Allele.fruitLemon = new AlleleFruit("fruitLemon", new FruitProviderRipening("lemon", prunes, ForestryItem.fruits.getItemStack(1, ItemFruit.EnumFruit.LEMON.ordinal()), 1.0f).setColours(0xEEEE00, 0x99FF00).setOverlay("citrus"), true);
        Allele.fruitPlum = new AlleleFruit("fruitPlum", new FruitProviderRipening("plum", prunes, ForestryItem.fruits.getItemStack(1, ItemFruit.EnumFruit.PLUM.ordinal()), 1.0f).setColours(0x663446, 15662874).setOverlay("plums"), true);
        Allele.growthLightlevel = new AlleleGrowth("growthLightlevel", new GrowthProvider());
        Allele.growthAcacia = new AlleleGrowth("growthAcacia", new GrowthProvider());
        Allele.growthTropical = new AlleleGrowth("growthTropical", new GrowthProviderTropical());
        Allele.leavesNone = new AlleleLeafEffectNone("leavesNone");
    }

    private void registerTemplates() {
        treeInterface.registerTemplate(TreeTemplates.getOakTemplate());
        treeInterface.registerTemplate(TreeTemplates.getBirchTemplate());
        treeInterface.registerTemplate(TreeTemplates.getSpruceTemplate());
        treeInterface.registerTemplate(TreeTemplates.getJungleTemplate());
        treeInterface.registerTemplate(TreeTemplates.getLimeTemplate());
        treeInterface.registerTemplate(TreeTemplates.getCherryTemplate());
        treeInterface.registerTemplate(TreeTemplates.getChestnutTemplate());
        treeInterface.registerTemplate(TreeTemplates.getWalnutTemplate());
        treeInterface.registerTemplate(TreeTemplates.getLarchTemplate());
        treeInterface.registerTemplate(TreeTemplates.getPineTemplate());
        treeInterface.registerTemplate(TreeTemplates.getSequoiaTemplate());
        treeInterface.registerTemplate(TreeTemplates.getGiganteumTemplate());
        treeInterface.registerTemplate(TreeTemplates.getBalsaTemplate());
        treeInterface.registerTemplate(TreeTemplates.getAcaciaTemplate());
        treeInterface.registerTemplate(TreeTemplates.getWengeTemplate());
        treeInterface.registerTemplate(TreeTemplates.getBaobabTemplate());
        treeInterface.registerTemplate(TreeTemplates.getTeakTemplate());
        treeInterface.registerTemplate(TreeTemplates.getKapokTemplate());
        treeInterface.registerTemplate(TreeTemplates.getEbonyTemplate());
        treeInterface.registerTemplate(TreeTemplates.getMahoganyTemplate());
        treeInterface.registerTemplate(TreeTemplates.getWillowTemplate());
        treeInterface.registerTemplate(TreeTemplates.getSipiriTemplate());
        treeInterface.registerTemplate(TreeTemplates.getMahoeTemplate());
        treeInterface.registerTemplate(TreeTemplates.getPoplarTemplate());
        treeInterface.registerTemplate(TreeTemplates.getLemonTemplate());
        treeInterface.registerTemplate(TreeTemplates.getPlumTemplate());
        treeInterface.registerTemplate(TreeTemplates.getMapleTemplate());
        treeInterface.registerTemplate(TreeTemplates.getPapayaTemplate());
        treeInterface.registerTemplate(TreeTemplates.getDateTemplate());
    }

    private void registerErsatzGenomes() {
        AlleleManager.ersatzSpecimen.put(new ItemStack(Block.field_71952_K.field_71990_ca, 1, 0), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getOakTemplate())));
        AlleleManager.ersatzSpecimen.put(new ItemStack(Block.field_71952_K.field_71990_ca, 1, 1), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getSpruceTemplate())));
        AlleleManager.ersatzSpecimen.put(new ItemStack(Block.field_71952_K.field_71990_ca, 1, 2), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getBirchTemplate())));
        AlleleManager.ersatzSpecimen.put(new ItemStack(Block.field_71952_K.field_71990_ca, 1, 3), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getJungleTemplate())));
        AlleleManager.ersatzSaplings.put(new ItemStack(Block.field_71987_y.field_71990_ca, 1, 0), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getOakTemplate())));
        AlleleManager.ersatzSaplings.put(new ItemStack(Block.field_71987_y.field_71990_ca, 1, 1), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getSpruceTemplate())));
        AlleleManager.ersatzSaplings.put(new ItemStack(Block.field_71987_y.field_71990_ca, 1, 2), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getBirchTemplate())));
        AlleleManager.ersatzSaplings.put(new ItemStack(Block.field_71987_y.field_71990_ca, 1, 3), new Tree(TreeTemplates.templateAsGenome(TreeTemplates.getJungleTemplate())));
    }

    private void createMutations() {
        TreeTemplates.limeA = new TreeMutation(Allele.treeBirch, Allele.treeOak, TreeTemplates.getLimeTemplate(), 15);
        TreeTemplates.mapleA = new TreeMutation(Allele.treeLime, Allele.treeLarch, TreeTemplates.getMapleTemplate(), 5);
        TreeTemplates.cherryA = new TreeMutation(Allele.treeLime, Allele.treeOak, TreeTemplates.getCherryTemplate(), 10);
        TreeTemplates.cherryB = new TreeMutation(Allele.treeLime, Allele.treeBirch, TreeTemplates.getCherryTemplate(), 10);
        TreeTemplates.lemonA = new TreeMutation(Allele.treeLime, Allele.treeCherry, TreeTemplates.getLemonTemplate(), 5);
        TreeTemplates.plumA = new TreeMutation(Allele.treeLemon, Allele.treeCherry, TreeTemplates.getPlumTemplate(), 5);
        TreeTemplates.walnutA = new TreeMutation(Allele.treeLime, Allele.treeCherry, TreeTemplates.getWalnutTemplate(), 10);
        TreeTemplates.chestnutA = new TreeMutation(Allele.treeWalnut, Allele.treeLime, TreeTemplates.getChestnutTemplate(), 10);
        TreeTemplates.chestnutB = new TreeMutation(Allele.treeWalnut, Allele.treeCherry, TreeTemplates.getChestnutTemplate(), 10);
        TreeTemplates.larchA = new TreeMutation(Allele.treeSpruce, Allele.treeBirch, TreeTemplates.getLarchTemplate(), 10);
        TreeTemplates.larchB = new TreeMutation(Allele.treeSpruce, Allele.treeOak, TreeTemplates.getLarchTemplate(), 10);
        TreeTemplates.pineA = new TreeMutation(Allele.treeSpruce, Allele.treeLarch, TreeTemplates.getPineTemplate(), 10);
        TreeTemplates.sequoiaA = new TreeMutation(Allele.treeLarch, Allele.treePine, TreeTemplates.getSequoiaTemplate(), 5);
        TreeTemplates.teakA = new TreeMutation(Allele.treeLime, Allele.treeJungle, TreeTemplates.getTeakTemplate(), 10);
        TreeTemplates.kapokA = new TreeMutation(Allele.treeJungle, Allele.treeTeak, TreeTemplates.getKapokTemplate(), 10);
        TreeTemplates.ebonyA = new TreeMutation(Allele.treeKapok, Allele.treeTeak, TreeTemplates.getEbonyTemplate(), 10);
        TreeTemplates.mahoganyA = new TreeMutation(Allele.treeKapok, Allele.treeEbony, TreeTemplates.getMahoganyTemplate(), 10);
        TreeTemplates.papayaA = new TreeMutation(Allele.treeJungle, Allele.treeCherry, TreeTemplates.getPapayaTemplate(), 5);
        TreeTemplates.dateA = new TreeMutation(Allele.treeJungle, Allele.treePapaya, TreeTemplates.getDateTemplate(), 5);
        TreeTemplates.balsaA = new TreeMutation(Allele.treeTeak, Allele.treeLime, TreeTemplates.getBalsaTemplate(), 10);
        TreeTemplates.acaciaA = new TreeMutation(Allele.treeTeak, Allele.treeBalsa, TreeTemplates.getAcaciaTemplate(), 10);
        TreeTemplates.wengeA = new TreeMutation(Allele.treeAcacia, Allele.treeBalsa, TreeTemplates.getWengeTemplate(), 10);
        TreeTemplates.baobabA = new TreeMutation(Allele.treeBalsa, Allele.treeWenge, TreeTemplates.getBaobabTemplate(), 10);
        TreeTemplates.mahoeA = new TreeMutation(Allele.treeBirch, Allele.treeAcacia, TreeTemplates.getMahoeTemplate(), 5);
        TreeTemplates.willowA = new TreeMutation(Allele.treeOak, Allele.treeBirch, TreeTemplates.getWillowTemplate(), 10).setTemperatureRainfall(0.7f, 1.5f, 0.9f, 2.0f);
        TreeTemplates.willowB = new TreeMutation(Allele.treeOak, Allele.treeLime, TreeTemplates.getWillowTemplate(), 10).setTemperatureRainfall(0.7f, 1.5f, 0.9f, 2.0f);
        TreeTemplates.willowC = new TreeMutation(Allele.treeLime, Allele.treeBirch, TreeTemplates.getWillowTemplate(), 10).setTemperatureRainfall(0.7f, 1.5f, 0.9f, 2.0f);
        TreeTemplates.sipiriA = new TreeMutation(Allele.treeKapok, Allele.treeMahogany, TreeTemplates.getSipiriTemplate(), 10).setTemperatureRainfall(0.9f, 1.9f, 0.9f, 2.0f);
        TreeTemplates.poplarA = new TreeMutation(Allele.treeBirch, Allele.treeWillow, TreeTemplates.getPoplarTemplate(), 5);
        TreeTemplates.poplarB = new TreeMutation(Allele.treeOak, Allele.treeWillow, TreeTemplates.getPoplarTemplate(), 5);
        TreeTemplates.poplarB = new TreeMutation(Allele.treeLime, Allele.treeWillow, TreeTemplates.getPoplarTemplate(), 5);
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerArboriculture();
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return null;
    }

    @Override
    public IOreDictionaryHandler getDictionaryHandler() {
        return null;
    }

    @Override
    public ICommand[] getConsoleCommands() {
        return new ICommand[]{new CommandSpawnTree(), new CommandSpawnForest(), new CommandTreekeepingMode()};
    }

    public int getBurnTime(ItemStack fuel) {
        if (ForestryItem.sapling.isItemEqual(fuel)) {
            return 100;
        }
        return 0;
    }

    @Override
    public IPacketHandler getPacketHandler() {
        return new PacketHandlerArboriculture();
    }

    @Override
    public boolean processIMCMessage(FMLInterModComms.IMCMessage message) {
        if (message.key.equals("add-fence-block") && message.isStringMessage()) {
            try {
                int id = Integer.parseInt(message.getStringValue());
                validFenceIDs.add(id);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.processIMCMessage(message);
    }

    private void registerDungeonLoot() {
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(ForestryItem.grafter.getItemStack(), 1, 1, 8));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(this.getTreeItemFromTemplate(TreeTemplates.getOakTemplate(), EnumGermlingType.SAPLING), 2, 3, 6));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(this.getTreeItemFromTemplate(TreeTemplates.getSpruceTemplate(), EnumGermlingType.SAPLING), 2, 3, 6));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(this.getTreeItemFromTemplate(TreeTemplates.getBirchTemplate(), EnumGermlingType.SAPLING), 2, 3, 6));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(this.getTreeItemFromTemplate(TreeTemplates.getLarchTemplate(), EnumGermlingType.SAPLING), 1, 2, 4));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(this.getTreeItemFromTemplate(TreeTemplates.getLimeTemplate(), EnumGermlingType.SAPLING), 1, 2, 4));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(this.getTreeItemFromTemplate(TreeTemplates.getOakTemplate(), EnumGermlingType.POLLEN), 2, 3, 4));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(this.getTreeItemFromTemplate(TreeTemplates.getSpruceTemplate(), EnumGermlingType.POLLEN), 2, 3, 4));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(this.getTreeItemFromTemplate(TreeTemplates.getBirchTemplate(), EnumGermlingType.POLLEN), 2, 3, 4));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(this.getTreeItemFromTemplate(TreeTemplates.getLarchTemplate(), EnumGermlingType.POLLEN), 1, 2, 3));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(this.getTreeItemFromTemplate(TreeTemplates.getLimeTemplate(), EnumGermlingType.POLLEN), 1, 2, 3));
    }

    private ItemStack getTreeItemFromTemplate(IAllele[] template, EnumGermlingType type) {
        ItemStack treeItem;
        Tree tree = new Tree(treeInterface.templateAsGenome(template));
        switch (type) {
            default: {
                treeItem = ForestryItem.pollenFertile.getItemStack();
                break;
            }
            case SAPLING: {
                treeItem = ForestryItem.sapling.getItemStack();
            }
        }
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        tree.writeToNBT(nbtTagCompound);
        treeItem.func_77982_d(nbtTagCompound);
        return treeItem;
    }

    static {
        treekeepingMode = "NORMAL";
        validFenceIDs = new ArrayList();
    }
}

