/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.api.mail.ILetter;
import forestry.api.mail.IPostOffice;
import forestry.api.mail.IPostRegistry;
import forestry.api.mail.IPostalCarrier;
import forestry.api.mail.MailAddress;
import forestry.api.mail.PostManager;
import forestry.core.config.ForestryItem;
import forestry.mail.Letter;
import forestry.mail.POBox;
import forestry.mail.PostOffice;
import forestry.mail.TradeStation;
import forestry.mail.items.ItemLetter;
import forestry.plugins.PluginMail;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class PostRegistry
implements IPostRegistry {
    public static PostOffice cachedPostOffice;
    public static HashMap cachedPOBoxes;
    public static HashMap cachedTradeStations;
    private HashMap carriers = new HashMap();

    @Override
    public boolean isValidPOBox(World world, String username) {
        return username.matches("^[a-zA-Z0-9]+$");
    }

    public static POBox getPOBox(World world, String username) {
        if (cachedPOBoxes.containsKey(username.toLowerCase(Locale.ENGLISH))) {
            return (POBox)((Object)cachedPOBoxes.get(username.toLowerCase(Locale.ENGLISH)));
        }
        POBox pobox = (POBox)world.func_72943_a(POBox.class, "POBox_" + username.toLowerCase(Locale.ENGLISH));
        if (pobox != null) {
            cachedPOBoxes.put(username.toLowerCase(Locale.ENGLISH), pobox);
        }
        return pobox;
    }

    public static POBox getOrCreatePOBox(World world, String username) {
        POBox pobox = PostRegistry.getPOBox(world, username);
        if (pobox == null) {
            pobox = new POBox(username.toLowerCase(Locale.ENGLISH), true);
            world.func_72823_a("POBox_" + username.toLowerCase(Locale.ENGLISH), (WorldSavedData)pobox);
            pobox.func_76185_a();
            cachedPOBoxes.put(username.toLowerCase(Locale.ENGLISH), pobox);
            PluginMail.proxy.setPOBoxInfo(world, username, pobox.getPOBoxInfo());
        }
        return pobox;
    }

    @Override
    public boolean isValidTradeMoniker(World world, String moniker) {
        return moniker.matches("^[a-zA-Z0-9]+$");
    }

    @Override
    public boolean isAvailableTradeMoniker(World world, String moniker) {
        return this.getTradeStation(world, moniker) == null;
    }

    @Override
    public TradeStation getTradeStation(World world, String moniker) {
        if (cachedTradeStations.containsKey(moniker)) {
            return (TradeStation)cachedTradeStations.get(moniker);
        }
        TradeStation trade = (TradeStation)world.func_72943_a(TradeStation.class, "TradePO_" + moniker);
        if (trade != null && trade.isValid()) {
            cachedTradeStations.put(moniker, trade);
            this.getPostOffice(world).registerTradeStation(trade);
            return trade;
        }
        return null;
    }

    @Override
    public TradeStation getOrCreateTradeStation(World world, String owner, String moniker) {
        TradeStation trade = this.getTradeStation(world, moniker);
        if (trade == null) {
            trade = new TradeStation(owner, moniker, true);
            world.func_72823_a("TradePO_" + moniker, (WorldSavedData)trade);
            trade.func_76185_a();
            cachedTradeStations.put(moniker, trade);
            this.getPostOffice(world).registerTradeStation(trade);
        }
        return trade;
    }

    @Override
    public void deleteTradeStation(World world, String moniker) {
        TradeStation trade = this.getTradeStation(world, moniker);
        if (trade == null) {
            return;
        }
        trade.invalidate();
        cachedTradeStations.remove(moniker);
        this.getPostOffice(world).deregisterTradeStation(trade);
        File file = world.func_72860_G().func_75758_b(trade.field_76190_i);
        file.delete();
    }

    @Override
    public IPostOffice getPostOffice(World world) {
        if (cachedPostOffice != null) {
            return cachedPostOffice;
        }
        PostOffice office = (PostOffice)world.func_72943_a(PostOffice.class, "ForestryMail");
        if (office == null) {
            office = new PostOffice();
            world.func_72823_a("ForestryMail", (WorldSavedData)office);
        }
        cachedPostOffice = office;
        return office;
    }

    @Override
    public Map getRegisteredCarriers() {
        return this.carriers;
    }

    @Override
    public void registerCarrier(IPostalCarrier carrier) {
        this.carriers.put(carrier.getUID(), carrier);
    }

    @Override
    public IPostalCarrier getCarrier(String uid) {
        return (IPostalCarrier)this.carriers.get(uid);
    }

    @Override
    public ILetter createLetter(MailAddress sender, MailAddress recipient) {
        return new Letter(sender, recipient);
    }

    @Override
    public ItemStack createLetterStack(ILetter letter) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        letter.writeToNBT(nbttagcompound);
        ItemStack mailstack = ForestryItem.letters.getItemStack(1, ItemLetter.encodeMeta(1, ItemLetter.getType(letter)));
        mailstack.func_77982_d(nbttagcompound);
        return mailstack;
    }

    @Override
    public ILetter getLetter(ItemStack itemstack) {
        if (itemstack == null) {
            return null;
        }
        if (!PostManager.postRegistry.isLetter(itemstack)) {
            return null;
        }
        if (itemstack.func_77978_p() == null) {
            return null;
        }
        return new Letter(itemstack.func_77978_p());
    }

    @Override
    public boolean isLetter(ItemStack itemstack) {
        return ForestryItem.letters.isItemEqual(itemstack);
    }

    static {
        cachedPOBoxes = new HashMap();
        cachedTradeStations = new HashMap();
    }
}

