/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.circuits;

import forestry.api.farming.IFarmHousing;
import forestry.core.circuits.Circuit;
import forestry.farming.logic.FarmLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class CircuitFarmLogic
extends Circuit {
    private Class logicClass;
    private boolean isManual = false;

    public CircuitFarmLogic(String uid, Class logicClass, String[] descriptions) {
        super(uid, false, uid, descriptions);
        this.logicClass = logicClass;
        this.setLimit(4);
    }

    public CircuitFarmLogic setManual() {
        this.isManual = true;
        return this;
    }

    @Override
    public boolean isCircuitable(TileEntity tile) {
        return tile instanceof IFarmHousing;
    }

    @Override
    public void onInsertion(int slot, TileEntity tile) {
        if (!this.isCircuitable(tile)) {
            return;
        }
        FarmLogic logic = null;
        try {
            logic = (FarmLogic)this.logicClass.getConstructor(IFarmHousing.class).newInstance((IFarmHousing)tile);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to instantiate logic of class " + this.logicClass.getName() + ": " + ex.getMessage());
        }
        if (logic != null) {
            logic.setManual(this.isManual);
            ((IFarmHousing)tile).setFarmLogic(ForgeDirection.values()[slot + 2], logic);
        }
    }

    @Override
    public void onLoad(int slot, TileEntity tile) {
        this.onInsertion(slot, tile);
    }

    @Override
    public void onRemoval(int slot, TileEntity tile) {
        if (!this.isCircuitable(tile)) {
            return;
        }
        ((IFarmHousing)tile).resetFarmLogic(ForgeDirection.values()[slot + 2]);
    }

    @Override
    public void onTick(int slot, TileEntity tile) {
    }
}

