/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory.manipulators;

import buildcraft.api.inventory.ISelectiveInventory;
import forestry.core.inventory.filters.ArrayStackFilter;
import forestry.core.inventory.filters.IStackFilter;
import forestry.core.inventory.manipulators.SpecialManipulator;
import net.minecraft.item.ItemStack;

public class SelectiveManipulator
extends SpecialManipulator {
    private ISelectiveInventory inv;

    public SelectiveManipulator(ISelectiveInventory inv) {
        super(inv);
        this.inv = inv;
    }

    @Override
    protected ItemStack removeStackInternal(IStackFilter filter, boolean doRemove) {
        ArrayStackFilter aFilter;
        if (filter instanceof ArrayStackFilter && (aFilter = (ArrayStackFilter)filter).hasFilter()) {
            Object[] filters = aFilter.getStacks();
            ItemStack[] extracted = this.inv.extractItem(filters, false, false, this.side, 1);
            if (extracted != null && extracted.length == 1 && filter.matches(extracted[0])) {
                if (doRemove) {
                    this.inv.extractItem(filters, false, true, this.side, 1);
                }
                return extracted[0];
            }
            return null;
        }
        return super.removeStackInternal(filter, doRemove);
    }
}

