/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.core.utils.StringUtil;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class FlowerProviderNetherwart
implements IFlowerProvider {
    @Override
    public boolean isAcceptedFlower(World world, IIndividual individual, int x, int y, int z) {
        int blockid = world.func_72798_a(x, y, z);
        return blockid == Block.field_72094_bD.field_71990_ca;
    }

    @Override
    public boolean isAcceptedPollinatable(World world, IPollinatable pollinatable) {
        return pollinatable.getPlantType().contains(EnumPlantType.Nether);
    }

    @Override
    public boolean growFlower(World world, IIndividual individual, int x, int y, int z) {
        int blockid = world.func_72798_a(x, y, z);
        if (blockid != Block.field_72094_bD.field_71990_ca) {
            return false;
        }
        int meta = world.func_72805_g(x, y, z);
        if (meta >= 3) {
            return false;
        }
        meta = meta == 2 ? 3 : 2;
        world.func_72921_c(x, y, z, meta, 2);
        return true;
    }

    @Override
    public String getDescription() {
        return StringUtil.localize("flowers.nether");
    }

    @Override
    public ItemStack[] affectProducts(World world, IIndividual individual, int x, int y, int z, ItemStack[] products) {
        return products;
    }

    @Override
    public ItemStack[] getItemStacks() {
        return new ItemStack[]{new ItemStack(Block.field_72094_bD)};
    }
}

