/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.relauncher;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ReflectionHelper {
    public static Field findField(Class<?> clazz, String ... fieldNames) {
        Exception failed = null;
        for (String fieldName : fieldNames) {
            try {
                Field f = clazz.getDeclaredField(fieldName);
                f.setAccessible(true);
                return f;
            }
            catch (Exception e) {
                failed = e;
            }
        }
        throw new UnableToFindFieldException(fieldNames, failed);
    }

    public static <T, E> T getPrivateValue(Class<? super E> classToAccess, E instance, int fieldIndex) {
        try {
            Field f = classToAccess.getDeclaredFields()[fieldIndex];
            f.setAccessible(true);
            return (T)f.get(instance);
        }
        catch (Exception e) {
            throw new UnableToAccessFieldException(new String[0], e);
        }
    }

    public static <T, E> T getPrivateValue(Class<? super E> classToAccess, E instance, String ... fieldNames) {
        try {
            return (T)ReflectionHelper.findField(classToAccess, fieldNames).get(instance);
        }
        catch (Exception e) {
            throw new UnableToAccessFieldException(fieldNames, e);
        }
    }

    public static <T, E> void setPrivateValue(Class<? super T> classToAccess, T instance, E value, int fieldIndex) {
        try {
            Field f = classToAccess.getDeclaredFields()[fieldIndex];
            f.setAccessible(true);
            f.set(instance, value);
        }
        catch (Exception e) {
            throw new UnableToAccessFieldException(new String[0], e);
        }
    }

    public static <T, E> void setPrivateValue(Class<? super T> classToAccess, T instance, E value, String ... fieldNames) {
        try {
            ReflectionHelper.findField(classToAccess, fieldNames).set(instance, value);
        }
        catch (Exception e) {
            throw new UnableToAccessFieldException(fieldNames, e);
        }
    }

    public static Class<? super Object> getClass(ClassLoader loader, String ... classNames) {
        Exception err = null;
        for (String className : classNames) {
            try {
                return Class.forName(className, false, loader);
            }
            catch (Exception e) {
                err = e;
            }
        }
        throw new UnableToFindClassException(classNames, err);
    }

    public static <E> Method findMethod(Class<? super E> clazz, E instance, String[] methodNames, Class<?> ... methodTypes) {
        Exception failed = null;
        for (String methodName : methodNames) {
            try {
                Method m2 = clazz.getDeclaredMethod(methodName, methodTypes);
                m2.setAccessible(true);
                return m2;
            }
            catch (Exception e) {
                failed = e;
            }
        }
        throw new UnableToFindMethodException(methodNames, failed);
    }

    public static class UnableToFindFieldException
    extends RuntimeException {
        private String[] fieldNameList;

        public UnableToFindFieldException(String[] fieldNameList, Exception e) {
            super(e);
            this.fieldNameList = fieldNameList;
        }
    }

    public static class UnableToAccessFieldException
    extends RuntimeException {
        private String[] fieldNameList;

        public UnableToAccessFieldException(String[] fieldNames, Exception e) {
            super(e);
            this.fieldNameList = fieldNames;
        }
    }

    public static class UnableToFindClassException
    extends RuntimeException {
        private String[] classNames;

        public UnableToFindClassException(String[] classNames, Exception err) {
            super(err);
            this.classNames = classNames;
        }
    }

    public static class UnableToFindMethodException
    extends RuntimeException {
        private String[] methodNames;

        public UnableToFindMethodException(String[] methodNames, Exception failed) {
            super(failed);
            this.methodNames = methodNames;
        }
    }
}

