/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.PipeManager;
import buildcraft.core.inventory.InventoryWrapper;
import buildcraft.core.utils.Utils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.pipes.PipeLogicWood;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsWood
extends Pipe<PipeTransportItems>
implements IPowerReceptor {
    protected PowerHandler powerHandler;
    protected int standardIconIndex = PipeIconProvider.TYPE.PipeItemsWood_Standard.ordinal();
    protected int solidIconIndex = PipeIconProvider.TYPE.PipeAllWood_Solid.ordinal();
    private PipeLogicWood logic = new PipeLogicWood(this){

        @Override
        protected boolean isValidConnectingTile(TileEntity tile) {
            if (tile instanceof IPipeTile) {
                return false;
            }
            if (!(tile instanceof IInventory)) {
                return false;
            }
            return PipeManager.canExtractItems(this.pipe, tile.field_70331_k, tile.field_70329_l, tile.field_70330_m, tile.field_70327_n);
        }
    };

    public PipeItemsWood(int itemID) {
        super(new PipeTransportItems(), itemID);
        this.powerHandler = new PowerHandler(this, PowerHandler.Type.MACHINE);
        this.powerHandler.configure(1.0f, 64.1f, 1.0f, 64.1f);
        this.powerHandler.configurePowerPerdition(0, 0);
    }

    @Override
    public boolean blockActivated(EntityPlayer entityplayer) {
        return this.logic.blockActivated(entityplayer);
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        this.logic.onNeighborBlockChange(blockId);
        super.onNeighborBlockChange(blockId);
    }

    @Override
    public void initialize() {
        this.logic.initialize();
        super.initialize();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return this.standardIconIndex;
        }
        int metadata = this.container.func_70322_n();
        if (metadata == direction.ordinal()) {
            return this.solidIconIndex;
        }
        return this.standardIconIndex;
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.powerHandler.getPowerReceiver();
    }

    @Override
    public void doWork(PowerHandler workProvider) {
        if (this.powerHandler.getEnergyStored() <= 0.0f) {
            return;
        }
        if (((PipeTransportItems)this.transport).getNumberOfStacks() < 64) {
            this.extractItems();
        }
        this.powerHandler.setEnergy(0.0f);
    }

    private void extractItems() {
        int meta = this.container.func_70322_n();
        if (meta > 5) {
            return;
        }
        ForgeDirection side = ForgeDirection.getOrientation((int)meta);
        TileEntity tile = this.container.getTile(side);
        if (tile instanceof IInventory) {
            if (!PipeManager.canExtractItems(this, tile.field_70331_k, tile.field_70329_l, tile.field_70330_m, tile.field_70327_n)) {
                return;
            }
            IInventory inventory = (IInventory)tile;
            ItemStack[] extracted = this.checkExtract(inventory, true, side.getOpposite());
            if (extracted == null) {
                return;
            }
            tile.func_70296_d();
            for (ItemStack stack : extracted) {
                if (stack == null || stack.field_77994_a == 0) {
                    this.powerHandler.useEnergy(1.0f, 1.0f, true);
                    continue;
                }
                Position entityPos = new Position((double)tile.field_70329_l + 0.5, (double)tile.field_70330_m + 0.5, (double)tile.field_70327_n + 0.5, side.getOpposite());
                entityPos.moveForwards(0.6);
                TravelingItem entity = this.makeItem(entityPos.x, entityPos.y, entityPos.z, stack);
                ((PipeTransportItems)this.transport).injectItem(entity, entityPos.orientation);
            }
        }
    }

    protected TravelingItem makeItem(double x, double y, double z, ItemStack stack) {
        return new TravelingItem(x, y, z, stack);
    }

    public ItemStack[] checkExtract(IInventory inventory, boolean doRemove, ForgeDirection from) {
        if (inventory instanceof ISpecialInventory) {
            ItemStack[] stacks = ((ISpecialInventory)inventory).extractItem(doRemove, from, Math.min((int)this.powerHandler.getEnergyStored(), 1024 - ((PipeTransportItems)this.transport).getNumberOfItems()));
            if (stacks != null && doRemove) {
                for (ItemStack stack : stacks) {
                    if (stack == null) continue;
                    this.powerHandler.useEnergy(stack.field_77994_a, stack.field_77994_a, true);
                }
            }
            return stacks;
        }
        IInventory inv = Utils.getInventory(inventory);
        ItemStack result = this.checkExtractGeneric(inv, doRemove, from);
        if (result != null) {
            return new ItemStack[]{result};
        }
        return null;
    }

    public ItemStack checkExtractGeneric(IInventory inventory, boolean doRemove, ForgeDirection from) {
        return this.checkExtractGeneric(InventoryWrapper.getWrappedInventory(inventory), doRemove, from);
    }

    public ItemStack checkExtractGeneric(ISidedInventory inventory, boolean doRemove, ForgeDirection from) {
        if (inventory == null) {
            return null;
        }
        for (int k : inventory.func_94128_d(from.ordinal())) {
            ItemStack slot = inventory.func_70301_a(k);
            if (slot == null || slot.field_77994_a <= 0 || !inventory.func_102008_b(k, slot, from.ordinal())) continue;
            if (doRemove) {
                return inventory.func_70298_a(k, (int)this.powerHandler.useEnergy(1.0f, slot.field_77994_a, true));
            }
            return slot;
        }
        return null;
    }
}

