/*
 * Decompiled with CFR 0.152.
 */
package ic2.neiIntegration.core;

import codechicken.core.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import ic2.core.block.machine.gui.GuiCentrifuge;
import ic2.core.util.StackUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class CentrifugeRecipeHandler
extends TemplateRecipeHandler {
    int ticks;

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)4, (int)0, (int)3, (int)14, (int)146, (int)68);
    }

    public void drawExtras(int i) {
        float f = this.ticks >= 20 ? (float)((this.ticks - 20) % 20) / 20.0f : 0.0f;
        this.drawProgressBar(84, 10, 176, 50, 5, 30, f, 3);
        f = this.ticks <= 20 ? (float)this.ticks / 20.0f : 1.0f;
        this.drawProgressBar(12, 28, 176, 0, 14, 14, f, 3);
        this.drawProgressBar(93, 48, 176, 36, 14, 14, 1.0f, 0);
        this.drawProgressBar(68, 52, 176, 28, 23, 8, 1.0f, 0);
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticks;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(41, 4, 80, 42), this.getRecipeId(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<IRecipeInput, RecipeOutput> entry : this.getRecipeList().entrySet()) {
                this.arecipes.add(new CachedIORecipe(entry.getKey(), entry.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        block0: for (Map.Entry<IRecipeInput, RecipeOutput> entry : this.getRecipeList().entrySet()) {
            for (ItemStack output : entry.getValue().items) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)output, (ItemStack)result)) continue;
                this.arecipes.add(new CachedIORecipe(entry.getKey(), entry.getValue()));
                continue block0;
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Map.Entry<IRecipeInput, RecipeOutput> entry : this.getRecipeList().entrySet()) {
            if (!entry.getKey().matches(ingredient)) continue;
            this.arecipes.add(new CachedIORecipe(entry.getKey(), entry.getValue()));
        }
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCentrifuge.class;
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"ic2.blockCentrifuge");
    }

    public String getRecipeId() {
        return "ic2.blockCentrifuge";
    }

    public String getGuiTexture() {
        return "ic2:textures/gui/GUITermalCentrifuge.png";
    }

    public String getOverlayIdentifier() {
        return "centrifuge";
    }

    public Map<IRecipeInput, RecipeOutput> getRecipeList() {
        return Recipes.centrifuge.getRecipes();
    }

    public class CachedIORecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public List<PositionedStack> ingredients;
        public PositionedStack output;
        public List<PositionedStack> otherStacks;

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(CentrifugeRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.otherStacks;
        }

        public CachedIORecipe(ItemStack input, ItemStack aOutput) {
            super((TemplateRecipeHandler)CentrifugeRecipeHandler.this);
            this.ingredients = new ArrayList<PositionedStack>();
            this.otherStacks = new ArrayList<PositionedStack>();
            this.ingredients.add(new PositionedStack((Object)input, 12, 7));
            this.output = new PositionedStack((Object)aOutput, 125, 22);
        }

        public CachedIORecipe(IRecipeInput input, RecipeOutput output1) {
            super((TemplateRecipeHandler)CentrifugeRecipeHandler.this);
            this.ingredients = new ArrayList<PositionedStack>();
            this.otherStacks = new ArrayList<PositionedStack>();
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (ItemStack item : input.getInputs()) {
                items.add(StackUtil.copyWithSize(item, input.getAmount()));
            }
            this.ingredients.add(new PositionedStack(items, 12, 7));
            this.output = new PositionedStack((Object)output1.items.get(0), 125, 4);
            for (int i = 1; i < output1.items.size(); ++i) {
                this.otherStacks.add(new PositionedStack((Object)output1.items.get(i), 125, 4 + i * 18));
            }
        }
    }
}

