/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class PriorityExecutor
extends ThreadPoolExecutor {
    public PriorityExecutor(int threadCount) {
        super(threadCount, threadCount, 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(11));
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        int priority = callable instanceof CustomPriority ? ((CustomPriority)((Object)callable)).getPriority() : 0;
        return new PriorityTask<T>(callable, priority);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        int priority = runnable instanceof CustomPriority ? ((CustomPriority)((Object)runnable)).getPriority() : 0;
        return new PriorityTask<T>(runnable, value, priority);
    }

    public static interface CustomPriority {
        public int getPriority();
    }

    static class PriorityTask<V>
    extends FutureTask<V>
    implements Comparable<PriorityTask<V>> {
        private final int priority;

        public PriorityTask(Callable<V> callable, int priority1) {
            super(callable);
            this.priority = priority1;
        }

        public PriorityTask(Runnable runnable, V result, int priority1) {
            super(runnable, result);
            this.priority = priority1;
        }

        @Override
        public int compareTo(PriorityTask<V> o) {
            return o.priority - this.priority;
        }
    }
}

