/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util;

import cpw.mods.fml.common.registry.GameRegistry;
import ic2.core.util.ItemStackWrapper;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.IChunkProvider;
import org.apache.commons.lang3.mutable.MutableInt;

public class DropScan {
    private final int[] flatDrops = new int[Item.field_77698_e.length];
    private final Map<ItemStackWrapper, MutableInt> drops = new HashMap<ItemStackWrapper, MutableInt>();
    private final PrintStream rawOut = new PrintStream(new FileOutputStream(FileDescriptor.out));
    private static final Object generatorLock = new Object();
    private static final Object decoratorLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Iterable<Map.Entry<ItemStack, Integer>> scanArea(World originalWorld, int xStart, int zStart, int range) {
        IChunkProvider generator;
        DummyWorld world = new DummyWorld(originalWorld);
        ((DummyChunkProvider)world.func_72863_F()).generator = generator = world.field_73011_w.func_76555_c();
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        ArrayList<Chunk> pendingChunks = new ArrayList<Chunk>();
        this.rawOut.println("process " + xStart + " " + zStart);
        Object object = generatorLock;
        synchronized (object) {
            for (int x = xStart; x < xStart + range; ++x) {
                for (int i = zStart; i < zStart + range; ++i) {
                    Chunk chunk = generator.func_73154_d(x, i);
                    chunks.add(chunk);
                    if (x == xStart || x == xStart + range || i == zStart || i == zStart + range) continue;
                    pendingChunks.add(chunk);
                }
            }
        }
        ((DummyChunkProvider)world.func_72863_F()).setChunks(chunks);
        object = decoratorLock;
        synchronized (object) {
            for (Chunk chunk : pendingChunks) {
                chunk.func_76624_a(world.func_72863_F(), world.func_72863_F(), chunk.field_76635_g, chunk.field_76647_h);
            }
        }
        for (Chunk chunk : pendingChunks) {
            this.scanChunk(world, chunk);
        }
        for (int i = 0; i < this.flatDrops.length; ++i) {
            void var11_19;
            if (this.flatDrops[i] == 0) continue;
            ItemStackWrapper key = new ItemStackWrapper(new ItemStack(i, 1, 0));
            MutableInt mutableInt = this.drops.get(key);
            if (mutableInt == null) {
                MutableInt mutableInt2 = new MutableInt();
                this.drops.put(key, mutableInt2);
            }
            var11_19.add(this.flatDrops[i]);
        }
        TreeSet<Map.Entry<ItemStack, Integer>> counts = new TreeSet<Map.Entry<ItemStack, Integer>>(new Comparator<Map.Entry<ItemStack, Integer>>(){

            @Override
            public int compare(Map.Entry<ItemStack, Integer> a, Map.Entry<ItemStack, Integer> b) {
                return b.getValue() - a.getValue();
            }
        });
        for (Map.Entry entry : this.drops.entrySet()) {
            counts.add(new AbstractMap.SimpleImmutableEntry<ItemStack, Integer>(((ItemStackWrapper)entry.getKey()).stack, ((MutableInt)entry.getValue()).getValue()));
        }
        return counts;
    }

    private void scanChunk(World world, Chunk chunk) {
        int yMax = world.func_72800_K();
        for (int y = 0; y < yMax; ++y) {
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    int blockId = chunk.func_76610_a(x, y, z);
                    if (blockId == 0) continue;
                    Block block = Block.field_71973_m[blockId];
                    int meta = chunk.func_76628_c(x, y, z);
                    ArrayList drop = block.getBlockDropped(world, x + chunk.field_76635_g * 16, y, z + chunk.field_76647_h * 16, meta, 0);
                    for (ItemStack stack : drop) {
                        if (stack.func_77960_j() == 0 && !stack.func_77942_o()) {
                            int n = stack.field_77993_c;
                            this.flatDrops[n] = this.flatDrops[n] + stack.field_77994_a;
                            continue;
                        }
                        ItemStackWrapper key = new ItemStackWrapper(stack);
                        MutableInt amount = this.drops.get(key);
                        if (amount == null) {
                            amount = new MutableInt();
                            this.drops.put(key, amount);
                        }
                        amount.add(stack.field_77994_a);
                    }
                }
            }
        }
    }

    static class DummyChunkProvider
    implements IChunkProvider {
        private final World world;
        private Chunk lastChunk;
        private final Map<Long, Chunk> chunkMap = new HashMap<Long, Chunk>();
        private final Chunk emptyChunk;
        public IChunkProvider generator;

        public DummyChunkProvider(World world1) {
            this.world = world1;
            this.emptyChunk = new EmptyChunk(world1, 0, 0);
        }

        public void setChunks(List<Chunk> chunks) {
            for (Chunk chunk : chunks) {
                this.chunkMap.put(ChunkCoordIntPair.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h), chunk);
            }
        }

        public boolean func_73157_c() {
            return false;
        }

        public boolean func_73149_a(int x, int z) {
            return this.chunkMap.containsKey(ChunkCoordIntPair.func_77272_a((int)x, (int)z));
        }

        public ChunkPosition func_73150_a(World world1, String s, int i, int j, int k) {
            return null;
        }

        public int func_73152_e() {
            return 1;
        }

        public List func_73155_a(EnumCreatureType enumcreaturetype, int i, int j, int k) {
            return null;
        }

        public Chunk func_73158_c(int i, int j) {
            return null;
        }

        public String func_73148_d() {
            return "Dummy";
        }

        public void func_73153_a(IChunkProvider provider, int x, int z) {
            Chunk chunk = this.func_73154_d(x, z);
            if (!chunk.field_76646_k) {
                chunk.field_76646_k = true;
                if (this.generator != null) {
                    this.generator.func_73153_a(provider, x, z);
                    GameRegistry.generateWorld((int)x, (int)z, (World)this.world, (IChunkProvider)this.generator, (IChunkProvider)provider);
                    chunk.func_76630_e();
                }
            }
        }

        public Chunk func_73154_d(int x, int z) {
            if (this.lastChunk != null && this.lastChunk.field_76635_g == x && this.lastChunk.field_76647_h == z) {
                return this.lastChunk;
            }
            Chunk ret = this.chunkMap.get(ChunkCoordIntPair.func_77272_a((int)x, (int)z));
            if (ret == null) {
                return this.emptyChunk;
            }
            this.lastChunk = ret;
            return ret;
        }

        public void func_82695_e(int i, int j) {
        }

        public boolean func_73151_a(boolean flag, IProgressUpdate iprogressupdate) {
            return true;
        }

        public void func_104112_b() {
        }

        public boolean func_73156_b() {
            return false;
        }
    }

    static class DummyWorld
    extends World {
        public DummyWorld(World world) {
            super(world.func_72860_G(), "DummyWorld", new WorldSettings(world.func_72912_H()), WorldProvider.func_76570_a((int)world.field_73011_w.field_76574_g), world.field_72984_F, world.func_98180_V());
            this.field_73020_y = new DummyChunkProvider(this);
        }

        protected IChunkProvider func_72970_h() {
            return null;
        }

        public Entity func_73045_a(int i) {
            return null;
        }

        public boolean func_72832_d(int x, int y, int z, int id, int meta, int flags) {
            if (y >= 256 || y < 0) {
                return false;
            }
            Chunk chunk = this.func_72964_e(x >> 4, z >> 4);
            return chunk.func_76592_a(x & 0xF, y, z & 0xF, id, meta);
        }

        public boolean func_72921_c(int x, int y, int z, int meta, int flags) {
            if (y >= 256 || y < 0) {
                return false;
            }
            Chunk chunk = this.func_72964_e(x >> 4, z >> 4);
            return chunk.func_76589_b(x & 0xF, y, z & 0xF, meta);
        }

        public void func_72936_c(EnumSkyBlock par1EnumSkyBlock, int par2, int par3, int par4) {
        }
    }
}

