/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class Config {
    private final Config parent;
    private final String name;
    private String comment;
    private boolean saveWithParent = true;
    private final Map<String, Config> sections = new LinkedHashMap<String, Config>();
    private final Map<String, Value> values = new LinkedHashMap<String, Value>();
    private static final String lineSeparator = System.getProperty("line.separator");

    public Config(String name) {
        this(null, name, "");
    }

    private Config(Config parent, String name, String comment) {
        this.parent = parent;
        this.name = name;
        this.comment = comment;
        if (parent != null) {
            parent.sections.put(name, this);
        }
    }

    public Config getRoot() {
        Config ret = this;
        while (ret.parent != null) {
            ret = ret.parent;
        }
        return ret;
    }

    public Config getSub(String key) {
        List<String> parts = this.split(key, '/');
        return this.getSub(parts, parts.size(), false);
    }

    public Config addSub(String key, String comment) {
        Config config = this.parent.sections.get(key);
        if (config == null) {
            config = new Config(this, key, comment);
        } else {
            config.comment = comment;
        }
        return config;
    }

    public Value get(String key) {
        List<String> parts = this.split(key, '/');
        Config config = this.getSub(parts, parts.size() - 1, false);
        if (config == null) {
            return null;
        }
        return config.values.get(parts.get(parts.size() - 1));
    }

    public String getString(String key) {
        return this.get(key).getString();
    }

    public int getInt(String key) {
        return this.get(key).getInt();
    }

    public float getFloat(String key) {
        return this.get(key).getFloat();
    }

    public double getDouble(String key) {
        return this.get(key).getDouble();
    }

    public void set(String key, Value value) {
        List<String> parts = this.split(key, '/');
        assert (parts.get(parts.size() - 1).equals(value.name));
        Config config = this.getSub(parts, parts.size() - 1, true);
        config.values.put(parts.get(parts.size() - 1), value);
    }

    public <T> void set(String key, T value) {
        List<String> parts = this.split(key, '/');
        Config config = this.getSub(parts, parts.size() - 1, true);
        String name = parts.get(parts.size() - 1);
        Value existingValue = config.values.get(name);
        if (existingValue == null) {
            existingValue = new Value(name, "", null);
            config.values.put(name, existingValue);
        }
        existingValue.set(value);
    }

    public void clear() {
        this.sections.clear();
        this.values.clear();
    }

    public Iterator<Config> sectionIterator() {
        return this.sections.values().iterator();
    }

    public Iterator<Value> valueIterator() {
        return this.values.values().iterator();
    }

    public void setSaveWithParent(boolean saveWithParent) {
        this.saveWithParent = saveWithParent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream is) throws IOException, ParseException {
        Config root;
        InputStreamReader isReader;
        try {
            isReader = new InputStreamReader(is, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        LineNumberReader reader = new LineNumberReader(isReader);
        Config config = root = this;
        StringBuilder comment = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                if (line.startsWith(";") || line.startsWith("#")) {
                    if ((line = line.substring(1).trim()).equals(";---")) {
                        comment = new StringBuilder();
                        continue;
                    }
                    if (comment.length() != 0) {
                        comment.append(lineSeparator);
                    }
                    comment.append(line.substring(1).trim());
                    continue;
                }
                if (line.startsWith("[")) {
                    if (!line.endsWith("]")) {
                        throw new ParseException("section without closing bracket", reader.getLineNumber(), line);
                    }
                    String section = line.substring(1, line.length() - 1);
                    List<String> keys = this.split(section, '/', ',');
                    ListIterator<String> it = keys.listIterator();
                    while (it.hasNext()) {
                        it.set(this.unescapeSection(it.next()));
                    }
                    if (comment.length() > 0) {
                        config = root.getSub(keys, keys.size() - 1, true);
                        config = config.addSub(keys.get(keys.size() - 1), comment.toString());
                        comment = new StringBuilder();
                        continue;
                    }
                    config = root.getSub(keys, keys.size(), true);
                    continue;
                }
                List<String> parts = this.split(line, ':', '=');
                if (parts.size() != 2) {
                    throw new ParseException("invalid key-value pair", reader.getLineNumber(), line);
                }
                String key = this.unescapeValue(parts.get(0).trim());
                if (key.isEmpty()) {
                    throw new ParseException("empty key", reader.getLineNumber(), line);
                }
                String valueStr = this.unescapeValue(parts.get(1).trim());
                if (valueStr.startsWith("\"")) {
                    if (!valueStr.endsWith("\"")) {
                        throw new ParseException("unfinished quoted string", reader.getLineNumber(), line);
                    }
                    valueStr = valueStr.substring(1, valueStr.length() - 1);
                }
                config.set(key, new Value(key, comment.toString(), valueStr));
                if (comment.length() <= 0) continue;
                comment = new StringBuilder();
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws ParseException, IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            this.load(is);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(OutputStream os) throws IOException {
        OutputStreamWriter osWriter;
        try {
            osWriter = new OutputStreamWriter(os, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        BufferedWriter writer = new BufferedWriter(osWriter);
        try {
            Config config;
            writer.write("; ");
            writer.write(this.name);
            writer.newLine();
            writer.write("; created ");
            writer.write(DateFormat.getDateTimeInstance().format(new Date()));
            writer.newLine();
            writer.write(";---");
            writer.newLine();
            Config root = this;
            ArrayDeque<Config> todo = new ArrayDeque<Config>();
            todo.add(this);
            while ((config = (Config)todo.poll()) != null) {
                if (!config.values.isEmpty()) {
                    writer.newLine();
                    if (config != root) {
                        if (!config.comment.isEmpty()) {
                            writer.write("; ");
                            writer.write(config.comment);
                            writer.newLine();
                        }
                        writer.write(91);
                        ArrayList<String> keys = new ArrayList<String>();
                        Config cSection = config;
                        do {
                            keys.add(cSection.name);
                        } while ((cSection = cSection.parent) != root);
                        for (int i = keys.size() - 1; i >= 0; --i) {
                            writer.write(this.escapeSection((String)keys.get(i)));
                            if (i <= 0) continue;
                            writer.write(" / ");
                        }
                        writer.write(93);
                        writer.newLine();
                    }
                    for (Value value : config.values.values()) {
                        if (!value.comment.isEmpty()) {
                            for (String line : value.comment.split("\n")) {
                                writer.write("; ");
                                writer.write(line);
                                writer.newLine();
                            }
                        }
                        writer.write(this.escapeValue(value.name));
                        writer.write(" = ");
                        writer.write(this.escapeValue(value.value));
                        writer.newLine();
                    }
                }
                for (Config section : this.sections.values()) {
                    if (!section.saveWithParent) continue;
                    todo.add(section);
                }
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            this.save(os);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private Config getSub(List<String> keys, int end, boolean create) {
        Config ret = this;
        for (int i = 0; i < end; ++i) {
            String key = keys.get(i);
            assert (key.length() > 0);
            Config config = ret.sections.get(key);
            if (config == null) {
                if (create) {
                    config = new Config(ret, key, "");
                } else {
                    return null;
                }
            }
            ret = config;
        }
        return ret;
    }

    private List<String> split(String str, char ... chars) {
        String dummy = str.replaceAll("\\\\.", "xx");
        ArrayList<String> ret = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean quoted = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = dummy.charAt(i);
            if (c == '\"') {
                quoted = !quoted;
            }
            boolean split = false;
            if (!quoted) {
                for (char c2 : chars) {
                    if (c != c2) continue;
                    split = true;
                }
            }
            if (split) {
                ret.add(current.toString());
                current = new StringBuilder();
                continue;
            }
            current.append(str.charAt(i));
        }
        ret.add(current.toString());
        return ret;
    }

    private String escapeSection(String str) {
        return str.replaceAll("([\\[\\];#/,])", "\\$1").replaceAll("\n", "\\n");
    }

    private String unescapeSection(String str) {
        return str.replaceAll("\\\\([\\[\\];#/,])", "$1").replaceAll("\\n", "\n");
    }

    private String escapeValue(String str) {
        return str.replaceAll("([\\[\\];#=])", "\\$1").replaceAll("\n", "\\n");
    }

    private String unescapeValue(String str) {
        return str.replaceAll("\\\\([\\[\\];#=])", "$1").replaceAll("\\n", "\n");
    }

    public static class ParseException
    extends RuntimeException {
        private static final long serialVersionUID = 8721912755972301225L;

        ParseException(String msg, int line, String content) {
            super(msg + " at line " + line + " (" + content + ")");
        }
    }

    public static class Value {
        public final String name;
        public String comment;
        public String value;

        public Value(String name, String comment, String value) {
            this.name = name;
            this.comment = comment;
            this.value = value;
        }

        public String getString() {
            return this.value;
        }

        public int getInt() {
            return Integer.valueOf(this.value);
        }

        public float getFloat() {
            return Float.valueOf(this.value).floatValue();
        }

        public double getDouble() {
            return Double.valueOf(this.value);
        }

        public <T> void set(T value) {
            this.value = String.valueOf(value);
        }
    }
}

