/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.liquids;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidDictionary;

@Deprecated
public class LiquidStack {
    public final int itemID;
    public int amount;
    public final int itemMeta;
    public by extra;
    private String textureSheet = "/terrain.png";
    @SideOnly(value=Side.CLIENT)
    private ms renderingIcon;

    public LiquidStack(int itemID, int amount) {
        this(itemID, amount, 0);
    }

    public LiquidStack(yc item, int amount) {
        this(item.cv, amount, 0);
    }

    public LiquidStack(aqz block, int amount) {
        this(block.cF, amount, 0);
    }

    public LiquidStack(int itemID, int amount, int itemDamage) {
        this.itemID = itemID;
        this.amount = amount;
        this.itemMeta = itemDamage;
    }

    public LiquidStack(int itemID, int amount, int itemDamage, by nbt) {
        this(itemID, amount, itemDamage);
        if (nbt != null) {
            this.extra = (by)nbt.b();
        }
    }

    public by writeToNBT(by nbt) {
        nbt.a("Amount", this.amount);
        nbt.a("Id", (short)this.itemID);
        nbt.a("Meta", (short)this.itemMeta);
        String name = LiquidDictionary.findLiquidName(this);
        if (name != null) {
            nbt.a("LiquidName", name);
        }
        if (this.extra != null) {
            nbt.a("extra", (cl)this.extra);
        }
        return nbt;
    }

    public LiquidStack copy() {
        return new LiquidStack(this.itemID, this.amount, this.itemMeta, this.extra);
    }

    public boolean isLiquidEqual(LiquidStack other) {
        return other != null && this.itemID == other.itemID && this.itemMeta == other.itemMeta && (this.extra == null ? other.extra == null : this.extra.equals((Object)other.extra));
    }

    public boolean containsLiquid(LiquidStack other) {
        return this.isLiquidEqual(other) && this.amount >= other.amount;
    }

    public boolean isLiquidEqual(ye other) {
        if (other == null) {
            return false;
        }
        if (this.itemID == other.d && this.itemMeta == other.k()) {
            return true;
        }
        return this.isLiquidEqual(LiquidContainerRegistry.getLiquidForFilledItem(other));
    }

    public ye asItemStack() {
        ye stack = new ye(this.itemID, 1, this.itemMeta);
        if (this.extra != null) {
            stack.e = (by)this.extra.b();
        }
        return stack;
    }

    public static LiquidStack loadLiquidStackFromNBT(by nbt) {
        if (nbt == null) {
            return null;
        }
        String liquidName = nbt.i("LiquidName");
        int itemID = nbt.d("Id");
        int itemMeta = nbt.d("Meta");
        LiquidStack liquid = LiquidDictionary.getCanonicalLiquid(liquidName);
        if (liquid != null) {
            itemID = liquid.itemID;
            itemMeta = liquid.itemMeta;
        } else if (yc.g[itemID] == null) {
            return null;
        }
        int amount = nbt.e("Amount");
        LiquidStack liquidstack = new LiquidStack(itemID, amount, itemMeta);
        if (nbt.b("extra")) {
            liquidstack.extra = nbt.l("extra");
        }
        return liquidstack.itemID == 0 ? null : liquidstack;
    }

    public String getTextureSheet() {
        return this.textureSheet;
    }

    public LiquidStack setTextureSheet(String textureSheet) {
        this.textureSheet = textureSheet;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public ms getRenderingIcon() {
        if (this.itemID == aqz.G.cF) {
            return apc.b((String)"water");
        }
        if (this.itemID == aqz.I.cF) {
            return apc.b((String)"lava");
        }
        return this.renderingIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public LiquidStack setRenderingIcon(ms icon) {
        this.renderingIcon = icon;
        return this;
    }

    public final int hashCode() {
        return 31 * this.itemMeta + this.itemID;
    }

    public final boolean equals(Object ob) {
        if (ob instanceof LiquidStack) {
            LiquidStack ls = (LiquidStack)ob;
            return ls.itemID == this.itemID && ls.itemMeta == this.itemMeta && (this.extra == null ? ls.extra == null : this.extra.equals((Object)ls.extra));
        }
        return false;
    }

    public LiquidStack canonical() {
        return LiquidDictionary.getCanonicalLiquid(this);
    }
}

