/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.render;

import codechicken.lib.lighting.LightModel;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import cofh.block.BlockCoFHBase;
import cofh.render.IconRegistry;
import cofh.render.RenderHelper;
import cofh.render.RenderUtils;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import thermalexpansion.block.conduit.BlockConduit;
import thermalexpansion.block.conduit.TileConduitBase;
import thermalexpansion.core.TEProps;
import thermalexpansion.fluid.TEFluids;
import thermalexpansion.item.TEItems;
import thermalexpansion.part.conduit.ConduitBase;
import thermalexpansion.part.conduit.item.TravelingItem;

public class RenderConduit
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    public static final RenderConduit instance = new RenderConduit();
    public static final int ITEMS_TO_RENDER_PER_CONDUIT = 16;
    static RenderItem travelingItemRender;
    static EntityItem travelingEntityItem;
    static float travelingItemSpin;
    static final float ITEM_RENDER_SCALE = 0.6f;
    static final int[] INV_CONNECTIONS;
    static int[] connections;
    static Icon[] textureConduit;
    static Icon[] textureConnection;
    static Icon textureSolidRedstone;
    static Icon textureFluidRedstone;
    static Icon textureFluidGlowstone;
    static CCModel[][] modelFluid;
    static CCModel[][] modelConnection;
    static CCModel modelCenter;

    public static void initialize() {
        RenderConduit.textureConduit[BlockConduit.RenderTypes.ENERGY_BASIC.ordinal()] = IconRegistry.getIcon((String)"ConduitEnergy00");
        RenderConduit.textureConduit[BlockConduit.RenderTypes.ENERGY_HARDENED.ordinal()] = IconRegistry.getIcon((String)"ConduitEnergy10");
        RenderConduit.textureConduit[BlockConduit.RenderTypes.ENERGY_REINFORCED.ordinal()] = IconRegistry.getIcon((String)"ConduitEnergy20");
        RenderConduit.textureConduit[BlockConduit.RenderTypes.FLUID_TRANS.ordinal()] = IconRegistry.getIcon((String)"ConduitFluid00");
        RenderConduit.textureConduit[BlockConduit.RenderTypes.FLUID_OPAQUE.ordinal()] = IconRegistry.getIcon((String)"ConduitFluid10");
        RenderConduit.textureConduit[BlockConduit.RenderTypes.ITEM_TRANS.ordinal()] = IconRegistry.getIcon((String)"ConduitItem00");
        RenderConduit.textureConduit[BlockConduit.RenderTypes.ITEM_OPAQUE.ordinal()] = IconRegistry.getIcon((String)"ConduitItem10");
        RenderConduit.textureConduit[BlockConduit.RenderTypes.ITEM_FAST_TRANS.ordinal()] = IconRegistry.getIcon((String)"ConduitItem20");
        RenderConduit.textureConduit[BlockConduit.RenderTypes.ITEM_FAST_OPAQUE.ordinal()] = IconRegistry.getIcon((String)"ConduitItem30");
        RenderConduit.textureConduit[BlockConduit.RenderTypes.ITEM_TRANS_SHORT.ordinal()] = IconRegistry.getIcon((String)"ConduitItem01");
        RenderConduit.textureConduit[BlockConduit.RenderTypes.ITEM_TRANS_LONG.ordinal()] = IconRegistry.getIcon((String)"ConduitItem02");
        RenderConduit.textureConduit[BlockConduit.RenderTypes.ITEM_TRANS_ROUNDROBIN.ordinal()] = IconRegistry.getIcon((String)"ConduitItem03");
        RenderConduit.textureConduit[BlockConduit.RenderTypes.ITEM_OPAQUE_SHORT.ordinal()] = IconRegistry.getIcon((String)"ConduitItem11");
        RenderConduit.textureConduit[BlockConduit.RenderTypes.ITEM_OPAQUE_LONG.ordinal()] = IconRegistry.getIcon((String)"ConduitItem12");
        RenderConduit.textureConduit[BlockConduit.RenderTypes.ITEM_OPAQUE_ROUNDROBIN.ordinal()] = IconRegistry.getIcon((String)"ConduitItem13");
        RenderConduit.textureConduit[BlockConduit.RenderTypes.ITEM_FAST_TRANS_SHORT.ordinal()] = IconRegistry.getIcon((String)"ConduitItem21");
        RenderConduit.textureConduit[BlockConduit.RenderTypes.ITEM_FAST_TRANS_LONG.ordinal()] = IconRegistry.getIcon((String)"ConduitItem22");
        RenderConduit.textureConduit[BlockConduit.RenderTypes.ITEM_FAST_TRANS_ROUNDROBIN.ordinal()] = IconRegistry.getIcon((String)"ConduitItem23");
        RenderConduit.textureConduit[BlockConduit.RenderTypes.ITEM_FAST_OPAQUE_SHORT.ordinal()] = IconRegistry.getIcon((String)"ConduitItem31");
        RenderConduit.textureConduit[BlockConduit.RenderTypes.ITEM_FAST_OPAQUE_LONG.ordinal()] = IconRegistry.getIcon((String)"ConduitItem32");
        RenderConduit.textureConduit[BlockConduit.RenderTypes.ITEM_FAST_OPAQUE_ROUNDROBIN.ordinal()] = IconRegistry.getIcon((String)"ConduitItem33");
        RenderConduit.textureConnection[BlockConduit.ConnectionTypes.ENERGY_BASIC.ordinal()] = IconRegistry.getIcon((String)"Connection2");
        RenderConduit.textureConnection[BlockConduit.ConnectionTypes.ENERGY_BASIC_BLOCKED.ordinal()] = IconRegistry.getIcon((String)"Connection2");
        RenderConduit.textureConnection[BlockConduit.ConnectionTypes.ENERGY_HARDENED.ordinal()] = IconRegistry.getIcon((String)"Connection4");
        RenderConduit.textureConnection[BlockConduit.ConnectionTypes.ENERGY_HARDENED_BLOCKED.ordinal()] = IconRegistry.getIcon((String)"Connection4");
        RenderConduit.textureConnection[BlockConduit.ConnectionTypes.ENERGY_REINFORCED.ordinal()] = IconRegistry.getIcon((String)"Connection6");
        RenderConduit.textureConnection[BlockConduit.ConnectionTypes.ENERGY_REINFORCED_BLOCKED.ordinal()] = IconRegistry.getIcon((String)"Connection6");
        RenderConduit.textureConnection[BlockConduit.ConnectionTypes.FLUID_NORMAL.ordinal()] = IconRegistry.getIcon((String)"Connection8");
        RenderConduit.textureConnection[BlockConduit.ConnectionTypes.FLUID_BLOCKED.ordinal()] = IconRegistry.getIcon((String)"Connection8");
        RenderConduit.textureConnection[BlockConduit.ConnectionTypes.FLUID_INPUT_ON.ordinal()] = IconRegistry.getIcon((String)"Connection10");
        RenderConduit.textureConnection[BlockConduit.ConnectionTypes.FLUID_INPUT_OFF.ordinal()] = IconRegistry.getIcon((String)"Connection10");
        RenderConduit.textureConnection[BlockConduit.ConnectionTypes.ITEM_NORMAL.ordinal()] = IconRegistry.getIcon((String)"Connection12");
        RenderConduit.textureConnection[BlockConduit.ConnectionTypes.ITEM_BLOCKED.ordinal()] = IconRegistry.getIcon((String)"Connection12");
        RenderConduit.textureConnection[BlockConduit.ConnectionTypes.ITEM_INPUT_ON.ordinal()] = IconRegistry.getIcon((String)"Connection14");
        RenderConduit.textureConnection[BlockConduit.ConnectionTypes.ITEM_INPUT_OFF.ordinal()] = IconRegistry.getIcon((String)"Connection14");
        RenderConduit.textureConnection[BlockConduit.ConnectionTypes.ITEM_STUFFED_ON.ordinal()] = IconRegistry.getIcon((String)"Connection16");
        RenderConduit.textureConnection[BlockConduit.ConnectionTypes.ITEM_STUFFED_OFF.ordinal()] = IconRegistry.getIcon((String)"Connection16");
        textureSolidRedstone = IconRegistry.getIcon((String)"StorageRedstone");
        textureFluidRedstone = TEFluids.fluidRedstone.getIcon();
        textureFluidGlowstone = TEFluids.fluidGlowstone.getIcon();
    }

    private static void generateFluidModels() {
        for (int i = 1; i < 7; ++i) {
            double d1 = 0.47 - 0.025 * (double)i;
            double d2 = 0.53 + 0.025 * (double)i;
            double d3 = 0.32 + 0.06 * (double)i;
            double c1 = 0.32;
            double c2 = 0.68;
            double[][] boxes = new double[][]{{d1, 0.0, d1, d2, c1, d2}, {d1, d3, d1, d2, 1.0, d2}, {c1, c1, 0.0, c2, d3, c1}, {c1, c1, c2, c2, d3, 1.0}, {0.0, c1, c1, c1, d3, c2}, {c2, c1, c1, 1.0, d3, c2}, {c1, c1, c1, c2, d3, c2}};
            for (int s = 0; s < 7; ++s) {
                RenderConduit.modelFluid[i - 1][s] = CCModel.quadModel((int)24).generateBlock(0, boxes[s][0], boxes[s][1], boxes[s][2], boxes[s][3], boxes[s][4], boxes[s][5]).computeNormals();
            }
        }
    }

    private static void generateModels() {
        modelCenter = CCModel.quadModel((int)48).generateBox(0, -3.0, -3.0, -3.0, 6.0, 6.0, 6.0, 0.0, 0.0, 32.0, 32.0, 16.0);
        RenderConduit.modelConnection[0][1] = CCModel.quadModel((int)48).generateBox(0, -3.0, 3.0, -3.0, 6.0, 5.0, 6.0, 0.0, 16.0, 32.0, 32.0, 16.0);
        RenderConduit.modelConnection[1][1] = CCModel.quadModel((int)24).generateBox(0, -4.0, 4.0, -4.0, 8.0, 4.0, 8.0, 0.0, 0.0, 32.0, 32.0, 16.0).computeNormals();
        RenderConduit.modelConnection[2][1] = CCModel.quadModel((int)24).generateBox(0, -4.0, 4.0, -4.0, 8.0, 4.0, 8.0, 0.0, 16.0, 32.0, 32.0, 16.0).computeNormals();
        CCModel.generateBackface((CCModel)modelCenter, (int)0, (CCModel)modelCenter, (int)24, (int)24);
        CCModel.generateBackface((CCModel)modelConnection[0][1], (int)0, (CCModel)modelConnection[0][1], (int)24, (int)24);
        modelCenter.computeNormals().computeLighting(LightModel.standardLightModel);
        modelConnection[0][1].computeNormals();
        for (int i = 0; i < modelConnection.length; ++i) {
            CCModel.generateSidedModels((CCModel[])modelConnection[i], (int)1, (Vector3)Vector3.zero);
        }
        Scale[] mirrors = new Scale[]{new Scale(1.0, -1.0, 1.0), new Scale(1.0, 1.0, -1.0), new Scale(-1.0, 1.0, 1.0)};
        for (int i = 0; i < modelConnection.length; ++i) {
            int s;
            CCModel[] sideModels = modelConnection[i];
            for (s = 2; s < 6; s += 2) {
                sideModels[s] = sideModels[0].sidedCopy(0, s, Vector3.zero);
            }
            for (s = 1; s < 6; s += 2) {
                sideModels[s] = sideModels[s - 1].backfacedCopy().apply((Transformation)mirrors[s / 2]);
            }
        }
    }

    public void renderFrame(boolean invRender, int renderType, int[] connection, double x, double y, double z) {
        Translation trans = RenderUtils.getRenderVector((double)(x += 0.5), (double)(y += 0.5), (double)(z += 0.5)).translation();
        for (int s = 0; s < 6; ++s) {
            if (BlockConduit.ConnectionTypes.values()[connection[s]].renderConduit()) {
                if (!invRender) {
                    modelConnection[0][s].render(0, 4, (Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureConduit[renderType]), null);
                    modelConnection[0][s].render(8, 16, (Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureConduit[renderType]), null);
                    modelConnection[0][s].render(24, 4, (Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureConduit[renderType]), null);
                    modelConnection[0][s].render(32, 16, (Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureConduit[renderType]), null);
                } else {
                    modelConnection[0][s].render((Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureConduit[renderType]));
                }
                if (connection[s] == BlockConduit.ConnectionTypes.CONDUIT.ordinal()) continue;
                if (connection[s] % 2 == 0) {
                    modelConnection[1][s].render((Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureConnection[connection[s]]));
                    continue;
                }
                modelConnection[2][s].render((Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureConnection[connection[s]]));
                continue;
            }
            modelCenter.render(s * 4, 4, (Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureConduit[renderType]), null);
            modelCenter.render(24 + s * 4, 4, (Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureConduit[renderType]), null);
        }
    }

    public void renderWorldExtra(TileConduitBase tile, int renderType, int[] connection, double x, double y, double z) {
        Icon texture = null;
        if (renderType != BlockConduit.RenderTypes.ENERGY_BASIC.ordinal() && renderType != BlockConduit.RenderTypes.ENERGY_HARDENED.ordinal()) {
            if (renderType == BlockConduit.RenderTypes.FLUID_TRANS.ordinal() && tile != null) {
                CCRenderState.draw();
                this.renderFluid(tile.getRenderFluid(), connections, tile.getRenderFluidLevel(), x, y, z);
                CCRenderState.startDrawing((int)7);
                return;
            }
            int opacity = 192;
            if (renderType == BlockConduit.RenderTypes.ENERGY_REINFORCED.ordinal()) {
                texture = textureFluidRedstone;
            } else if (renderType == BlockConduit.RenderTypes.ITEM_FAST_TRANS.ordinal() || renderType == BlockConduit.RenderTypes.ITEM_FAST_TRANS_SHORT.ordinal() || renderType == BlockConduit.RenderTypes.ITEM_FAST_TRANS_LONG.ordinal() || renderType == BlockConduit.RenderTypes.ITEM_FAST_TRANS_ROUNDROBIN.ordinal()) {
                texture = textureFluidGlowstone;
                opacity = 128;
            } else {
                return;
            }
            CCRenderState.draw();
            GL11.glBlendFunc((int)770, (int)771);
            CCRenderState.startDrawing((int)7);
            CCRenderState.setColour((int)(-224 + opacity));
            CCModel[] models = modelFluid[5];
            for (int s = 0; s < 6; ++s) {
                if (!BlockConduit.ConnectionTypes.values()[connection[s]].renderConduit()) continue;
                models[s].render(x, y, z, (IUVTransformation)RenderUtils.getIconTransformation((Icon)texture));
            }
            models[6].render(x, y, z, (IUVTransformation)RenderUtils.getIconTransformation((Icon)texture));
            CCRenderState.draw();
            CCRenderState.startDrawing((int)7);
            return;
        }
        texture = textureSolidRedstone;
        if (texture != null) {
            for (int s = 0; s < 6; ++s) {
                if (!BlockConduit.ConnectionTypes.values()[connection[s]].renderConduit()) continue;
                modelFluid[5][s].render(x, y, z, (IUVTransformation)RenderUtils.getIconTransformation((Icon)texture));
            }
            modelFluid[5][6].render(x, y, z, (IUVTransformation)RenderUtils.getIconTransformation((Icon)texture));
        }
    }

    public void renderWorldExtraPart(ConduitBase tile, int renderType, int[] connection, double x, double y, double z) {
        Icon texture = null;
        if (renderType != BlockConduit.RenderTypes.ENERGY_BASIC.ordinal() && renderType != BlockConduit.RenderTypes.ENERGY_HARDENED.ordinal()) {
            if (renderType == BlockConduit.RenderTypes.FLUID_TRANS.ordinal() && tile != null) {
                CCRenderState.draw();
                this.renderFluid(tile.getConduitFluid().getRenderFluid(), connections, tile.getConduitFluid().getRenderFluidLevel(), x, y, z);
                CCRenderState.startDrawing((int)7);
                return;
            }
            int opacity = 192;
            if (renderType == BlockConduit.RenderTypes.ENERGY_REINFORCED.ordinal()) {
                texture = textureFluidRedstone;
            } else if (renderType == BlockConduit.RenderTypes.ITEM_FAST_TRANS.ordinal() || renderType == BlockConduit.RenderTypes.ITEM_FAST_TRANS_SHORT.ordinal() || renderType == BlockConduit.RenderTypes.ITEM_FAST_TRANS_LONG.ordinal() || renderType == BlockConduit.RenderTypes.ITEM_FAST_TRANS_ROUNDROBIN.ordinal()) {
                texture = textureFluidGlowstone;
                opacity = 128;
            } else {
                return;
            }
            CCRenderState.draw();
            GL11.glBlendFunc((int)770, (int)771);
            CCRenderState.startDrawing((int)7);
            CCRenderState.setColour((int)(-224 + opacity));
            CCModel[] models = modelFluid[5];
            for (int s = 0; s < 6; ++s) {
                if (!BlockConduit.ConnectionTypes.values()[connection[s]].renderConduit()) continue;
                models[s].render(x, y, z, (IUVTransformation)RenderUtils.getIconTransformation((Icon)texture));
            }
            models[6].render(x, y, z, (IUVTransformation)RenderUtils.getIconTransformation((Icon)texture));
            CCRenderState.draw();
            CCRenderState.startDrawing((int)7);
            return;
        }
        texture = textureSolidRedstone;
        if (texture != null) {
            for (int s = 0; s < 6; ++s) {
                if (!BlockConduit.ConnectionTypes.values()[connection[s]].renderConduit()) continue;
                modelFluid[5][s].render(x, y, z, (IUVTransformation)RenderUtils.getIconTransformation((Icon)texture));
            }
            modelFluid[5][6].render(x, y, z, (IUVTransformation)RenderUtils.getIconTransformation((Icon)texture));
        }
    }

    public void renderFluid(FluidStack stack, int[] connection, int level, double x, double y, double z) {
        if (stack == null || stack.amount <= 0 || level <= 0 || stack.fluidID <= 0) {
            return;
        }
        GL11.glBlendFunc((int)770, (int)771);
        CCRenderState.startDrawing((int)7);
        Fluid fluid = stack.getFluid();
        RenderUtils.setFluidRenderColor((FluidStack)stack);
        RenderHelper.bindTexture((ResourceLocation)RenderHelper.MC_BLOCK_SHEET);
        Icon fluidTex = RenderHelper.getFluidTexture((FluidStack)stack);
        if (fluid.isGaseous(stack)) {
            CCRenderState.setColour((int)(RenderUtils.getFluidRenderColor((FluidStack)stack) << 8 | 32 + 36 * level));
            level = 6;
        }
        CCModel[] models = modelFluid[level - 1];
        for (int s = 0; s < 6; ++s) {
            if (!BlockConduit.ConnectionTypes.values()[connection[s]].renderConduit()) continue;
            models[s].render(x, y, z, (IUVTransformation)RenderUtils.getIconTransformation((Icon)fluidTex));
        }
        models[6].render(x, y, z, (IUVTransformation)RenderUtils.getIconTransformation((Icon)fluidTex));
        CCRenderState.draw();
    }

    public void renderTravelingItems(List<TravelingItem> items, World world, double x, double y, double z, float frame) {
        if (items == null || items.size() <= 0) {
            return;
        }
        GL11.glPushMatrix();
        travelingItemSpin = (float)((double)travelingItemSpin + 0.001);
        RenderConduit.travelingEntityItem.field_70290_d = travelingItemSpin %= 180.0f;
        for (int i = 0; i < items.size() && i < 16; ++i) {
            TravelingItem renderItem = items.get(i);
            if (renderItem == null || renderItem.stack == null) continue;
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + (double)renderItem.x), (double)(y + (double)renderItem.y), (double)(z + (double)renderItem.z));
            GL11.glScalef((float)0.6f, (float)0.6f, (float)0.6f);
            travelingEntityItem.func_92058_a(renderItem.stack);
            travelingItemRender.func_77014_a(travelingEntityItem, 0.0, (double)-0.1f, 0.0, 0.0f, 0.0f);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    public void getConduitConnections(TileConduitBase tile) {
        for (int i = 0; i < 6; ++i) {
            RenderConduit.connections[i] = tile.getConnectionType(i);
        }
    }

    public void getConduitConnections(ConduitBase tile) {
        for (int i = 0; i < 6; ++i) {
            RenderConduit.connections[i] = tile.getConnectionType(i);
        }
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        RenderUtils.preRender();
        CCRenderState.startDrawing((int)7);
        this.renderFrame(true, metadata, INV_CONNECTIONS, -0.5, -0.5, -0.5);
        CCRenderState.draw();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        CCRenderState.startDrawing((int)7);
        this.renderWorldExtra(null, metadata, INV_CONNECTIONS, -0.5, -0.5009765625, -0.5);
        CCRenderState.draw();
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        CCRenderState.useNormals((boolean)false);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (!(tile instanceof TileConduitBase)) {
            return false;
        }
        TileConduitBase theTile = (TileConduitBase)tile;
        RenderUtils.beforeWorldRender((IBlockAccess)world, (int)x, (int)y, (int)z);
        this.getConduitConnections(theTile);
        if (BlockCoFHBase.renderPass == 0) {
            this.renderFrame(false, theTile.getRenderType(), connections, x, y, z);
        } else {
            this.renderWorldExtra(theTile, theTile.getRenderType(), connections, x, y, z);
        }
        RenderUtils.afterWorldRender((IBlockAccess)world, (int)x, (int)y, (int)z);
        return true;
    }

    public boolean renderPart(ConduitBase thePart, int pass) {
        RenderUtils.beforeWorldRender((IBlockAccess)thePart.world(), (int)thePart.x(), (int)thePart.y(), (int)thePart.z());
        this.getConduitConnections(thePart);
        if (pass == 0) {
            this.renderFrame(false, thePart.getRenderType(), connections, thePart.x(), thePart.y(), thePart.z());
        } else {
            this.renderWorldExtraPart(thePart, thePart.getRenderType(), connections, thePart.x(), thePart.y(), thePart.z());
        }
        return true;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return TEProps.renderIdConduit;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        int metadata = 2;
        boolean renderExtra = false;
        if (item.field_77993_c == TEItems.itemConduits.field_77779_bT) {
            renderExtra = true;
            metadata = item.func_77960_j();
            if (metadata >= 4096) {
                metadata -= 4091;
            } else if (metadata >= 2048) {
                metadata -= 2045;
            }
        }
        GL11.glPushMatrix();
        double offset = -0.5;
        if (type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            offset = 0.0;
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        }
        RenderHelper.setBlockTextureSheet();
        RenderUtils.preRender();
        CCRenderState.startDrawing((int)7);
        instance.renderFrame(true, metadata, INV_CONNECTIONS, offset, offset, offset);
        CCRenderState.draw();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (renderExtra) {
            CCRenderState.startDrawing((int)7);
            this.renderWorldExtraPart(null, metadata, INV_CONNECTIONS, offset, offset - 9.765625E-4, offset);
            CCRenderState.draw();
        }
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        CCRenderState.useNormals((boolean)false);
        RenderHelper.setItemTextureSheet();
        GL11.glPopMatrix();
    }

    public Icon getFrameTexture(ConduitBase conduit) {
        return textureConduit[conduit.getRenderType()];
    }

    static {
        travelingEntityItem = new EntityItem(null);
        travelingItemSpin = 0.25f;
        INV_CONNECTIONS = new int[]{BlockConduit.ConnectionTypes.CONDUIT.ordinal(), BlockConduit.ConnectionTypes.CONDUIT.ordinal(), 0, 0, 0, 0};
        connections = new int[6];
        textureConduit = new Icon[BlockConduit.RenderTypes.values().length];
        textureConnection = new Icon[BlockConduit.ConnectionTypes.values().length];
        modelFluid = new CCModel[6][7];
        modelConnection = new CCModel[3][6];
        TEProps.renderIdConduit = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)instance);
        RenderConduit.generateFluidModels();
        RenderConduit.generateModels();
        travelingItemRender = new RenderItem(){

            public boolean shouldBob() {
                return false;
            }

            public boolean shouldSpreadItems() {
                return false;
            }
        };
        travelingItemRender.func_76976_a(RenderManager.field_78727_a);
        RenderConduit.travelingEntityItem.field_70290_d = 0.0f;
    }
}

