/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.part.conduit.item;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Vector3;
import cofh.api.transport.IItemConduit;
import cofh.network.PacketUtils;
import cofh.network.Payload;
import cofh.render.RenderUtils;
import cofh.util.BlockHelper;
import cofh.util.CoreUtils;
import cofh.util.ItemHelper;
import cofh.util.MathHelper;
import cofh.util.ServerHelper;
import cofh.util.StringHelper;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.conduit.BlockConduit;
import thermalexpansion.item.TEItems;
import thermalexpansion.part.conduit.ConduitBase;
import thermalexpansion.part.conduit.Grid;
import thermalexpansion.part.conduit.GridTickHandler;
import thermalexpansion.part.conduit.IConduit;
import thermalexpansion.part.conduit.item.GridItem;
import thermalexpansion.part.conduit.item.ItemRoute;
import thermalexpansion.part.conduit.item.TravelingItem;
import thermalexpansion.render.RenderConduit;
import thermalexpansion.util.Utils;

public class ConduitItem
extends ConduitBase
implements IItemConduit {
    protected static int[] guiIds;
    ISidedInventory[] cacheImportant = new ISidedInventory[6];
    IInventory[] cacheImportant2 = new IInventory[6];
    public GridItem myGrid;
    public int returnedLength = 1;
    public boolean wasVisited = false;
    public boolean wasOutput = false;
    public boolean routesInvalid = true;
    public LinkedList<ItemRoute> validOutputs = new LinkedList();
    public LinkedList<ItemRoute> validStuffable = new LinkedList();
    public List<TravelingItem> myItems = new LinkedList<TravelingItem>();
    public List<TravelingItem> itemsToRemove = new LinkedList<TravelingItem>();
    public List<TravelingItem> itemsToAdd = new LinkedList<TravelingItem>();
    public boolean hasChanged = false;
    boolean stuffed = false;
    LinkedList<ItemStack> stuffedItems = new LinkedList();
    int routeCounter = 0;
    public ItemStack[][] myFilters = new ItemStack[6][9];
    public boolean[] isWhitelist = new boolean[]{false, false, false, false, false, false};
    public boolean[] useMeta = new boolean[]{true, true, true, true, true, true};
    public boolean[] useOreDict = new boolean[]{true, true, true, true, true, true};
    public boolean[] useNBT = new boolean[]{false, false, false, false, false, false};
    public byte[] moveStackSize = new byte[]{64, 64, 64, 64, 64, 64};
    public static final routeInfo noRoute;
    public static final String[] modeStrings;
    static int[] sideTypes;
    static int[] modeTypes;
    static int[] modeTypesPowered;
    static int[][] itemTypes;
    static int[] _INPUT_TICK;
    static int[] _PIPE_LEN;
    static int[] _PIPE_HALF_LEN;
    static float[] _PIPE_TICK_LEN;
    static float[][][] _SIDE_MODS;
    static boolean[] _RENDERS_ITEMS;

    public static void initialize() {
        guiIds = new int[]{ThermalExpansion.proxy.registerGui("ItemFilter", "conduit", true), ThermalExpansion.proxy.registerGui("ItemFilter1", "conduit", true), ThermalExpansion.proxy.registerGui("ItemFilter2", "conduit", true), ThermalExpansion.proxy.registerGui("ItemFilter3", "conduit", true), ThermalExpansion.proxy.registerGui("ItemFilter4", "conduit", true), ThermalExpansion.proxy.registerGui("ItemFilter5", "conduit", true)};
    }

    public ConduitItem(byte type) {
        super(type);
    }

    @Override
    public void setGrid(Grid newGrid) {
        super.setGrid(newGrid);
        this.myGrid = (GridItem)newGrid;
    }

    @Override
    public void doOutput() {
        this.tickItems();
        if (this.stuffed) {
            if (this.world() != null && this.world().func_82737_E() % (long)this.getInputTick() == 0L) {
                this.popStuffedItems();
                if (!this.stuffed && this.isInput && this.isNode && this.redstoneControlOrDisable()) {
                    this.inputItems();
                }
            }
        } else if (this.isInput && this.isNode && this.redstoneControlOrDisable() && this.world() != null && this.world().func_82737_E() % (long)this.getInputTick() == 0L) {
            this.inputItems();
        }
    }

    public void inputItems() {
        block0: for (int i = 0; i < 6; ++i) {
            int sentAmount;
            ItemStack currentItem;
            ISidedInventory theInv;
            if (this.sideType[i] != 2 || this.sideMode[i] != 2) continue;
            if (this.cacheType[i] == ConduitBase.CacheTypes.IMPORTANT) {
                theInv = this.getImportantProper(i);
                if (theInv == null) continue;
                int[] sides = theInv.func_94128_d(i ^ 1);
                for (int a = 0; a < sides.length; ++a) {
                    currentItem = theInv.func_70301_a(sides[a]) != null ? theInv.func_70301_a(sides[a]).func_77946_l() : null;
                    if (currentItem == null || !theInv.func_102008_b(sides[a], currentItem, i ^ 1) || !this.itemPassesFiltering(i, currentItem) || (sentAmount = this.routeItem(currentItem.func_77946_l(), i)) >= currentItem.field_77994_a) continue;
                    currentItem.field_77994_a = sentAmount;
                    if (currentItem.field_77994_a <= 0) {
                        currentItem = null;
                        theInv.func_70299_a(sides[a], currentItem);
                        continue block0;
                    }
                    theInv.func_70299_a(sides[a], currentItem);
                    continue block0;
                }
                continue;
            }
            if (this.cacheType[i] != ConduitBase.CacheTypes.IMPORTANT2 || (theInv = this.getImportant(i)) == null) continue;
            for (int a = 0; a < theInv.func_70302_i_(); ++a) {
                currentItem = theInv.func_70301_a(a) != null ? theInv.func_70301_a(a).func_77946_l() : null;
                if (currentItem == null || !this.itemPassesFiltering(i, currentItem) || (sentAmount = this.routeItem(currentItem.func_77946_l(), i)) >= currentItem.field_77994_a) continue;
                currentItem.field_77994_a = sentAmount;
                if (currentItem.field_77994_a <= 0) {
                    currentItem = null;
                    theInv.func_70299_a(a, currentItem);
                    continue block0;
                }
                theInv.func_70299_a(a, currentItem);
                continue block0;
            }
        }
    }

    public ItemStack insertItem(ForgeDirection from, ItemStack item) {
        if (this.myGrid == null) {
            return item;
        }
        if (this.stuffed || this.sideMode[from.ordinal()] != 2 || item == null || !this.itemPassesFiltering(from.ordinal(), item)) {
            return item;
        }
        int sentAmount = this.routeItem(item.func_77946_l(), from.ordinal());
        if (sentAmount < item.field_77994_a) {
            item.field_77994_a = sentAmount;
            if (item.field_77994_a <= 0) {
                item = null;
            }
        }
        return item;
    }

    public void tickItems() {
        if (this.itemsToAdd.size() > 0) {
            this.myItems.addAll(this.itemsToAdd);
            this.itemsToAdd.clear();
        }
        if (this.myItems.size() > 0) {
            for (TravelingItem item : this.myItems) {
                item.tickForward(this);
            }
            if (this.itemsToRemove.size() > 0) {
                this.myItems.removeAll(this.itemsToRemove);
                this.itemsToRemove.clear();
                this.hasChanged = true;
            }
        }
        if (this.hasChanged) {
            this.sendTravelingItemsPacket();
            this.hasChanged = false;
        }
    }

    public void tickItemsClient() {
        if (this.itemsToAdd.size() > 0) {
            this.myItems.clear();
            this.myItems.addAll(this.itemsToAdd);
            this.itemsToAdd.clear();
        }
        if (this.myItems.size() > 0) {
            for (int i = 0; i < this.myItems.size(); ++i) {
                this.myItems.get(i).tickClientForward(this);
            }
            if (this.itemsToRemove.size() > 0) {
                this.myItems.removeAll(this.itemsToRemove);
                this.itemsToRemove.clear();
            }
        } else {
            GridTickHandler.ItemClientTickHandler.tickConduitToRemove.add(this);
        }
    }

    public void insertItem(TravelingItem travelingItem) {
        if (this.world() == null || ServerHelper.isClientWorld((World)this.world())) {
            return;
        }
        this.itemsToAdd.add(travelingItem);
        this.hasChanged = true;
    }

    @Override
    public void updateInternalTypes() {
        int i;
        this.isNode = false;
        this.isOutput = false;
        this.isInput = false;
        for (i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            if (this.sideType[i] != 2) continue;
            if (this.sideMode[i] == 1) {
                this.isOutput = true;
            } else if (this.sideMode[i] == 2) {
                this.isInput = true;
            }
            this.isNode = true;
        }
        if (!this.isInput && this.stuffed) {
            for (i = 0; i < this.stuffedItems.size() && i < 64; ++i) {
                CoreUtils.dropItemStackIntoWorldWithVelocity((ItemStack)this.stuffedItems.get(i), (World)this.world(), (double)this.x(), (double)this.y(), (double)this.z());
            }
            this.stuffed = false;
            this.stuffedItems.clear();
        }
    }

    @Override
    public void load(NBTTagCompound nbt) {
        NBTTagCompound compound;
        int i;
        super.load(nbt);
        NBTTagList list = nbt.func_74761_m("TravelingItems");
        for (i = 0; i < list.func_74745_c(); ++i) {
            this.myItems.add(new TravelingItem((NBTTagCompound)list.func_74743_b(i)));
        }
        list = nbt.func_74761_m("StuffedItems");
        this.stuffedItems.clear();
        for (i = 0; i < list.func_74745_c(); ++i) {
            compound = (NBTTagCompound)list.func_74743_b(i);
            this.stuffed = true;
            this.stuffedItems.add(ItemStack.func_77949_a((NBTTagCompound)compound));
        }
        if (this.hasServo) {
            list = nbt.func_74761_m("FilterItems");
            if (list.func_74745_c() > 0) {
                this.myFilters = new ItemStack[6][9];
                for (i = 0; i < list.func_74745_c(); ++i) {
                    compound = (NBTTagCompound)list.func_74743_b(i);
                    this.myFilters[compound.func_74762_e((String)"Side")][compound.func_74762_e((String)"Slot")] = ItemStack.func_77949_a((NBTTagCompound)compound);
                }
            }
            int filterMask = nbt.func_74762_e("FilterMask");
            for (int i2 = 0; i2 < 6; i2 = (int)((byte)(i2 + 1))) {
                this.isWhitelist[i2] = MathHelper.isBitSet((int)filterMask, (int)(i2 * 5));
                this.useMeta[i2] = MathHelper.isBitSet((int)filterMask, (int)(i2 * 5 + 1));
                this.useOreDict[i2] = MathHelper.isBitSet((int)filterMask, (int)(i2 * 5 + 2));
                this.useNBT[i2] = MathHelper.isBitSet((int)filterMask, (int)(i2 * 5 + 3));
                this.moveStackSize[i2] = nbt.func_74771_c("mSS" + i2);
            }
            if (this.moveStackSize[0] == 0) {
                this.moveStackSize = new byte[]{64, 64, 64, 64, 64, 64};
            }
        }
        this.updateInternalTypes();
        this.returnedLength = 1;
        if (this.internal_mode == 1) {
            this.returnedLength = 1000;
        } else if (this.internal_mode == 2) {
            this.returnedLength = -1000;
        }
        this.routeCounter = nbt.func_74762_e("RouteCounter");
        this.hasChanged = true;
    }

    @Override
    public void save(NBTTagCompound nbt) {
        NBTTagCompound compound;
        int i;
        super.save(nbt);
        NBTTagList list = new NBTTagList();
        if (this.itemsToAdd.size() > 0) {
            this.myItems.addAll(this.itemsToAdd);
            this.itemsToAdd.clear();
        }
        for (i = 0; i < this.myItems.size(); ++i) {
            if (this.myItems.get(i) == null) continue;
            compound = new NBTTagCompound();
            this.myItems.get(i).toNBT(compound);
            list.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a("TravelingItems", (NBTBase)list);
        list = new NBTTagList();
        for (i = 0; i < this.stuffedItems.size(); ++i) {
            if (this.stuffedItems.get(i) == null) continue;
            compound = new NBTTagCompound();
            this.stuffedItems.get(i).func_77955_b(compound);
            list.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a("StuffedItems", (NBTBase)list);
        nbt.func_74768_a("RouteCounter", this.routeCounter);
        if (this.hasServo) {
            list = new NBTTagList();
            if (this.myFilters != null) {
                for (i = 0; i < this.myFilters.length; ++i) {
                    for (int a = 0; a < this.myFilters[i].length; ++a) {
                        if (this.myFilters[i][a] == null) continue;
                        NBTTagCompound compound2 = new NBTTagCompound();
                        compound2.func_74768_a("Side", i);
                        compound2.func_74768_a("Slot", a);
                        this.myFilters[i][a].func_77955_b(compound2);
                        list.func_74742_a((NBTBase)compound2);
                        nbt.func_74782_a("FilterItems", (NBTBase)list);
                    }
                }
            }
            int filterMask = 0;
            for (int i2 = 0; i2 < 6; ++i2) {
                filterMask = MathHelper.setBit((int)filterMask, (int)(i2 * 5), (boolean)this.isWhitelist[i2]);
                filterMask = MathHelper.setBit((int)filterMask, (int)(i2 * 5 + 1), (boolean)this.useMeta[i2]);
                filterMask = MathHelper.setBit((int)filterMask, (int)(i2 * 5 + 2), (boolean)this.useOreDict[i2]);
                filterMask = MathHelper.setBit((int)filterMask, (int)(i2 * 5 + 3), (boolean)this.useNBT[i2]);
                nbt.func_74774_a("mSS" + i2, this.moveStackSize[i2]);
            }
            nbt.func_74768_a("FilterMask", filterMask);
        }
    }

    public int getLength() {
        return this.returnedLength;
    }

    public void stuffItem(TravelingItem travelingItem) {
        if (!this.stuffed) {
            this.stuffed = true;
            this.sendStuffedPacket();
        }
        this.stuffedItems.add(travelingItem.stack);
    }

    public routeInfo canRouteItem(ItemStack anItem, boolean isSelf, int maxTransferSize) {
        int stackSizeLeft;
        ItemStack curItem;
        int[] coords;
        byte i;
        if (this.stuffed && !isSelf) {
            return noRoute;
        }
        for (i = this.sideTracker; i < ForgeDirection.VALID_DIRECTIONS.length; i = (byte)(i + 1)) {
            if (this.sideType[i] != 2 || this.sideMode[i] != 1 || !this.itemPassesFiltering(i, anItem)) continue;
            coords = BlockHelper.getAdjacentCoordinatesForSide((int)this.x(), (int)this.y(), (int)this.z(), (int)i);
            curItem = anItem.func_77946_l();
            curItem.field_77994_a = Math.min(Math.min(maxTransferSize, this.moveStackSize[i]), curItem.field_77994_a);
            stackSizeLeft = Utils.canAddToInventory(coords[0], coords[1], coords[2], this.world(), i, curItem.func_77946_l());
            if ((stackSizeLeft = anItem.field_77994_a - curItem.field_77994_a + stackSizeLeft) >= anItem.field_77994_a) continue;
            this.increaseTracker();
            return new routeInfo(stackSizeLeft, i);
        }
        for (i = 0; i < this.sideTracker; i = (byte)(i + 1)) {
            if (this.sideType[i] != 2 || this.sideMode[i] != 1 || !this.itemPassesFiltering(i, anItem)) continue;
            coords = BlockHelper.getAdjacentCoordinatesForSide((int)this.x(), (int)this.y(), (int)this.z(), (int)i);
            curItem = anItem.func_77946_l();
            curItem.field_77994_a = Math.min(Math.min(maxTransferSize, this.moveStackSize[i]), curItem.field_77994_a);
            stackSizeLeft = Utils.canAddToInventory(coords[0], coords[1], coords[2], this.world(), i, anItem.func_77946_l());
            if ((stackSizeLeft = anItem.field_77994_a - curItem.field_77994_a + stackSizeLeft) >= anItem.field_77994_a) continue;
            this.increaseTracker();
            return new routeInfo(stackSizeLeft, i);
        }
        return noRoute;
    }

    public byte getStuffedSide() {
        for (byte i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; i = (byte)((byte)(i + 1))) {
            if (this.sideType[i] != 2 || this.sideMode[i] != 2) continue;
            return i;
        }
        return 0;
    }

    public void popStuffedItems() {
        ItemStack currentItem = this.stuffedItems.getFirst();
        if (currentItem == null) {
            this.stuffedItems.remove(0);
            if (this.stuffedItems.isEmpty()) {
                this.stuffed = false;
                this.sendStuffedPacket();
            }
            return;
        }
        int stackSizeLeft = this.routeItem(currentItem.func_77946_l(), this.getStuffedSide());
        if (stackSizeLeft < currentItem.field_77994_a) {
            currentItem.field_77994_a = stackSizeLeft;
            if (currentItem.field_77994_a <= 0) {
                this.stuffedItems.remove(0);
                if (this.stuffedItems.isEmpty()) {
                    this.stuffed = false;
                    this.sendStuffedPacket();
                }
            }
        }
    }

    public int routeItem(ItemStack theItem, int inventorySide) {
        int result;
        this.cacheRoutes();
        routeInfo curInfo = null;
        if (this.internal_mode == 3) {
            int i;
            for (i = this.routeCounter; i < this.validOutputs.size(); ++i) {
                result = this.doRouteItem(this.validOutputs.get(i), curInfo, theItem, inventorySide);
                if (result == -1) continue;
                this.tickCounter();
                return result;
            }
            for (i = 0; i < this.routeCounter; ++i) {
                result = this.doRouteItem(this.validOutputs.get(i), curInfo, theItem, inventorySide);
                if (result == -1) continue;
                this.tickCounter();
                return result;
            }
        }
        for (ItemRoute aRoute : this.validOutputs) {
            result = this.doRouteItem(aRoute, curInfo, theItem, inventorySide);
            if (result == -1) continue;
            return result;
        }
        return theItem.field_77994_a;
    }

    public int doRouteItem(ItemRoute aRoute, routeInfo curInfo, ItemStack theItem, int inventorySide) {
        if (aRoute.endPoint.isNode) {
            curInfo = aRoute.endPoint.canRouteItem(theItem, aRoute.pathLength == 0, this.moveStackSize[inventorySide]);
            if (curInfo.canRoute) {
                theItem = theItem.func_77946_l();
                theItem.field_77994_a -= curInfo.stackSize;
                ItemRoute itemRoute = aRoute.copy();
                itemRoute.pathDirections.add(curInfo.side);
                this.insertItem(new TravelingItem(theItem, this.x(), this.y(), this.z(), itemRoute, inventorySide ^ 1));
                return curInfo.stackSize;
            }
        }
        return -1;
    }

    public void cacheRoutes() {
        if (this.routesInvalid) {
            this.routeCounter = 0;
            this.routesInvalid = false;
            LinkedList<ItemRoute> validRoutes = new LinkedList<ItemRoute>();
            validRoutes.add(new ItemRoute(this));
            this.validOutputs = new LinkedList();
            this.validStuffable = new LinkedList();
            boolean continueLoop = true;
            while (continueLoop) {
                LinkedList<ItemRoute> newRoutes = new LinkedList<ItemRoute>();
                continueLoop = false;
                for (ItemRoute curRoute : validRoutes) {
                    curRoute.moveForwards(newRoutes, this.validOutputs, this.validStuffable);
                    if (curRoute.routeFinished) continue;
                    continueLoop = true;
                }
                validRoutes.addAll(newRoutes);
            }
            this.myGrid.setUnvisited();
            if (this.isOutput) {
                ItemRoute singleOutput = new ItemRoute(this);
                this.wasVisited = false;
                singleOutput.routeFinished = true;
                this.validOutputs.add(singleOutput);
            }
            Collections.sort(this.validOutputs);
        }
    }

    public void tickCounter() {
        ++this.routeCounter;
        this.routeCounter %= this.validOutputs.size();
    }

    @Override
    public void setUnvisited() {
        this.wasVisited = false;
        this.wasOutput = false;
    }

    @Override
    public void setRouteInvalid() {
        this.routesInvalid = true;
    }

    public boolean canStuffItem() {
        return this.isInput && this.isNode;
    }

    @Override
    public int getRenderType() {
        return itemTypes[this.conduitType][this.internal_mode];
    }

    @Override
    public int getConnectionType(int side) {
        return this.sideType[side] == 2 ? (this.stuffed && this.sideMode[side] == 2 ? (this.redstoneControlOrDisable() ? BlockConduit.ConnectionTypes.ITEM_STUFFED_ON.ordinal() : BlockConduit.ConnectionTypes.ITEM_STUFFED_OFF.ordinal()) : (this.redstoneControlOrDisable() ? modeTypesPowered[this.sideMode[side]] : modeTypes[this.sideMode[side]])) : sideTypes[this.sideType[side]];
    }

    public int getInputTick() {
        return _INPUT_TICK[this.conduitType];
    }

    public int getPipeLength() {
        return _PIPE_LEN[this.conduitType];
    }

    public int getPipeHalfLength() {
        return _PIPE_HALF_LEN[this.conduitType];
    }

    public float[][] getSideCoordsModifier() {
        return _SIDE_MODS[this.conduitType];
    }

    @Override
    public boolean punchSide(EntityPlayer player, int subHit) {
        if (CoreUtils.isFakePlayer((EntityPlayer)player)) {
            return false;
        }
        if (!this.hasServo) {
            return false;
        }
        if (this.sideMode[subHit] == 2 || this.sideMode[subHit] == 1) {
            player.openGui((Object)ThermalExpansion.instance, guiIds[subHit], this.world(), this.x(), this.y(), this.z());
            return true;
        }
        return false;
    }

    public boolean itemPassesFiltering(int side, ItemStack theItem) {
        if (theItem == null) {
            return false;
        }
        if (this.myFilters == null || !this.hasServo) {
            return true;
        }
        for (int i = 0; i < this.myFilters[side].length; ++i) {
            if (this.myFilters[side][i] == null) continue;
            if (this.useMeta[side] && ItemHelper.itemsEqualWithMetadata((ItemStack)theItem, (ItemStack)this.myFilters[side][i], (boolean)this.useNBT[side])) {
                return this.isWhitelist[side];
            }
            if (this.useOreDict[side] && ItemHelper.doOreIDsMatch((ItemStack)theItem, (ItemStack)this.myFilters[side][i])) {
                return this.isWhitelist[side];
            }
            if (this.useMeta[side] || !ItemHelper.itemsEqualWithoutMetadata((ItemStack)theItem, (ItemStack)this.myFilters[side][i], (boolean)this.useNBT[side])) continue;
            return this.isWhitelist[side];
        }
        return !this.isWhitelist[side];
    }

    public void updateFilters() {
        for (int i = 0; i < this.myFilters.length; ++i) {
            for (int a = 0; a < this.myFilters[i].length; ++a) {
                if (this.myFilters[i][a] == null) continue;
                return;
            }
        }
        this.myFilters = null;
    }

    @Override
    public void handleTileInfoPacket(Payload payload, NetHandler handler) {
        byte type = payload.getByte();
        if (type == 0) {
            byte side = payload.getByte();
            this.isWhitelist[side] = payload.getBool();
            this.useMeta[side] = payload.getBool();
            this.useOreDict[side] = payload.getBool();
            this.useNBT[side] = payload.getBool();
            this.moveStackSize[side] = payload.getByte();
        } else if (type == 1) {
            this.stuffed = payload.getBool();
            this.world().func_72902_n(this.x(), this.y(), this.z());
        } else if (type == 2) {
            this.itemsToAdd.clear();
            int loopStop = payload.getByte();
            for (int i = 0; i < loopStop; ++i) {
                this.itemsToAdd.add(TravelingItem.fromPacket(payload, this));
            }
            if (!GridTickHandler.ItemClientTickHandler.tickConduit.contains(this) && !GridTickHandler.ItemClientTickHandler.tickConduitToAdd.contains(this)) {
                GridTickHandler.ItemClientTickHandler.tickConduitToAdd.add(this);
            }
        } else if (type == 3) {
            this.stuffedItems.clear();
            int loopStop = payload.getByte();
            for (int i = 0; i < loopStop; ++i) {
                this.stuffedItems.add(payload.getItemStack());
            }
        } else if (type == 4) {
            this.sendStuffedItemsPacket(handler.getPlayer());
        }
    }

    public void sendStuffedPacket() {
        Payload myPayload = Payload.getInfoPayload((TileEntity)this.tile());
        myPayload.addByte((byte)1);
        myPayload.addBool(this.stuffed);
        PacketUtils.sendToPlayers((Packet)myPayload.getPacket(), (TileEntity)this.tile());
    }

    public void sendStuffedItemsPacket(EntityPlayer thePlayer) {
        Payload myPayload = Payload.getInfoPayload((TileEntity)this.tile());
        myPayload.addByte((byte)3);
        int loopStop = this.stuffedItems.size();
        loopStop = Math.min(loopStop, 6);
        myPayload.addByte(loopStop);
        for (int i = 0; i < loopStop; ++i) {
            myPayload.addItemStack(this.stuffedItems.get(i));
        }
        PacketUtils.sendToPlayer((Packet)myPayload.getPacket(), (EntityPlayer)thePlayer);
    }

    public void sendStuffedItemsRequest() {
        Payload myPayload = Payload.getInfoPayload((TileEntity)this.tile());
        myPayload.addByte((byte)4);
        PacketUtils.sendToServer((Packet)myPayload.getPacket());
    }

    public void sendTravelingItemsPacket() {
        if (_RENDERS_ITEMS[this.conduitType]) {
            Payload myPayload = Payload.getInfoPayload((TileEntity)this.tile());
            myPayload.addByte((byte)2);
            int loopStop = this.myItems.size();
            loopStop = Math.min(loopStop, 6);
            myPayload.addByte(loopStop);
            for (int i = 0; i < loopStop; ++i) {
                this.myItems.get(i).writePacket(myPayload);
            }
            PacketUtils.sendToPlayers((Packet)myPayload.getPacket(), (TileEntity)this.tile());
        }
    }

    @Override
    public boolean isItemConduit() {
        return true;
    }

    @Override
    public ConduitItem getConduitItem() {
        return this;
    }

    @Override
    public boolean isImportant(TileEntity curTile, int side) {
        return curTile instanceof IInventory;
    }

    @Override
    public boolean isConduit(TileEntity curTile) {
        return curTile instanceof IConduit && ((IConduit)curTile).isItemConduit();
    }

    @Override
    public void cacheImportant(TileEntity theTile, int side) {
        if (theTile instanceof ISidedInventory) {
            this.cacheImportant[side] = (ISidedInventory)theTile;
            this.cacheType[side] = ConduitBase.CacheTypes.IMPORTANT;
        } else {
            this.cacheImportant2[side] = (IInventory)theTile;
            this.cacheType[side] = ConduitBase.CacheTypes.IMPORTANT2;
        }
    }

    public IInventory getImportant(int side) {
        if (this.cacheType[side] == ConduitBase.CacheTypes.IMPORTANT) {
            return this.cacheImportant[side];
        }
        if (this.cacheType[side] == ConduitBase.CacheTypes.IMPORTANT2) {
            return this.cacheImportant2[side];
        }
        return null;
    }

    public ISidedInventory getImportantProper(int side) {
        if (this.cacheType[side] == ConduitBase.CacheTypes.IMPORTANT) {
            return this.cacheImportant[side];
        }
        return null;
    }

    @Override
    public Grid createNewGrid() {
        return new GridItem(this);
    }

    @Override
    public void sideChanged(byte[] oldType, int side, int oldMode) {
        if (this.myGrid != null && side != -1 && (oldMode == 2 || this.sideType[side] == 2)) {
            this.myGrid.setRoutesInvalid();
        }
        super.sideChanged(oldType, side, oldMode);
    }

    @Override
    public int getStuffedSize() {
        return this.stuffedItems.size();
    }

    @Override
    public void writeDesc(MCDataOutput payload) {
        int i;
        super.writeDesc(payload);
        for (i = 0; i < this.isWhitelist.length; ++i) {
            payload.writeBoolean(this.isWhitelist[i]);
        }
        for (i = 0; i < this.useMeta.length; ++i) {
            payload.writeBoolean(this.useMeta[i]);
        }
        for (i = 0; i < this.useOreDict.length; ++i) {
            payload.writeBoolean(this.useOreDict[i]);
        }
        for (i = 0; i < this.useNBT.length; ++i) {
            payload.writeBoolean(this.useNBT[i]);
        }
        for (i = 0; i < this.moveStackSize.length; ++i) {
            payload.writeByte((int)this.moveStackSize[i]);
        }
        payload.writeBoolean(this.stuffed);
    }

    @Override
    public void readDesc(MCDataInput payload) {
        int i;
        super.readDesc(payload);
        for (i = 0; i < this.isWhitelist.length; ++i) {
            this.isWhitelist[i] = payload.readBoolean();
        }
        for (i = 0; i < this.useMeta.length; ++i) {
            this.useMeta[i] = payload.readBoolean();
        }
        for (i = 0; i < this.useOreDict.length; ++i) {
            this.useOreDict[i] = payload.readBoolean();
        }
        for (i = 0; i < this.useNBT.length; ++i) {
            this.useNBT[i] = payload.readBoolean();
        }
        for (i = 0; i < this.moveStackSize.length; ++i) {
            this.moveStackSize[i] = payload.readByte();
        }
        this.stuffed = payload.readBoolean();
    }

    @Override
    public boolean wrenchMiddle(EntityPlayer player, int hitSide) {
        this.returnedLength = 1;
        this.internal_mode = (byte)(this.internal_mode + 1);
        this.internal_mode = (byte)(this.internal_mode % 4);
        if (this.internal_mode == 1) {
            this.returnedLength = 1000;
        } else if (this.internal_mode == 2) {
            this.returnedLength = -1000;
        } else if (this.internal_mode == 3 && !this.isInput) {
            this.wrenchMiddle(player, hitSide);
            return true;
        }
        this.updateInternalTypes();
        this.onNeighborChangedRS();
        this.sendDescUpdate();
        this.myGrid.setRoutesInvalid();
        return true;
    }

    @Override
    public void wrenchSide(EntityPlayer player, int subHit) {
        if (this.sideType[subHit] == 2) {
            int n = subHit;
            byte by = (byte)(this.sideMode[n] + 1);
            this.sideMode[n] = by;
            this.sideMode[subHit] = (byte)(by % 3);
            this.updateInternalTypes();
            this.onNeighborChangedRS();
            this.sendDescUpdate();
            this.myGrid.setRoutesInvalid();
        }
    }

    @Override
    public ItemStack pickItem(MovingObjectPosition hit) {
        return new ItemStack((Item)TEItems.itemConduits, 1, this.conduitType + 4096);
    }

    @Override
    public Iterable<ItemStack> getDrops() {
        LinkedList<ItemStack> myList = new LinkedList<ItemStack>();
        if (this.hasServo) {
            myList.add(TEItems.pneumaticServo.func_77946_l());
        }
        for (TravelingItem curItem : this.myItems) {
            myList.add(curItem.stack);
        }
        myList.addAll(this.stuffedItems.subList(0, Math.min(this.stuffedItems.size(), 64)));
        myList.add(new ItemStack((Item)TEItems.itemConduits, 1, this.conduitType + 4096));
        return myList;
    }

    public void renderDynamic(Vector3 pos, float frame, int pass) {
        RenderUtils.preRender();
        RenderConduit.instance.renderTravelingItems(this.myItems, this.world(), pos.x, pos.y, pos.z, frame);
        CCRenderState.useNormals((boolean)false);
    }

    @Override
    public String getType() {
        return "ConduitItem" + this.conduitType;
    }

    public ItemStack insertItem(ForgeDirection from, ItemStack item, boolean simulate) {
        if (simulate) {
            return item;
        }
        return this.insertItem(from, item);
    }

    public ItemStack sendItems(ItemStack item, ForgeDirection from) {
        return this.insertItem(from, item);
    }

    static {
        noRoute = new routeInfo();
        modeStrings = new String[]{StringHelper.localize((String)"message.thermalexpansion.conduit.item0"), StringHelper.localize((String)"message.thermalexpansion.conduit.item1"), StringHelper.localize((String)"message.thermalexpansion.conduit.item2"), StringHelper.localize((String)"message.thermalexpansion.conduit.item3")};
        sideTypes = new int[3];
        modeTypes = new int[3];
        modeTypesPowered = new int[3];
        itemTypes = new int[4][4];
        ConduitItem.sideTypes[1] = BlockConduit.ConnectionTypes.CONDUIT.ordinal();
        ConduitItem.sideTypes[0] = BlockConduit.ConnectionTypes.NONE.ordinal();
        ConduitItem.modeTypes[0] = BlockConduit.ConnectionTypes.ITEM_BLOCKED.ordinal();
        ConduitItem.modeTypes[1] = BlockConduit.ConnectionTypes.ITEM_NORMAL.ordinal();
        ConduitItem.modeTypes[2] = BlockConduit.ConnectionTypes.ITEM_INPUT_OFF.ordinal();
        ConduitItem.modeTypesPowered[0] = BlockConduit.ConnectionTypes.ITEM_BLOCKED.ordinal();
        ConduitItem.modeTypesPowered[1] = BlockConduit.ConnectionTypes.ITEM_NORMAL.ordinal();
        ConduitItem.modeTypesPowered[2] = BlockConduit.ConnectionTypes.ITEM_INPUT_ON.ordinal();
        ConduitItem.itemTypes[0][0] = BlockConduit.RenderTypes.ITEM_TRANS.ordinal();
        ConduitItem.itemTypes[0][1] = BlockConduit.RenderTypes.ITEM_TRANS_LONG.ordinal();
        ConduitItem.itemTypes[0][2] = BlockConduit.RenderTypes.ITEM_TRANS_SHORT.ordinal();
        ConduitItem.itemTypes[0][3] = BlockConduit.RenderTypes.ITEM_TRANS_ROUNDROBIN.ordinal();
        ConduitItem.itemTypes[1][0] = BlockConduit.RenderTypes.ITEM_OPAQUE.ordinal();
        ConduitItem.itemTypes[1][1] = BlockConduit.RenderTypes.ITEM_OPAQUE_LONG.ordinal();
        ConduitItem.itemTypes[1][2] = BlockConduit.RenderTypes.ITEM_OPAQUE_SHORT.ordinal();
        ConduitItem.itemTypes[1][3] = BlockConduit.RenderTypes.ITEM_OPAQUE_ROUNDROBIN.ordinal();
        ConduitItem.itemTypes[2][0] = BlockConduit.RenderTypes.ITEM_FAST_TRANS.ordinal();
        ConduitItem.itemTypes[2][1] = BlockConduit.RenderTypes.ITEM_FAST_TRANS_LONG.ordinal();
        ConduitItem.itemTypes[2][2] = BlockConduit.RenderTypes.ITEM_FAST_TRANS_SHORT.ordinal();
        ConduitItem.itemTypes[2][3] = BlockConduit.RenderTypes.ITEM_FAST_TRANS_ROUNDROBIN.ordinal();
        ConduitItem.itemTypes[3][0] = BlockConduit.RenderTypes.ITEM_FAST_OPAQUE.ordinal();
        ConduitItem.itemTypes[3][1] = BlockConduit.RenderTypes.ITEM_FAST_OPAQUE_LONG.ordinal();
        ConduitItem.itemTypes[3][2] = BlockConduit.RenderTypes.ITEM_FAST_OPAQUE_SHORT.ordinal();
        ConduitItem.itemTypes[3][3] = BlockConduit.RenderTypes.ITEM_FAST_OPAQUE_ROUNDROBIN.ordinal();
        _INPUT_TICK = new int[]{30, 30, 8, 8};
        _PIPE_LEN = new int[]{40, 40, 10, 10};
        _PIPE_HALF_LEN = new int[]{_PIPE_LEN[0] / 2, _PIPE_LEN[1] / 2, _PIPE_LEN[2] / 2, _PIPE_LEN[3] / 2};
        _PIPE_TICK_LEN = new float[]{0.025f, 0.025f, 0.1f, 0.1f};
        _SIDE_MODS = new float[4][6][3];
        for (int i = 0; i < 4; ++i) {
            float j = _PIPE_TICK_LEN[i];
            ConduitItem._SIDE_MODS[i][0] = new float[]{0.0f, -j, 0.0f};
            ConduitItem._SIDE_MODS[i][1] = new float[]{0.0f, j, 0.0f};
            ConduitItem._SIDE_MODS[i][2] = new float[]{0.0f, 0.0f, -j};
            ConduitItem._SIDE_MODS[i][3] = new float[]{0.0f, 0.0f, j};
            ConduitItem._SIDE_MODS[i][4] = new float[]{-j, 0.0f, 0.0f};
            ConduitItem._SIDE_MODS[i][5] = new float[]{j, 0.0f, 0.0f};
        }
        _RENDERS_ITEMS = new boolean[]{true, false, true, false};
    }

    public class TileInfoPackets {
        public static final byte GUI_BUTTON = 0;
        public static final byte STUFFED_UPDATE = 1;
        public static final byte TRAVELING_ITEMS = 2;
        public static final byte STUFFED_ITEMS = 3;
        public static final byte REQUEST_STUFFED_ITEMS = 4;
    }

    public static class ItemType {
        public static final int CONDUIT = 0;
        public static final int LONGCONDUIT = 1;
        public static final int SHORTCONDUIT = 2;
        public static final int ROUNDROBIN = 3;
        public static final int WRENCH_MAX = 4;
    }

    public static class routeInfo {
        public boolean canRoute = false;
        public int stackSize = -1;
        public byte side = (byte)-1;

        public routeInfo(int stackSizeLeft, byte i) {
            this.canRoute = true;
            this.stackSize = stackSizeLeft;
            this.side = i;
        }

        public routeInfo() {
        }
    }
}

