/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.part.conduit.energy;

import cofh.api.energy.EnergyStorage;
import thermalexpansion.part.conduit.ConduitBase;
import thermalexpansion.part.conduit.Grid;
import thermalexpansion.part.conduit.GridTickHandler;
import thermalexpansion.part.conduit.energy.ConduitEnergy;

public class GridEnergy
extends Grid {
    public EnergyStorage myStorage = new EnergyStorage(480, 80);
    public int nodeStorage;
    public int transferRate;
    public int toDistribute = 0;
    public int toDistributeMaster = 0;
    public int sideDistribute = 0;
    public int sideDistributeMaster = 0;

    public GridEnergy(ConduitBase myNode, int storage, int transRate) {
        this.nodeStorage = storage;
        this.transferRate = transRate;
        this.myStorage = new EnergyStorage(this.nodeStorage, this.transferRate);
        this.addConduit(myNode);
        GridTickHandler.tickingGridsToAdd.add(this);
    }

    @Override
    public void doGridUpdate() {
        if (this.myStorage.getEnergyStored() > 0 && this.nodeSet.size() > 0) {
            this.toDistribute = this.myStorage.getEnergyStored() / this.nodeSet.size();
            this.toDistributeMaster = this.toDistribute + this.myStorage.getEnergyStored() % this.nodeSet.size();
            this.sideDistribute = this.toDistribute / 6;
            this.sideDistributeMaster = this.toDistributeMaster / 6;
            super.doGridUpdate();
        } else if (this.nodeSet.isEmpty() && this.conduitSet.isEmpty()) {
            GridTickHandler.tickingGridsToRemove.add(this);
        }
    }

    @Override
    public void nodeAdded(ConduitBase theCond) {
        ConduitEnergy theCondE = (ConduitEnergy)theCond;
        if (theCondE.energyForGrid > 0) {
            this.myStorage.modifyEnergyStored(theCondE.energyForGrid);
        }
    }

    public int getNodeShare(ConduitEnergy conduitEnergy) {
        return this.nodeSet.size() == 1 ? this.myStorage.getEnergyStored() : (this.isFirstConduit(conduitEnergy) ? this.myStorage.getEnergyStored() / this.nodeSet.size() + this.myStorage.getEnergyStored() % this.nodeSet.size() : this.myStorage.getEnergyStored() / this.nodeSet.size());
    }

    public int getDistributionSide(ConduitBase theCond) {
        return this.isFirstConduit(theCond) ? this.sideDistributeMaster : this.sideDistribute;
    }

    @Override
    public void destroyNode(ConduitBase theNode) {
        ((ConduitEnergy)theNode).energyForGrid = this.getNodeShare((ConduitEnergy)theNode);
        super.destroyNode(theNode);
    }

    @Override
    public void rebalanceGrid() {
        this.myStorage.setCapacity(this.nodeSet.size() * this.nodeStorage);
    }

    @Override
    public void mergeGrid(Grid theGrid) {
        super.mergeGrid(theGrid);
        this.myStorage.modifyEnergyStored(((GridEnergy)theGrid).myStorage.getEnergyStored());
    }
}

