/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.tank;

import cofh.block.ItemBlockCoFHBase;
import cofh.util.StringHelper;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import thermalexpansion.block.tank.BlockTank;
import thermalexpansion.block.tank.TileTank;

public class ItemBlockTank
extends ItemBlockCoFHBase
implements IFluidContainerItem {
    public ItemBlockTank(int id) {
        super(id);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public String func_77628_j(ItemStack stack) {
        return StringHelper.localize((String)this.func_77667_c(stack));
    }

    public String func_77667_c(ItemStack stack) {
        return "tile.thermalexpansion.tank." + BlockTank.NAMES[stack.func_77960_j()] + ".name";
    }

    public int func_77647_b(int i) {
        return i;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        switch (BlockTank.Types.values()[stack.func_77960_j()]) {
            case CREATIVE: {
                return EnumRarity.epic;
            }
            case RESONANT: {
                return EnumRarity.rare;
            }
            case REINFORCED: {
                return EnumRarity.uncommon;
            }
        }
        return EnumRarity.common;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean check) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.shiftForInfo);
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        if (stack.field_77990_d == null || !stack.field_77990_d.func_74764_b("Fluid")) {
            list.add(StringHelper.localize((String)"info.cofh.fluid") + ": " + StringHelper.localize((String)"info.cofh.empty"));
            if (stack.func_77960_j() == BlockTank.Types.CREATIVE.ordinal()) {
                list.add(StringHelper.localize((String)"info.cofh.infinite") + " " + StringHelper.localize((String)"info.cofh.source"));
            } else {
                list.add(StringHelper.localize((String)"info.cofh.level") + ": 0 / " + TileTank.CAPACITY[stack.func_77960_j()] + " mB");
            }
            return;
        }
        FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.field_77990_d.func_74775_l("Fluid"));
        if (fluid != null) {
            String color = "\u00a78";
            if (fluid.getFluid().getRarity() == EnumRarity.uncommon) {
                color = "\u00a7e";
            } else if (fluid.getFluid().getRarity() == EnumRarity.rare) {
                color = "\u00a7b";
            } else if (fluid.getFluid().getRarity() == EnumRarity.epic) {
                color = "\u00a7d";
            }
            list.add(StringHelper.localize((String)"info.cofh.fluid") + ": " + color + fluid.getFluid().getLocalizedName() + "\u00a78");
            if (stack.func_77960_j() == BlockTank.Types.CREATIVE.ordinal()) {
                list.add(StringHelper.localize((String)"info.cofh.infinite") + " " + StringHelper.localize((String)"info.cofh.source"));
            } else {
                list.add(StringHelper.localize((String)"info.cofh.level") + ": " + fluid.amount + " / " + TileTank.CAPACITY[stack.func_77960_j()] + " mB");
            }
        } else {
            list.add(StringHelper.localize((String)"info.cofh.fluid") + ": " + StringHelper.localize((String)"info.cofh.empty"));
            if (stack.func_77960_j() == BlockTank.Types.CREATIVE.ordinal()) {
                list.add(StringHelper.localize((String)"info.cofh.infinite") + " " + StringHelper.localize((String)"info.cofh.source"));
            } else {
                list.add(StringHelper.localize((String)"info.cofh.level") + ": 0 / " + TileTank.CAPACITY[stack.func_77960_j()] + " mB");
            }
        }
    }

    public FluidStack getFluid(ItemStack container) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Fluid")) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.field_77990_d.func_74775_l("Fluid"));
    }

    public int getCapacity(ItemStack container) {
        return TileTank.CAPACITY[container.func_77960_j()];
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        int capacity = this.getCapacity(container);
        if (!doFill) {
            if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Fluid")) {
                return Math.min(capacity, resource.amount);
            }
            FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.field_77990_d.func_74775_l("Fluid"));
            if (stack == null) {
                return Math.min(capacity, resource.amount);
            }
            if (!stack.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(capacity - stack.amount, resource.amount);
        }
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        if (!container.field_77990_d.func_74764_b("Fluid")) {
            NBTTagCompound fluidTag = resource.writeToNBT(new NBTTagCompound());
            if (capacity < resource.amount) {
                fluidTag.func_74768_a("Amount", capacity);
                container.field_77990_d.func_74782_a("Fluid", (NBTBase)fluidTag);
                return capacity;
            }
            fluidTag.func_74768_a("Amount", resource.amount);
            container.field_77990_d.func_74782_a("Fluid", (NBTBase)fluidTag);
            return resource.amount;
        }
        NBTTagCompound fluidTag = container.field_77990_d.func_74775_l("Fluid");
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        if (!stack.isFluidEqual(resource)) {
            return 0;
        }
        int filled = capacity - stack.amount;
        if (resource.amount < filled) {
            stack.amount += resource.amount;
            filled = resource.amount;
        } else {
            stack.amount = capacity;
        }
        container.field_77990_d.func_74782_a("Fluid", (NBTBase)stack.writeToNBT(fluidTag));
        return filled;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Fluid") || maxDrain == 0) {
            return null;
        }
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.field_77990_d.func_74775_l("Fluid"));
        if (stack == null) {
            return null;
        }
        int drained = Math.min(stack.amount, maxDrain);
        if (doDrain && container.func_77960_j() != BlockTank.Types.CREATIVE.ordinal()) {
            if (maxDrain >= stack.amount) {
                container.field_77990_d.func_82580_o("Fluid");
                if (container.field_77990_d.func_82582_d()) {
                    container.field_77990_d = null;
                }
                return stack;
            }
            NBTTagCompound fluidTag = container.field_77990_d.func_74775_l("Fluid");
            fluidTag.func_74768_a("Amount", fluidTag.func_74762_e("Amount") - drained);
            container.field_77990_d.func_74782_a("Fluid", (NBTBase)fluidTag);
        }
        stack.amount = drained;
        return stack;
    }
}

