/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.plate;

import cofh.api.tileentity.IReconfigurableFacing;
import cofh.network.ITilePacketHandler;
import cofh.network.Payload;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.block.TileTEBase;
import thermalexpansion.block.plate.BlockPlate;

public abstract class TilePlateBase
extends TileTEBase
implements ITilePacketHandler,
IReconfigurableFacing {
    byte alignment;
    byte direction;

    public boolean canUpdate() {
        return false;
    }

    public String getName() {
        return "tile.thermalexpansion.plate." + BlockPlate.NAMES[this.getType()] + ".name";
    }

    public Payload getDescriptionPayload() {
        Payload payload = super.getDescriptionPayload();
        payload.addByte(this.alignment);
        payload.addByte(this.direction);
        return payload;
    }

    public void handleTilePacket(Payload payload) {
        this.alignment = payload.getByte();
        this.direction = payload.getByte();
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getBlockID());
    }

    public abstract void onEntityCollidedWithBlock(Entity var1);

    public int getAlignment() {
        return this.alignment;
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.alignment = nbt.func_74771_c("Align");
        this.direction = nbt.func_74771_c("Dir");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74774_a("Align", this.alignment);
        nbt.func_74774_a("Dir", this.direction);
    }

    public int getFacing() {
        return this.direction;
    }

    public boolean allowYAxisFacing() {
        return false;
    }

    public boolean rotateBlock() {
        this.direction = (byte)(this.direction + 1);
        this.direction = (byte)(this.direction % 6);
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    public boolean setFacing(int side) {
        if (side < 0 || side > 5) {
            return false;
        }
        this.direction = (byte)side;
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, TEBlocks.blockPlate.field_71990_ca);
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }
}

