/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyStorage;
import cofh.api.tileentity.IEnergyInfo;
import cofh.network.Payload;
import cofh.util.EnergyHelper;
import cofh.util.MathHelper;
import cofh.util.ServerHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.block.machine.BlockMachine;
import thermalexpansion.block.machine.TileMachineBase;
import thermalexpansion.core.TEProps;

public abstract class TileMachineEnergized
extends TileMachineBase
implements IEnergyHandler,
IEnergyInfo {
    protected static final EnergyConfig[] energyData = new EnergyConfig[BlockMachine.Types.values().length];
    EnergyConfig energyConfig = energyData[this.getType()];
    EnergyStorage energyStorage;

    public TileMachineEnergized() {
        this.energyStorage = new EnergyStorage(this.energyConfig.maxEnergy, this.energyConfig.maxPower * 4);
    }

    public int calcEnergy() {
        if (!this.isActive) {
            return 0;
        }
        if (this.energyStorage.getEnergyStored() > this.energyConfig.maxPowerLevel) {
            return this.energyConfig.maxPower;
        }
        if (this.energyStorage.getEnergyStored() < this.energyConfig.minPowerLevel) {
            return this.energyConfig.minPower;
        }
        return this.energyStorage.getEnergyStored() / this.energyConfig.energyRamp;
    }

    protected boolean canStart() {
        return false;
    }

    public boolean canFinish() {
        return this.processRem > 0 ? false : this.hasValidInput();
    }

    protected boolean hasValidInput() {
        return true;
    }

    protected void processStart() {
    }

    protected void processFinish() {
    }

    protected void transferProducts() {
    }

    public void func_70316_g() {
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        boolean curActive = this.isActive;
        if (this.isActive) {
            if (this.processRem > 0) {
                int energy = this.calcEnergy();
                this.energyStorage.modifyEnergyStored(-energy);
                this.processRem -= energy;
            }
            if (this.canFinish()) {
                this.processFinish();
                this.transferProducts();
                this.energyStorage.modifyEnergyStored(-this.processRem);
                if (!this.redstoneControlOrDisable() || !this.canStart()) {
                    this.isActive = false;
                    this.wasActive = true;
                    this.tracker.markTime(this.field_70331_k);
                } else {
                    this.processStart();
                }
            }
        } else if (this.redstoneControlOrDisable()) {
            if (this.timeCheck()) {
                this.transferProducts();
            }
            if (this.timeCheckEighth() && this.canStart()) {
                this.processStart();
                int energy = this.calcEnergy();
                this.energyStorage.modifyEnergyStored(-energy);
                this.processRem -= energy;
                this.isActive = true;
            }
        }
        this.updateIfChanged(curActive);
        this.chargeEnergy();
    }

    public void chargeEnergy() {
        if (this.hasChargeSlot() && EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[this.getChargeSlot()])) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(((IEnergyContainerItem)this.inventory[this.getChargeSlot()].func_77973_b()).extractEnergy(this.inventory[this.getChargeSlot()], energyRequest, false), false);
        }
    }

    public boolean hasChargeSlot() {
        return true;
    }

    public int getChargeSlot() {
        return this.inventory.length - 1;
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Override
    public Payload getGuiPayload() {
        Payload payload = super.getGuiPayload();
        payload.addInt(this.energyStorage.getEnergyStored());
        return payload;
    }

    @Override
    public void handleTileInfoPacket(Payload payload, NetHandler handler) {
        switch (TEProps.PacketID.values()[payload.getByte()]) {
            case GUI: {
                this.isActive = payload.getBool();
                this.processMax = payload.getInt();
                this.processRem = payload.getInt();
                this.energyStorage.setEnergyStored(payload.getInt());
                return;
            }
        }
    }

    public int getScaledSpeed(int scale) {
        if (!this.isActive) {
            return 0;
        }
        double power = this.energyStorage.getEnergyStored() / this.energyConfig.energyRamp;
        power = MathHelper.clip((double)power, (double)this.energyConfig.minPower, (double)this.energyConfig.maxPower);
        return MathHelper.round((double)((double)scale * power / (double)this.energyConfig.maxPower));
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.energyStorage.readFromNBT(nbt);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        this.energyStorage.writeToNBT(nbt);
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = super.func_70298_a(slot, amount);
        if (ServerHelper.isServerWorld((World)this.field_70331_k) && slot <= this.getMaxInputSlot() && this.isActive && (this.inventory[slot] == null || !this.hasValidInput())) {
            this.isActive = false;
            this.wasActive = true;
            this.tracker.markTime(this.field_70331_k);
            this.processRem = 0;
        }
        return stack;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        if (ServerHelper.isServerWorld((World)this.field_70331_k) && slot <= this.getMaxInputSlot() && this.isActive && this.inventory[slot] != null && (stack == null || !stack.func_77969_a(this.inventory[slot]) || !this.hasValidInput())) {
            this.isActive = false;
            this.wasActive = true;
            this.tracker.markTime(this.field_70331_k);
            this.processRem = 0;
        }
        super.func_70299_a(slot, stack);
    }

    public void func_70296_d() {
        if (this.isActive && !this.hasValidInput()) {
            this.isActive = false;
            this.wasActive = true;
            this.tracker.markTime(this.field_70331_k);
            this.processRem = 0;
        }
        super.func_70296_d();
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public boolean canInterface(ForgeDirection from) {
        return true;
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int getEnergyPerTick() {
        return this.calcEnergy();
    }

    public int getMaxEnergyPerTick() {
        return this.energyConfig.maxPower;
    }

    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergy() {
        return this.energyConfig.maxEnergy;
    }

    public static class EnergyConfig {
        public int minPower;
        public int maxPower;
        public int maxEnergy;
        public int minPowerLevel;
        public int maxPowerLevel;
        public int energyRamp;

        public boolean setEnergyParams(int minPower, int maxPower, int maxEnergy) {
            if (minPower <= 0 || maxPower <= 0 || maxEnergy <= 0) {
                return false;
            }
            this.minPower = minPower;
            this.maxPower = maxPower;
            this.maxEnergy = maxEnergy;
            this.maxPowerLevel = maxEnergy * 8 / 10;
            this.energyRamp = this.maxPowerLevel / maxPower;
            this.minPowerLevel = minPower * this.energyRamp;
            return true;
        }

        public boolean setEnergyParams(int maxPower) {
            return this.setEnergyParams(maxPower / 4, maxPower, maxPower * 1200);
        }
    }
}

