/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.energycell;

import cofh.api.energy.IEnergyContainerItem;
import cofh.block.ItemBlockCoFHBase;
import cofh.util.StringHelper;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import thermalexpansion.block.energycell.BlockEnergyCell;
import thermalexpansion.block.energycell.TileEnergyCell;
import thermalexpansion.block.energycell.TileEnergyCellCreative;

public class ItemBlockEnergyCell
extends ItemBlockCoFHBase
implements IEnergyContainerItem {
    public static ItemStack setDefaultTag(ItemStack container, int energy) {
        container.func_77982_d(new NBTTagCompound());
        if (container.func_77960_j() == BlockEnergyCell.Types.CREATIVE.ordinal()) {
            container.field_77990_d.func_74773_a("SideCache", TileEnergyCellCreative.DEFAULT_SIDES);
        } else {
            container.field_77990_d.func_74773_a("SideCache", TileEnergyCell.DEFAULT_SIDES);
        }
        container.field_77990_d.func_74774_a("Facing", (byte)3);
        container.field_77990_d.func_74768_a("Energy", energy);
        container.field_77990_d.func_74768_a("Send", TileEnergyCell.MAX_SEND[container.func_77960_j()]);
        container.field_77990_d.func_74768_a("Receive", TileEnergyCell.MAX_RECEIVE[container.func_77960_j()]);
        container.field_77990_d.func_74757_a("Disable", false);
        container.field_77990_d.func_74757_a("Setting", false);
        return container;
    }

    public ItemBlockEnergyCell(int id) {
        super(id);
        this.func_77627_a(true);
        this.func_77656_e(1);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public String func_77628_j(ItemStack stack) {
        return StringHelper.localize((String)this.func_77667_c(stack));
    }

    public String func_77667_c(ItemStack stack) {
        return "tile.thermalexpansion.energycell." + BlockEnergyCell.NAMES[stack.func_77960_j()] + ".name";
    }

    public int func_77647_b(int i) {
        return i;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        switch (BlockEnergyCell.Types.values()[stack.func_77960_j()]) {
            case CREATIVE: {
                return EnumRarity.epic;
            }
            case RESONANT: {
                return EnumRarity.rare;
            }
            case REINFORCED: {
                return EnumRarity.uncommon;
            }
        }
        return EnumRarity.common;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean check) {
        if (stack.field_77990_d == null) {
            ItemBlockEnergyCell.setDefaultTag(stack, 0);
        }
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.shiftForInfo);
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        int send = stack.field_77990_d.func_74762_e("Send");
        boolean rsDisable = stack.field_77990_d.func_74767_n("Disable");
        boolean rsSetting = stack.field_77990_d.func_74767_n("Setting");
        if (stack.func_77960_j() == BlockEnergyCell.Types.CREATIVE.ordinal()) {
            list.add(StringHelper.localize((String)"info.cofh.charge") + ": " + StringHelper.localize((String)"info.cofh.infinite"));
            list.add(StringHelper.localize((String)"info.cofh.send") + ": " + send);
        } else {
            int energy = stack.field_77990_d.func_74762_e("Energy");
            int receive = stack.field_77990_d.func_74762_e("Receive");
            list.add(StringHelper.localize((String)"info.cofh.charge") + ": " + StringHelper.getScaledNumber((int)energy) + " / " + StringHelper.getScaledNumber((int)TileEnergyCell.STORAGE[stack.func_77960_j()]) + " RF");
            list.add(StringHelper.localize((String)"info.cofh.send") + "/" + StringHelper.localize((String)"info.cofh.receive") + ": " + send + "/" + receive + " RF/t");
        }
        if (rsDisable) {
            list.add(StringHelper.localize((String)"info.cofh.signal") + ": " + StringHelper.localize((String)"info.cofh.redstoneControlOff"));
        } else if (!rsSetting) {
            list.add(StringHelper.localize((String)"info.cofh.signal") + ": " + StringHelper.localize((String)"info.cofh.redstoneControlOn") + ", " + StringHelper.localize((String)"info.cofh.redstoneStateLow"));
        } else {
            list.add(StringHelper.localize((String)"info.cofh.signal") + ": " + StringHelper.localize((String)"info.cofh.redstoneControlOn") + ", " + StringHelper.localize((String)"info.cofh.redstoneStateHigh"));
        }
    }

    public int getDisplayDamage(ItemStack stack) {
        if (stack.field_77990_d == null) {
            return 1 + TileEnergyCell.STORAGE[stack.func_77960_j()];
        }
        return 1 + TileEnergyCell.STORAGE[stack.func_77960_j()] - stack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxDamage(ItemStack stack) {
        return 1 + TileEnergyCell.STORAGE[stack.func_77960_j()];
    }

    public boolean isDamaged(ItemStack stack) {
        return stack.func_77960_j() != BlockEnergyCell.Types.CREATIVE.ordinal();
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77990_d == null) {
            ItemBlockEnergyCell.setDefaultTag(container, 0);
        }
        int stored = container.field_77990_d.func_74762_e("Energy");
        int receive = Math.min(maxReceive, Math.min(TileEnergyCell.STORAGE[container.func_77960_j()] - stored, TileEnergyCell.MAX_RECEIVE[container.func_77960_j()]));
        if (!simulate && container.func_77960_j() != BlockEnergyCell.Types.CREATIVE.ordinal()) {
            container.field_77990_d.func_74768_a("Energy", stored += receive);
        }
        return receive;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null) {
            ItemBlockEnergyCell.setDefaultTag(container, 0);
        }
        int stored = container.field_77990_d.func_74762_e("Energy");
        int extract = Math.min(maxExtract, Math.min(stored, TileEnergyCell.MAX_SEND[container.func_77960_j()]));
        if (!simulate && container.func_77960_j() != BlockEnergyCell.Types.CREATIVE.ordinal()) {
            container.field_77990_d.func_74768_a("Energy", stored -= extract);
        }
        return extract;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.field_77990_d == null) {
            ItemBlockEnergyCell.setDefaultTag(container, 0);
        }
        return container.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        return TileEnergyCell.STORAGE[container.func_77960_j()];
    }
}

