/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.dynamo;

import cofh.network.Payload;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.dynamo.BlockDynamo;
import thermalexpansion.block.dynamo.TileDynamoBase;
import thermalexpansion.core.TEProps;

public class TileDynamoMagmatic
extends TileDynamoBase
implements IFluidHandler {
    static Map fuels = new HashMap();
    FluidTank tank = new FluidTank(4000);
    FluidStack renderFluid = new FluidStack(FluidRegistry.LAVA, 1000);

    public static void initialize() {
        TileDynamoMagmatic.guiIds[BlockDynamo.Types.MAGMATIC.ordinal()] = ThermalExpansion.proxy.registerGui("DynamoMagmatic", "dynamo", "TEBase", null, true);
        GameRegistry.registerTileEntity(TileDynamoMagmatic.class, (String)"cofh.thermalexpansion.DynamoMagmatic");
    }

    public int getType() {
        return BlockDynamo.Types.MAGMATIC.ordinal();
    }

    public static boolean registerFuel(Fluid fluid, int energy) {
        if (fluid == null || energy <= 10000) {
            return false;
        }
        fuels.put(fluid, energy / 100);
        return true;
    }

    public static int getFuelEnergy(FluidStack stack) {
        return stack == null ? 0 : (Integer)fuels.get(stack.getFluid());
    }

    public static boolean isValidFuel(FluidStack stack) {
        return stack == null ? false : fuels.containsKey(stack.getFluid());
    }

    public FluidTank getTank(int tankIndex) {
        return this.tank;
    }

    @Override
    protected boolean canGenerate() {
        return this.fuelRF > 0 ? true : this.tank.getFluidAmount() >= 10;
    }

    @Override
    public void generate() {
        if (this.fuelRF <= 0) {
            this.fuelRF += TileDynamoMagmatic.getFuelEnergy(this.tank.getFluid());
            this.tank.drain(10, true);
        }
        int energy = this.calcEnergy();
        this.energyStorage.modifyEnergyStored(energy);
        this.fuelRF -= energy;
    }

    @Override
    public Icon getActiveIcon() {
        return this.renderFluid.getFluid().getIcon(this.renderFluid);
    }

    @Override
    public int getLightValue() {
        return this.isActive ? 14 : 0;
    }

    @Override
    public Payload getDescriptionPayload() {
        Payload payload = super.getDescriptionPayload();
        payload.addFluidStack(this.tank.getFluid());
        return payload;
    }

    @Override
    public Payload getGuiPayload() {
        Payload payload = Payload.getInfoPayload((TileEntity)this);
        payload.addByte(TEProps.PacketID.GUI.ordinal());
        payload.addFluidStack(this.tank.getFluid());
        payload.addInt(this.energyStorage.getEnergyStored());
        return payload;
    }

    @Override
    public void handleTilePacket(Payload payload) {
        super.handleTilePacket(payload);
        this.renderFluid = payload.getFluidStack();
        if (this.renderFluid == null) {
            this.renderFluid = new FluidStack(FluidRegistry.LAVA, 1000);
        }
    }

    @Override
    public void handleTileInfoPacket(Payload payload, NetHandler handler) {
        switch (TEProps.PacketID.values()[payload.getByte()]) {
            case GUI: {
                this.tank.setFluid(payload.getFluidStack());
                this.energyStorage.setEnergyStored(payload.getInt());
                return;
            }
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.tank.readFromNBT(nbt);
        if (!TileDynamoMagmatic.isValidFuel(this.tank.getFluid())) {
            this.tank.setFluid(null);
        }
        if (this.tank.getFluid() != null) {
            this.renderFluid = this.tank.getFluid();
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        this.tank.writeToNBT(nbt);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null || from != ForgeDirection.UNKNOWN && from.ordinal() == this.facing) {
            return 0;
        }
        if (TileDynamoMagmatic.isValidFuel(resource)) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || from != ForgeDirection.UNKNOWN && from.ordinal() == this.facing) {
            return null;
        }
        if (TileDynamoMagmatic.isValidFuel(resource)) {
            return this.tank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from.ordinal() != this.facing;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from.ordinal() != this.facing;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }
}

