/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.device;

import cofh.entity.PlayerFake;
import cofh.render.IconRegistry;
import cofh.util.BlockHelper;
import cofh.util.FluidHelper;
import cofh.util.InventoryHelper;
import cofh.util.ServerHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.block.TileReconfigurableInventory;
import thermalexpansion.block.device.BlockDevice;
import thermalexpansion.core.TEProps;

public class TileBreaker
extends TileReconfigurableInventory
implements IFluidHandler {
    protected static int guiId;
    public static final int[] SIDE_TEX;
    public LinkedList<ItemStack> stuffedItems = new LinkedList();
    PlayerFake myFakePlayer;
    boolean needsWorld = true;

    public static void initialize() {
        GameRegistry.registerTileEntity(TileBreaker.class, (String)"cofh.thermalexpansion.Breaker");
        guiId = ThermalExpansion.proxy.registerGui("Breaker", "device", "TEBase", null, true);
    }

    public int getBlockID() {
        return TEBlocks.blockDevice.field_71990_ca;
    }

    public String getName() {
        return "tile.thermalexpansion.device." + BlockDevice.NAMES[this.getType()] + ".name";
    }

    public int getType() {
        return BlockDevice.Types.BREAKER.ordinal();
    }

    public boolean openGui(EntityPlayer player) {
        player.openGui((Object)ThermalExpansion.instance, guiId, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    @Override
    public boolean sendRedstoneUpdates() {
        return true;
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (ServerHelper.isServerWorld((World)this.field_70331_k) && this.field_70331_k.func_82737_E() % 16L == 0L && this.redstoneControlOrDisable()) {
            if (!this.isEmpty()) {
                this.outputBuffer();
            }
            if (this.isEmpty()) {
                this.updateFakePlayer();
                this.breakBlock();
            }
        }
    }

    public void breakBlock() {
        int[] coords = BlockHelper.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)this.facing);
        int blockID = this.field_70331_k.func_72798_a(coords[0], coords[1], coords[2]);
        FluidStack theStack = FluidHelper.getFluidFromWorld((World)this.field_70331_k, (int)coords[0], (int)coords[1], (int)coords[2]);
        if (theStack != null) {
            for (int i = 0; i < 6 && theStack.amount > 0; ++i) {
                if (this.sideCache[i] != 1) continue;
                theStack.amount -= FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (int)i, (FluidStack)theStack, (boolean)true);
            }
            this.field_70331_k.func_94575_c(coords[0], coords[1], coords[2], 0);
        } else if (BlockHelper.isBlock((int)blockID) && PlayerFake.isBlockBreakable((PlayerFake)this.myFakePlayer, (World)this.field_70331_k, (int)coords[0], (int)coords[1], (int)coords[2])) {
            this.stuffedItems.addAll(BlockHelper.breakBlock((World)this.field_70331_k, (int)coords[0], (int)coords[1], (int)coords[2], (int)blockID, (int)0, (boolean)true, (boolean)false));
        }
    }

    public boolean isEmpty() {
        return this.stuffedItems.size() == 0;
    }

    public void outputBuffer() {
        for (int i = 0; i < 6; ++i) {
            int[] coords;
            TileEntity theTile;
            if (i == this.facing || this.sideCache[i] != 1 || !InventoryHelper.isInsertion((Object)(theTile = this.field_70331_k.func_72796_p((coords = BlockHelper.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)i))[0], coords[1], coords[2])))) continue;
            LinkedList<ItemStack> newStuffed = new LinkedList<ItemStack>();
            for (Object curItem : this.stuffedItems) {
                curItem = curItem == null || curItem.func_77973_b() == null ? null : InventoryHelper.addToInsertion((Object)theTile, (int)i, (ItemStack)curItem);
                if (curItem == null) continue;
                newStuffed.add((ItemStack)curItem);
            }
            this.stuffedItems = newStuffed;
        }
    }

    public void updateFakePlayer() {
        if (this.needsWorld) {
            this.myFakePlayer = new PlayerFake(this.field_70331_k);
            this.needsWorld = false;
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        NBTTagList list = nbt.func_74761_m("StuffedInv");
        this.stuffedItems.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = (NBTTagCompound)list.func_74743_b(i);
            this.stuffedItems.add(ItemStack.func_77949_a((NBTTagCompound)compound));
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        NBTTagList list = new NBTTagList();
        list = new NBTTagList();
        for (int i = 0; i < this.stuffedItems.size(); ++i) {
            if (this.stuffedItems.get(i) == null) continue;
            NBTTagCompound compound = new NBTTagCompound();
            this.stuffedItems.get(i).func_77955_b(compound);
            list.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a("StuffedInv", (NBTBase)list);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return null;
    }

    @Override
    public boolean setFacing(int side) {
        if (side < 0 || side > 5) {
            return false;
        }
        this.facing = (byte)side;
        this.sideCache[this.facing ^ 1] = 1;
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getBlockID());
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    @Override
    public int getNumConfig(int side) {
        return 2;
    }

    @Override
    public Icon getBlockTexture(int side, int pass) {
        if (pass == 0) {
            return side != this.facing ? IconRegistry.getIcon((String)"DeviceSide") : (this.redstoneControlOrDisable() ? IconRegistry.getIcon((String)"DeviceActive_", (int)this.getType()) : IconRegistry.getIcon((String)"DeviceFace_", (int)this.getType()));
        }
        if (side < 6) {
            return IconRegistry.getIcon((String)TEProps.textureSelection, (int)SIDE_TEX[this.sideCache[side]]);
        }
        return IconRegistry.getIcon((String)"DeviceSide");
    }

    static {
        SIDE_TEX = new int[]{0, 4};
    }
}

