/*
 * Decompiled with CFR 0.152.
 */
package ic2.api;

import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public enum Direction {
    XN(0),
    XP(1),
    YN(2),
    YP(3),
    ZN(4),
    ZP(5);

    private int dir;
    public static final Direction[] directions;

    private Direction(int dir) {
        this.dir = dir;
    }

    public TileEntity applyToTileEntity(TileEntity tileEntity) {
        int[] coords = new int[]{tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n};
        int n = this.dir / 2;
        coords[n] = coords[n] + this.getSign();
        if (tileEntity.field_70331_k != null && tileEntity.field_70331_k.func_72899_e(coords[0], coords[1], coords[2])) {
            try {
                return tileEntity.field_70331_k.func_72796_p(coords[0], coords[1], coords[2]);
            }
            catch (Exception e) {
                throw new RuntimeException("error getting TileEntity at dim " + tileEntity.field_70331_k.field_73011_w.field_76574_g + " " + coords[0] + "/" + coords[1] + "/" + coords[2]);
            }
        }
        return null;
    }

    public Direction getInverse() {
        int inverseDir = this.dir - this.getSign();
        for (Direction direction : directions) {
            if (direction.dir != inverseDir) continue;
            return direction;
        }
        return this;
    }

    public int toSideValue() {
        return (this.dir + 4) % 6;
    }

    private int getSign() {
        return this.dir % 2 * 2 - 1;
    }

    public ForgeDirection toForgeDirection() {
        return ForgeDirection.getOrientation((int)this.toSideValue());
    }

    static {
        directions = Direction.values();
    }
}

