/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.genetics;

import binnie.core.Binnie;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.block.FruitPod;
import binnie.extratrees.genetics.ExtraTreeFruitFamily;
import binnie.extratrees.genetics.FruitSprite;
import binnie.extratrees.item.Food;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IFruitFamily;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public enum ExtraTreeFruitGene implements IAlleleFruit,
IFruitProvider
{
    Blackthorn("Blackthorn", 10, 7180062, 14561129, FruitSprite.Small),
    CherryPlum("Cherry Plum", 10, 7180062, 15211595, FruitSprite.Small),
    Peach("Peach", 10, 7180062, 16424995, FruitSprite.Average),
    Nectarine("Nectarine", 10, 7180062, 16405795, FruitSprite.Average),
    Apricot("Apricot", 10, 7180062, 16437027, FruitSprite.Average),
    Almond("Almond", 10, 7180062, 9364342, FruitSprite.Small),
    WildCherry("Wild Cherry", 10, 7180062, 0xFF0000, FruitSprite.Tiny),
    SourCherry("Sour Cherry", 10, 7180062, 10225963, FruitSprite.Tiny),
    BlackCherry("Black Cherry", 10, 7180062, 4852249, FruitSprite.Tiny),
    Orange("Orange", 10, 3665987, 16749578, FruitSprite.Average),
    Manderin("Manderin", 10, 3665987, 16749578, FruitSprite.Average),
    Tangerine("Tangerine", 10, 3665987, 16749578, FruitSprite.Average),
    Satsuma("Satsuma", 10, 3665987, 16749578, FruitSprite.Average),
    KeyLime("Key Lime", 10, 3665987, 10223428, FruitSprite.Small),
    Lime("Lime", 10, 3665987, 10223428, FruitSprite.Average),
    FingerLime("Finger Lime", 10, 3665987, 11156280, FruitSprite.Small),
    Pomelo("Pomelo", 10, 3665987, 6083402, FruitSprite.Larger),
    Grapefruit("Grape Fruit", 10, 3665987, 16749578, FruitSprite.Large),
    Kumquat("Kumquat", 10, 3665987, 16749578, FruitSprite.Small),
    Citron("Citron", 10, 3665987, 16772192, FruitSprite.Large),
    BuddhaHand("Buddha's Hand", 10, 3665987, 16772192, FruitSprite.Large),
    Apple("Apple", 10, 7915859, 16193046, FruitSprite.Average),
    Crabapple("Crabapple", 10, 7915859, 16760140, FruitSprite.Average),
    Banana("Banana", FruitPod.Banana),
    RedBanana("Red Banana", FruitPod.RedBanana),
    Plantain("Platain", FruitPod.Plantain),
    Hazelnut("Hazelnut", 7, 8223006, 14463606, FruitSprite.Small),
    Butternut("Butternut", 7, 11712336, 16102498, FruitSprite.Small),
    Beechnut("Beechnut", 8, 14401148, 6241845, FruitSprite.Tiny),
    Pecan("Hickory Nut", 8, 10660940, 15781769, FruitSprite.Small),
    BrazilNut("Brazil Nut", 10, 5875561, 9852208, FruitSprite.Large),
    Fig("Fig", 9, 14201186, 7094086, FruitSprite.Small),
    Acorn("Acorn", 6, 7516710, 11364893, FruitSprite.Tiny),
    Elderberry("Elderberry", 9, 7444317, 5331779, FruitSprite.Tiny),
    Olive("Olive", 9, 8887861, 6444842, FruitSprite.Small),
    GingkoNut("Gingko Nut", 7, 9213787, 15063725, FruitSprite.Tiny),
    Coffee("Coffee", 8, 7433501, 16273254, FruitSprite.Tiny),
    Pear("Pear", 10, 10456913, 10474833, FruitSprite.Pear),
    OsangeOsange("Osange Osange", 10, 9934674, 10665767, FruitSprite.Larger),
    Clove("Clove", 9, 6847532, 11224133, FruitSprite.Tiny),
    Coconut("Coconut", FruitPod.Coconut),
    Cashew("Cashew", 8, 12879132, 15289111, FruitSprite.Average),
    Avacado("Avacado", 10, 10272370, 2170640, FruitSprite.Pear),
    Nutmeg("Nutmeg", 9, 14861101, 11305813, FruitSprite.Tiny),
    Allspice("Allspice", 9, 15180922, 7423542, FruitSprite.Tiny),
    Chilli("Chilli", 10, 7430757, 15145010, FruitSprite.Small),
    StarAnise("Star Anise", 8, 8733742, 13917189, FruitSprite.Tiny),
    Mango("Mango", 10, 6654997, 15902262, FruitSprite.Average),
    Starfruit("Starfruit", 10, 9814541, 15061550, FruitSprite.Average),
    Candlenut("Candlenut", 8, 8235123, 14600882, FruitSprite.Small),
    Papayimar("Papayimar", FruitPod.Papayimar),
    Blackcurrant("Blackcurrant", 8, 9407571, 4935251, FruitSprite.Tiny),
    Redcurrant("Redcurrant", 8, 13008910, 15080974, FruitSprite.Tiny),
    Blackberry("Blackberry", 8, 9399665, 4801393, FruitSprite.Tiny),
    Raspberry("Raspberry", 8, 15520197, 14510449, FruitSprite.Tiny),
    Blueberry("Blueberry", 8, 10203799, 6329278, FruitSprite.Tiny),
    Cranberry("Cranberry", 8, 12232496, 14555696, FruitSprite.Tiny),
    Juniper("Juniper", 8, 10194034, 6316914, FruitSprite.Tiny),
    Gooseberry("Gooseberry", 8, 12164944, 12177232, FruitSprite.Tiny),
    GoldenRaspberry("Golden Raspberry", 8, 12496955, 15970363, FruitSprite.Tiny);

    IFruitFamily family;
    boolean isRipening = false;
    int diffR;
    int diffG;
    int diffB = 0;
    FruitPod pod = null;
    int ripeningPeriod = 0;
    int colourUnripe;
    int colour;
    FruitSprite index;
    String name;
    HashMap<ItemStack, Float> products = new HashMap();

    public static void init() {
        IFruitFamily familyPrune = AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes");
        IFruitFamily familyPome = AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes");
        IFruitFamily familyJungle = AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle");
        IFruitFamily familyNuts = AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts");
        ExtraTreeFruitFamily familyBerry = new ExtraTreeFruitFamily();
        AlleleManager.alleleRegistry.registerFruitFamily((IFruitFamily)familyBerry);
        Apple.addProduct(new ItemStack(Item.field_77706_j), 1.0f);
        Apple.setFamily(familyPome);
        Crabapple.addProduct(Food.Crabapple.get(1), 1.0f);
        Crabapple.setFamily(familyPome);
        Orange.addProduct(Food.Orange.get(1), 1.0f);
        Orange.setFamily(familyPrune);
        Manderin.addProduct(Food.Manderin.get(1), 1.0f);
        Manderin.setFamily(familyPrune);
        Tangerine.addProduct(Food.Tangerine.get(1), 1.0f);
        Tangerine.setFamily(familyPrune);
        Satsuma.addProduct(Food.Satsuma.get(1), 1.0f);
        Satsuma.setFamily(familyPrune);
        KeyLime.addProduct(Food.KeyLime.get(1), 1.0f);
        KeyLime.setFamily(familyPrune);
        Lime.addProduct(Food.Lime.get(1), 1.0f);
        Lime.setFamily(familyPrune);
        FingerLime.addProduct(Food.FingerLime.get(1), 1.0f);
        FingerLime.setFamily(familyPrune);
        Pomelo.addProduct(Food.Pomelo.get(1), 1.0f);
        Pomelo.setFamily(familyPrune);
        Grapefruit.addProduct(Food.Grapefruit.get(1), 1.0f);
        Grapefruit.setFamily(familyPrune);
        Kumquat.addProduct(Food.Kumquat.get(1), 1.0f);
        Kumquat.setFamily(familyPrune);
        Citron.addProduct(Food.Citron.get(1), 1.0f);
        Citron.setFamily(familyPrune);
        BuddhaHand.addProduct(Food.BuddhaHand.get(1), 1.0f);
        BuddhaHand.setFamily(familyPrune);
        Blackthorn.addProduct(Food.Blackthorn.get(1), 1.0f);
        Blackthorn.setFamily(familyPrune);
        CherryPlum.addProduct(Food.CherryPlum.get(1), 1.0f);
        CherryPlum.setFamily(familyPrune);
        Peach.addProduct(Food.Peach.get(1), 1.0f);
        Peach.setFamily(familyPrune);
        Nectarine.addProduct(Food.Nectarine.get(1), 1.0f);
        Nectarine.setFamily(familyPrune);
        Apricot.addProduct(Food.Apricot.get(1), 1.0f);
        Apricot.setFamily(familyPrune);
        Almond.addProduct(Food.Almond.get(1), 1.0f);
        Almond.setFamily(familyPrune);
        WildCherry.addProduct(Food.WildCherry.get(1), 1.0f);
        WildCherry.setFamily(familyPrune);
        SourCherry.addProduct(Food.SourCherry.get(1), 1.0f);
        SourCherry.setFamily(familyPrune);
        BlackCherry.addProduct(Food.BlackCherry.get(1), 1.0f);
        BlackCherry.setFamily(familyPrune);
        Hazelnut.addProduct(Food.Hazelnut.get(1), 1.0f);
        Hazelnut.setFamily(familyNuts);
        Butternut.addProduct(Food.Butternut.get(1), 1.0f);
        Butternut.setFamily(familyNuts);
        Beechnut.addProduct(Food.Beechnut.get(1), 1.0f);
        Beechnut.setFamily(familyNuts);
        Pecan.addProduct(Food.Pecan.get(1), 1.0f);
        Pecan.setFamily(familyNuts);
        Banana.addProduct(Food.Banana.get(2), 1.0f);
        Banana.setFamily(familyJungle);
        RedBanana.addProduct(Food.RedBanana.get(2), 1.0f);
        RedBanana.setFamily(familyJungle);
        Plantain.addProduct(Food.Plantain.get(2), 1.0f);
        Plantain.setFamily(familyJungle);
        BrazilNut.addProduct(Food.BrazilNut.get(4), 1.0f);
        BrazilNut.setFamily(familyNuts);
        Fig.addProduct(Food.Fig.get(1), 1.0f);
        Fig.setFamily(familyPrune);
        Acorn.addProduct(Food.Acorn.get(1), 1.0f);
        Acorn.setFamily(familyNuts);
        Elderberry.addProduct(Food.Elderberry.get(1), 1.0f);
        Elderberry.setFamily(familyPrune);
        Olive.addProduct(Food.Olive.get(1), 1.0f);
        Olive.setFamily(familyPrune);
        GingkoNut.addProduct(Food.GingkoNut.get(1), 1.0f);
        GingkoNut.setFamily(familyNuts);
        Coffee.addProduct(Food.Coffee.get(1), 1.0f);
        Coffee.setFamily(familyJungle);
        Pear.addProduct(Food.Pear.get(1), 1.0f);
        Pear.setFamily(familyPome);
        OsangeOsange.addProduct(Food.OsangeOrange.get(1), 1.0f);
        OsangeOsange.setFamily(familyPome);
        Clove.addProduct(Food.Clove.get(1), 1.0f);
        Clove.setFamily(familyNuts);
        Blackcurrant.addProduct(Food.Blackcurrant.get(2), 1.0f);
        Blackcurrant.setFamily(familyBerry);
        Redcurrant.addProduct(Food.Redcurrant.get(2), 1.0f);
        Redcurrant.setFamily(familyBerry);
        Blackberry.addProduct(Food.Blackberry.get(2), 1.0f);
        Blackberry.setFamily(familyBerry);
        Raspberry.addProduct(Food.Raspberry.get(2), 1.0f);
        Raspberry.setFamily(familyBerry);
        Blueberry.addProduct(Food.Blueberry.get(2), 1.0f);
        Blueberry.setFamily(familyBerry);
        Cranberry.addProduct(Food.Cranberry.get(2), 1.0f);
        Cranberry.setFamily(familyBerry);
        Juniper.addProduct(Food.Juniper.get(2), 1.0f);
        Juniper.setFamily(familyBerry);
        Gooseberry.addProduct(Food.Gooseberry.get(2), 1.0f);
        Gooseberry.setFamily(familyBerry);
        GoldenRaspberry.addProduct(Food.GoldenRaspberry.get(2), 1.0f);
        GoldenRaspberry.setFamily(familyBerry);
        Coconut.addProduct(Food.Coconut.get(1), 1.0f);
        Coconut.setFamily(familyJungle);
        Cashew.addProduct(Food.Cashew.get(1), 1.0f);
        Cashew.setFamily(familyJungle);
        Avacado.addProduct(Food.Avacado.get(1), 1.0f);
        Avacado.setFamily(familyJungle);
        Nutmeg.addProduct(Food.Nutmeg.get(1), 1.0f);
        Nutmeg.setFamily(familyJungle);
        Allspice.addProduct(Food.Allspice.get(1), 1.0f);
        Allspice.setFamily(familyJungle);
        Chilli.addProduct(Food.Chilli.get(1), 1.0f);
        Chilli.setFamily(familyJungle);
        StarAnise.addProduct(Food.StarAnise.get(1), 1.0f);
        StarAnise.setFamily(familyJungle);
        Mango.addProduct(Food.Mango.get(1), 1.0f);
        Mango.setFamily(familyPome);
        Starfruit.addProduct(Food.Starfruit.get(1), 1.0f);
        Starfruit.setFamily(familyJungle);
        Candlenut.addProduct(Food.Candlenut.get(1), 1.0f);
        Candlenut.setFamily(familyJungle);
    }

    private void setFamily(IFruitFamily family) {
        this.family = family;
    }

    private ExtraTreeFruitGene(String name, int time, int unripe, int colour, FruitSprite index) {
        this.name = name;
        this.colour = colour;
        this.index = index;
        this.setRipening(time, unripe);
    }

    private ExtraTreeFruitGene(String name, FruitPod pod) {
        this.name = name;
        this.pod = pod;
        this.ripeningPeriod = 2;
    }

    public void setRipening(int time, int unripe) {
        this.ripeningPeriod = time;
        this.colourUnripe = unripe;
        this.isRipening = true;
        this.diffR = (this.colour >> 16 & 0xFF) - (unripe >> 16 & 0xFF);
        this.diffG = (this.colour >> 8 & 0xFF) - (unripe >> 8 & 0xFF);
        this.diffB = (this.colour & 0xFF) - (unripe & 0xFF);
    }

    public void addProduct(ItemStack product, float chance) {
        this.products.put(product, Float.valueOf(chance));
    }

    public String getUID() {
        return "extratrees.fruit." + this.toString().toLowerCase();
    }

    public boolean isDominant() {
        return true;
    }

    public IFruitProvider getProvider() {
        return this;
    }

    public ItemStack[] getProducts() {
        return this.products.keySet().toArray(new ItemStack[0]);
    }

    public ItemStack[] getSpecialty() {
        return new ItemStack[0];
    }

    public String getDescription() {
        return this.name;
    }

    public IFruitFamily getFamily() {
        return this.family;
    }

    public int getColour(ITreeGenome genome, IBlockAccess world, int x, int y, int z, int ripeningTime) {
        if (!this.isRipening) {
            return this.colour;
        }
        float stage = this.getRipeningStage(ripeningTime);
        int r = (this.colourUnripe >> 16 & 0xFF) + (int)((float)this.diffR * stage);
        int g = (this.colourUnripe >> 8 & 0xFF) + (int)((float)this.diffG * stage);
        int b = (this.colourUnripe & 0xFF) + (int)((float)this.diffB * stage);
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public boolean markAsFruitLeaf(ITreeGenome genome, World world, int x, int y, int z) {
        return this.pod == null;
    }

    public int getRipeningPeriod() {
        return this.ripeningPeriod;
    }

    public ItemStack[] getFruits(ITreeGenome genome, World world, int x, int y, int z, int ripeningTime) {
        if (this.pod != null) {
            if (ripeningTime >= 2) {
                ArrayList<ItemStack> product = new ArrayList<ItemStack>();
                for (Map.Entry<ItemStack, Float> entry : this.products.entrySet()) {
                    ItemStack single = entry.getKey().func_77946_l();
                    single.field_77994_a = 1;
                    for (int i = 0; i < entry.getKey().field_77994_a; ++i) {
                        if (!(world.field_73012_v.nextFloat() <= entry.getValue().floatValue())) continue;
                        product.add(single.func_77946_l());
                    }
                }
                return product.toArray(new ItemStack[0]);
            }
            return new ItemStack[0];
        }
        ArrayList<ItemStack> product = new ArrayList<ItemStack>();
        float stage = this.getRipeningStage(ripeningTime);
        if (stage < 0.5f) {
            return new ItemStack[0];
        }
        float modeYieldMod = 1.0f;
        for (Map.Entry<ItemStack, Float> entry : this.products.entrySet()) {
            if (!(world.field_73012_v.nextFloat() <= genome.getYield() * modeYieldMod * entry.getValue().floatValue() * 5.0f * stage)) continue;
            product.add(entry.getKey().func_77946_l());
        }
        return product.toArray(new ItemStack[0]);
    }

    private float getRipeningStage(int ripeningTime) {
        if (ripeningTime >= this.ripeningPeriod) {
            return 1.0f;
        }
        return (float)ripeningTime / (float)this.ripeningPeriod;
    }

    public boolean requiresFruitBlocks() {
        return this.pod != null;
    }

    public boolean trySpawnFruitBlock(ITreeGenome genome, World world, int x, int y, int z) {
        if (this.pod == null) {
            return false;
        }
        if (world.field_73012_v.nextFloat() > genome.getSappiness()) {
            return false;
        }
        return Binnie.Genetics.getTreeRoot().setFruitBlock(world, (IAlleleFruit)genome.getActiveAllele(EnumTreeChromosome.FRUITS.ordinal()), genome.getSappiness(), this.pod.getTextures(), x, y, z);
    }

    public boolean setFruitBlock(World world, IAlleleFruit allele, float sappiness, int x, int y, int z) {
        return true;
    }

    public static int getDirectionalMetadata(World world, int x, int y, int z) {
        for (int i = 0; i < 4; ++i) {
            if (!ExtraTreeFruitGene.isValidPot(world, x, y, z, i)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isValidPot(World world, int x, int y, int z, int notchDirection) {
        int blockid = world.func_72798_a(x += Direction.field_71583_a[notchDirection], y, z += Direction.field_71581_b[notchDirection]);
        if (blockid == Block.field_71951_J.field_71990_ca) {
            return BlockLog.func_72141_e((int)world.func_72805_g(x, y, z)) == 3;
        }
        if (Block.field_71973_m[blockid] != null) {
            return Block.field_71973_m[blockid].isWood(world, x, y, z);
        }
        return false;
    }

    public short getIconIndex(ITreeGenome genome, IBlockAccess world, int x, int y, int z, int ripeningTime, boolean fancy) {
        return this.index.getIndex();
    }

    public void registerIcons(IconRegister register) {
        if (this.ordinal() == 0) {
            FruitSprite.Average.registerIcons(register);
        }
    }

    public String getName() {
        return this.getDescription();
    }

    public String getNameOfFruit() {
        if (this == Apple) {
            return "Apple";
        }
        for (ItemStack stack : this.products.keySet()) {
            if (stack.func_77973_b() != ExtraTrees.itemFood) continue;
            return Food.values()[stack.func_77960_j()].toString();
        }
        return "NoFruit";
    }
}

