/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.gen;

import binnie.extratrees.gen.WorldGenTree;
import forestry.api.arboriculture.ITree;

public class WorldGenConifer {

    public static class MonkeyPuzzle
    extends WorldGenTree {
        public MonkeyPuzzle(ITree tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height + 2;
            float bottom = this.randBetween(2, 3);
            float width = (float)this.height * this.randBetween(0.4f, 0.45f);
            if (width > 7.0f) {
                width = 7.0f;
            }
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), 0.35f * width, 1, this.leaf, false);
            float f2 = leafSpawn;
            leafSpawn = f2 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f2, 0.0f), 0.55f * width, 1, this.leaf, false);
            float f3 = leafSpawn;
            leafSpawn = f3 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f3, 0.0f), 0.75f * width, 1, this.leaf, false);
            float f4 = leafSpawn;
            leafSpawn = f4 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f4, 0.0f), 0.9f * width, 1, this.leaf, false);
            float f5 = leafSpawn;
            leafSpawn = f5 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f5, 0.0f), 1.0f * width, 1, this.leaf, false);
            float f6 = leafSpawn;
            leafSpawn = f6 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f6, 0.0f), 0.5f * width, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(9, 2);
            this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
        }
    }

    public static class LoblollyPine
    extends WorldGenTree {
        public LoblollyPine(ITree tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height + 2;
            float bottom = (float)this.height * this.randBetween(0.65f, 0.7f);
            float width = (float)this.height * this.randBetween(0.25f, 0.3f);
            if (width > 7.0f) {
                width = 7.0f;
            }
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), 0.6f * width, 1, this.leaf, false);
            while (leafSpawn > bottom) {
                float f2 = leafSpawn;
                leafSpawn = f2 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f2, 0.0f), width, 1, this.leaf, false);
            }
            float f3 = leafSpawn;
            leafSpawn = f3 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f3, 0.0f), 0.7f * width, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(6, 2);
            this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
        }
    }

    public static class Cedar
    extends WorldGenTree {
        public Cedar(ITree tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height + 3;
            float bottom = this.randBetween(2, 3);
            float width = (float)this.height * this.randBetween(0.7f, 0.75f);
            if (width > 7.0f) {
                width = 7.0f;
            }
            float coneHeight = leafSpawn - bottom;
            while (leafSpawn > bottom) {
                float f = leafSpawn;
                leafSpawn = f - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), this.girth, 1, this.leaf, false);
            }
            for (leafSpawn = (float)(this.height + 3); leafSpawn > bottom; leafSpawn += (float)(1 + this.rand.nextInt(2))) {
                float cone = 1.0f - (leafSpawn - bottom) / coneHeight;
                float radius = (0.7f + this.rand.nextFloat() * 0.3f) * width;
                float xOffset = (-width + this.rand.nextFloat() * 2.0f * width) / 2.0f;
                float yOffset = (-width + this.rand.nextFloat() * 2.0f * width) / 2.0f;
                cone *= 2.0f - cone;
                xOffset *= cone;
                yOffset *= cone;
                if ((radius *= cone) < 2.0f) {
                    radius = 2.0f;
                }
                if (xOffset > radius / 2.0f) {
                    xOffset = radius / 2.0f;
                }
                if (yOffset > radius / 2.0f) {
                    yOffset = radius / 2.0f;
                }
                float f = leafSpawn;
                leafSpawn = f - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(xOffset, f, yOffset), 0.7f * radius, 1, this.leaf, false);
                float f2 = leafSpawn;
                leafSpawn = f2 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(xOffset, f2, yOffset), radius, 1, this.leaf, false);
                float f3 = leafSpawn;
                leafSpawn = f3 - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(xOffset, f3, yOffset), 0.5f * radius, 1, this.leaf, false);
            }
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), 0.7f * width, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(6, 2);
            this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
        }
    }

    public static class Yew
    extends WorldGenTree {
        public Yew(ITree tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height + 2;
            float bottom = this.randBetween(1, 2);
            float width = (float)this.height * this.randBetween(0.7f, 0.75f);
            if (width > 7.0f) {
                width = 7.0f;
            }
            float coneHeight = leafSpawn - bottom;
            while (leafSpawn > bottom) {
                float radius = 1.0f - (leafSpawn - bottom) / coneHeight;
                radius *= 2.0f - radius;
                float f = leafSpawn;
                leafSpawn = f - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), radius *= width, 1, this.leaf, false);
            }
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), 0.7f * width, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(5, 2);
            this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
        }
    }

    public static class Cypress
    extends WorldGenTree {
        public Cypress(ITree tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height + 2;
            float bottom = 1.0f;
            float width = (float)this.height * this.randBetween(0.15f, 0.2f);
            if (width > 7.0f) {
                width = 7.0f;
            }
            float coneHeight = leafSpawn - bottom;
            while (leafSpawn > bottom) {
                float radius = 1.0f - (leafSpawn - bottom) / coneHeight;
                radius *= width - 1.0f;
                float f = leafSpawn;
                leafSpawn = f - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), radius += 1.0f, 1, this.leaf, false);
            }
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), 0.7f * width, 1, this.leaf, false);
            float f2 = leafSpawn;
            leafSpawn = f2 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f2, 0.0f), 0.4f * width, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(6, 2);
            this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
        }
    }

    public static class WesternHemlock
    extends WorldGenTree {
        public WesternHemlock(ITree tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            float leafSpawn = this.height + 6;
            float bottom = this.randBetween(2, 3);
            float width = (float)this.height / this.randBetween(2.0f, 2.5f);
            if (width > 7.0f) {
                width = 7.0f;
            }
            float coneHeight = leafSpawn - bottom;
            while (leafSpawn > bottom) {
                float radius = 1.0f - (leafSpawn - bottom) / coneHeight;
                float f = leafSpawn;
                leafSpawn = f - 1.0f;
                this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), radius *= width, 1, this.leaf, false);
            }
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), 0.7f * width, 1, this.leaf, false);
            float f2 = leafSpawn;
            leafSpawn = f2 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f2, 0.0f), 0.4f * width, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(7, 3);
            this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
        }
    }
}

