/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.core;

import binnie.core.BinnieCore;
import binnie.core.plugin.IBinnieModule;
import binnie.extratrees.api.CarpentryManager;
import binnie.extratrees.api.ICarpentryWood;
import binnie.extratrees.api.IDesign;
import binnie.extratrees.block.ILogType;
import binnie.extratrees.block.PlankType;
import binnie.extratrees.carpentry.EnumPattern;
import binnie.extratrees.genetics.ExtraTreeFruitGene;
import binnie.extratrees.genetics.ExtraTreeSpecies;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;

public class ModuleCore
implements IBinnieModule {
    @Override
    public void preInit() {
    }

    @Override
    public void doInit() {
    }

    @Override
    public void postInit() {
        if (BinnieCore.proxy.isDebug()) {
            try {
                String img;
                String img2;
                PrintWriter outputSpecies = new PrintWriter(new FileWriter("data/species.html"));
                PrintWriter outputLogs = new PrintWriter(new FileWriter("data/logs.html"));
                PrintWriter outputPlanks = new PrintWriter(new FileWriter("data/planks.html"));
                PrintWriter outputFruit = new PrintWriter(new FileWriter("data/fruit.html"));
                PrintWriter outputDesigns = new PrintWriter(new FileWriter("data/designs.html"));
                LinkedList<ExtraTreeSpecies> speciesQueue = new LinkedList<ExtraTreeSpecies>();
                for (ExtraTreeSpecies s : ExtraTreeSpecies.values()) {
                    speciesQueue.add(s);
                }
                LinkedList<ILogType.ExtraTreeLog> logQueue = new LinkedList<ILogType.ExtraTreeLog>();
                for (ILogType.ExtraTreeLog wood : ILogType.ExtraTreeLog.values()) {
                    logQueue.add(wood);
                }
                LinkedList<PlankType.ExtraTreePlanks> plankQueue = new LinkedList<PlankType.ExtraTreePlanks>();
                for (PlankType.ExtraTreePlanks wood : PlankType.ExtraTreePlanks.values()) {
                    plankQueue.add(wood);
                }
                LinkedList<ExtraTreeFruitGene> fruitQueue = new LinkedList<ExtraTreeFruitGene>();
                for (ExtraTreeFruitGene wood : ExtraTreeFruitGene.values()) {
                    fruitQueue.add(wood);
                }
                LinkedList<IDesign> designQueue = new LinkedList<IDesign>();
                for (IDesign wood : CarpentryManager.carpentryInterface.getSortedDesigns()) {
                    designQueue.add(wood);
                }
                fruitQueue.remove((Object)ExtraTreeFruitGene.Apple);
                outputSpecies.println("<table style=\"width: 100%;\">");
                while (!speciesQueue.isEmpty()) {
                    outputSpecies.println("<tr>");
                    for (int i = 0; i < 4; ++i) {
                        IAlleleTreeSpecies species = (IAlleleTreeSpecies)speciesQueue.poll();
                        outputSpecies.println("<td>" + (species == null ? "" : species.getName()) + "</td>");
                    }
                    outputSpecies.println("</tr>");
                }
                outputSpecies.println("</table>");
                outputLogs.println("<table style=\"width: 100%;\">");
                while (!logQueue.isEmpty()) {
                    outputLogs.println("<tr>");
                    for (int i = 0; i < 4; ++i) {
                        ILogType.ExtraTreeLog wood = (ILogType.ExtraTreeLog)logQueue.poll();
                        if (wood == null) {
                            outputLogs.println("<td></td>");
                            continue;
                        }
                        img2 = "<img alt=\"" + wood.getName() + "\" src=\"images/logs/" + wood.toString().toLowerCase() + "Bark.png\">";
                        outputLogs.println("<td>" + img2 + " " + wood.getName() + "</td>");
                    }
                    outputLogs.println("</tr>");
                }
                outputLogs.println("</table>");
                outputPlanks.println("<table style=\"width: 100%;\">");
                while (!plankQueue.isEmpty()) {
                    outputPlanks.println("<tr>");
                    for (int i = 0; i < 4; ++i) {
                        ICarpentryWood wood = (ICarpentryWood)plankQueue.poll();
                        if (wood == null) {
                            outputPlanks.println("<td></td>");
                            continue;
                        }
                        img2 = "<img alt=\"" + wood.getName() + "\" src=\"images/planks/" + wood.getName() + ".png\">";
                        outputPlanks.println("<td>" + img2 + " " + wood.getName() + "</td>");
                    }
                    outputPlanks.println("</tr>");
                }
                outputPlanks.println("</table>");
                outputFruit.println("<table style=\"width: 100%;\">");
                while (!fruitQueue.isEmpty()) {
                    outputFruit.println("<tr>");
                    for (int i = 0; i < 4; ++i) {
                        ExtraTreeFruitGene wood = (ExtraTreeFruitGene)((Object)fruitQueue.poll());
                        if (wood == null) {
                            outputFruit.println("<td></td>");
                            continue;
                        }
                        String fruit = wood.getNameOfFruit();
                        img = "<img alt=\"" + wood.getName() + "\" src=\"images/fruits/" + fruit + ".png\">";
                        outputFruit.println("<td>" + img + " " + wood.getName() + "</td>");
                    }
                    outputFruit.println("</tr>");
                }
                outputFruit.println("</table>");
                outputDesigns.println("<table style=\"width: 100%;\">");
                while (!designQueue.isEmpty()) {
                    outputDesigns.println("<tr>");
                    for (int i = 0; i < 4; ++i) {
                        IDesign wood = (IDesign)designQueue.poll();
                        if (wood == null) {
                            outputDesigns.println("<td></td>");
                            continue;
                        }
                        String texture = ((EnumPattern)wood.getTopPattern().getPattern()).toString().toLowerCase();
                        img = "<img alt=\"" + texture + "\" src=\"images/pattern/" + texture + ".png\">";
                        outputDesigns.println("<td>" + img + " " + wood.getName() + "</td>");
                    }
                    outputDesigns.println("</tr>");
                }
                outputDesigns.println("</table>");
                outputSpecies.close();
                outputLogs.close();
                outputPlanks.close();
                outputFruit.close();
                outputDesigns.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

