/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.mod.database;

import binnie.craftgui.controls.ControlText;
import binnie.craftgui.controls.ControlTextCentered;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.TopLevelWidget;
import binnie.craftgui.core.geometry.Area;
import binnie.craftgui.core.geometry.TextJustification;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.mod.database.ControlIndividualDisplay;
import binnie.craftgui.mod.database.DatabaseTab;
import binnie.craftgui.mod.database.EnumDiscoveryState;
import binnie.craftgui.mod.database.PageSpecies;
import forestry.api.genetics.IAlleleSpecies;

public class PageSpeciesOverview
extends PageSpecies {
    ControlText controlName;
    ControlText controlScientific;
    ControlText controlAuthority;
    ControlText controlComplexity;
    ControlText controlDescription;
    ControlText controlSignature;
    ControlIndividualDisplay controlInd1 = new ControlIndividualDisplay(this, 5, 5);
    ControlIndividualDisplay controlInd2 = new ControlIndividualDisplay(this, 123, 5);

    public PageSpeciesOverview(IWidget parent, DatabaseTab tab) {
        super(parent, tab);
        this.controlName = new ControlTextCentered((IWidget)this, 8.0f, "");
        this.controlScientific = new ControlTextCentered((IWidget)this, 32.0f, "");
        this.controlAuthority = new ControlTextCentered((IWidget)this, 44.0f, "");
        this.controlComplexity = new ControlTextCentered((IWidget)this, 56.0f, "");
        this.controlDescription = new ControlText(this, new Area(8.0f, 84.0f, this.getSize().x() - 16.0f, 0.0f), "", TextJustification.MiddleCenter);
        this.controlSignature = new ControlText(this, new Area(8.0f, 84.0f, this.getSize().x() - 16.0f, 0.0f), "", TextJustification.BottomRight);
    }

    @Override
    public void onValueChanged(IAlleleSpecies species) {
        this.controlInd1.setSpecies(species, EnumDiscoveryState.Show);
        this.controlInd2.setSpecies(species, EnumDiscoveryState.Show);
        String branchBinomial = species.getBranch() != null ? species.getBranch().getScientific() : "<Unknown>";
        String branchName = species.getBranch() != null ? species.getBranch().getName() : "Unknown";
        this.controlName.setValue("\u00a7n" + species.getName() + "\u00a7r");
        this.controlScientific.setValue("\u00a7o" + branchBinomial + " " + species.getBinomial() + "\u00a7r");
        this.controlAuthority.setValue("Discovered by \u00a7l" + species.getAuthority() + "\u00a7r");
        this.controlComplexity.setValue("Complexity: " + species.getComplexity());
        String desc = species.getDescription();
        String descBody = "\u00a7o";
        String descSig = "";
        if (desc == null || desc == "") {
            descBody = descBody + "No Description Provided.";
        } else {
            String[] descStrings = desc.split("\\|");
            descBody = descBody + descStrings[0];
            for (int i = 1; i < descStrings.length - 1; ++i) {
                descBody = descBody + " " + descStrings[i];
            }
            if (descStrings.length > 1) {
                descSig = descSig + descStrings[descStrings.length - 1];
            }
        }
        this.controlDescription.setValue(descBody + "\u00a7r");
        this.controlSignature.setValue(descSig + "\u00a7r");
        float descHeight = ((TopLevelWidget)Window.get(this)).getTextHeight(this.controlDescription.getValue(), this.controlDescription.getSize().x());
        this.controlSignature.setPosition(new Vector2f(this.controlSignature.pos().x(), this.controlDescription.getPosition().y() + descHeight + 10.0f));
    }
}

