/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.mod.database;

import binnie.core.genetics.BreedingSystem;
import binnie.craftgui.controls.core.Control;
import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.ITooltip;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.mod.database.WindowAbstractDatabase;
import binnie.craftgui.resource.ITexture;
import binnie.craftgui.resource.minecraft.CraftGUITextureSheet;
import binnie.craftgui.resource.minecraft.StandardTexture;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IMutation;

public class ControlMutationSymbol
extends Control
implements ITooltip {
    static ITexture MutationPlus = new StandardTexture(2, 94, 16, 16, CraftGUITextureSheet.Controls2.getTexture());
    static ITexture MutationArrow = new StandardTexture(20, 94, 32, 16, CraftGUITextureSheet.Controls2.getTexture());
    IMutation value = null;
    boolean discovered;
    int type;

    @Override
    public void onRenderBackground() {
        super.onRenderBackground();
        if (this.type == 0) {
            this.getRenderer().renderTexture((Object)MutationPlus, Vector2f.ZERO);
        } else {
            this.getRenderer().renderTexture((Object)MutationArrow, Vector2f.ZERO);
        }
    }

    protected ControlMutationSymbol(IWidget parent, int x, int y, int type) {
        super(parent, x, y, 16 + type * 16, 16.0f);
        this.type = type;
        this.addAttribute(Attribute.MouseOver);
    }

    public void setValue(IMutation value) {
        this.value = value;
        boolean isNEI = ((WindowAbstractDatabase)this.getSuperParent()).isNEI();
        BreedingSystem system = ((WindowAbstractDatabase)this.getSuperParent()).getBreedingSystem();
        boolean bl = isNEI ? true : (this.discovered = system.isMutationDiscovered(value, ((Window)Window.get(this)).getWorld(), ((Window)Window.get(this)).getPlayer() == null ? "" : ((Window)Window.get((IWidget)this)).getPlayer().field_71092_bJ));
        if (this.discovered) {
            this.setColour(0xFFFFFF);
        } else {
            this.setColour(0x777777);
        }
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        if (this.type == 1 && this.discovered) {
            IAllele species1 = this.value.getAllele0();
            IAllele species2 = this.value.getAllele1();
            BreedingSystem system = ((WindowAbstractDatabase)this.getSuperParent()).getBreedingSystem();
            float chance = system.getChance(this.value, ((Window)Window.get(this)).getPlayer(), species1, species2);
            tooltip.add("Current Chance - " + chance + "%");
            if (this.value.getSpecialConditions() != null) {
                for (String string : this.value.getSpecialConditions()) {
                    tooltip.add(string);
                }
            }
        }
    }
}

