/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.extrabees.database;

import binnie.core.Binnie;
import binnie.craftgui.controls.core.Control;
import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.ITooltip;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.geometry.Area;
import binnie.craftgui.resource.minecraft.CraftGUITexture;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.EnumTolerance;
import java.util.ArrayList;
import java.util.List;

public class ControlClimateBar
extends Control
implements ITooltip {
    boolean isHumidity = false;
    List<Integer> tolerated = new ArrayList<Integer>();
    int[] tempColours = new int[]{65531, 7912447, 5242672, 0xFFFF00, 16753152, 0xFF0000};
    int[] humidColours = new int[]{16770979, 1769216, 3177727};

    public ControlClimateBar(IWidget parent, int x, int y, int width, int height) {
        super(parent, x, y, width, height);
        this.addAttribute(Attribute.MouseOver);
    }

    public ControlClimateBar(IWidget parent, int x, int y, int width, int height, boolean humidity) {
        super(parent, x, y, width, height);
        this.addAttribute(Attribute.MouseOver);
        this.isHumidity = true;
    }

    @Override
    public void getTooltip(Tooltip list) {
        if (this.tolerated.isEmpty()) {
            return;
        }
        int types = this.isHumidity ? 3 : 6;
        int type = (int)((float)((int)(this.getRelativeMousePosition().x() - 1.0f)) / ((this.getSize().x() - 2.0f) / (float)types));
        if (!this.tolerated.contains(type)) {
            return;
        }
        if (type < types) {
            if (this.isHumidity) {
                list.add(EnumHumidity.values()[type].name);
            } else {
                list.add(EnumTemperature.values()[type + 1].name);
            }
        }
    }

    @Override
    public void onRenderBackground() {
        this.getRenderer().renderTexture((Object)CraftGUITexture.EnergyBarBack, this.getArea());
        int types = this.isHumidity ? 3 : 6;
        int w = (int)((this.getSize().x() - 2.0f) / (float)types);
        for (int i = 0; i < types; ++i) {
            int x = i * w;
            if (!this.tolerated.contains(i)) continue;
            int colour = 0;
            colour = this.isHumidity ? this.humidColours[i] : this.tempColours[i];
            this.getRenderer().renderSolidArea(new Area(x + 1, 1.0f, w, this.getSize().y() - 2.0f), colour);
        }
        this.getRenderer().renderTexture((Object)CraftGUITexture.EnergyBarGlass, this.getArea());
    }

    public void setSpecies(IAlleleBeeSpecies species) {
        EnumTolerance tolerance;
        int main;
        this.tolerated.clear();
        if (species == null) {
            return;
        }
        if (!this.isHumidity) {
            main = species.getTemperature().ordinal() - 1;
            IBeeGenome genome = Binnie.Genetics.getBeeRoot().templateAsGenome(Binnie.Genetics.getBeeRoot().getTemplate(species.getUID()));
            tolerance = genome.getToleranceTemp();
        } else {
            main = species.getHumidity().ordinal();
            IBeeGenome genome = Binnie.Genetics.getBeeRoot().templateAsGenome(Binnie.Genetics.getBeeRoot().getTemplate(species.getUID()));
            tolerance = genome.getToleranceHumid();
        }
        this.tolerated.add(main);
        switch (tolerance) {
            case BOTH_5: 
            case UP_5: {
                this.tolerated.add(main + 5);
            }
            case BOTH_4: 
            case UP_4: {
                this.tolerated.add(main + 4);
            }
            case BOTH_3: 
            case UP_3: {
                this.tolerated.add(main + 3);
            }
            case BOTH_2: 
            case UP_2: {
                this.tolerated.add(main + 2);
            }
            case BOTH_1: 
            case UP_1: {
                this.tolerated.add(main + 1);
            }
        }
        switch (tolerance) {
            case BOTH_5: 
            case DOWN_5: {
                this.tolerated.add(main - 5);
            }
            case BOTH_4: 
            case DOWN_4: {
                this.tolerated.add(main - 4);
            }
            case BOTH_3: 
            case DOWN_3: {
                this.tolerated.add(main - 3);
            }
            case BOTH_2: 
            case DOWN_2: {
                this.tolerated.add(main - 2);
            }
            case BOTH_1: 
            case DOWN_1: {
                this.tolerated.add(main - 1);
            }
        }
    }
}

