/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.extrabees.database;

import binnie.core.Binnie;
import binnie.core.BinnieCore;
import binnie.craftgui.controls.core.Control;
import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.ITooltip;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.geometry.Area;
import binnie.craftgui.resource.minecraft.CraftGUITexture;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.biome.BiomeGenBase;

public class ControlBiomes
extends Control
implements ITooltip {
    List<Integer> tolerated = new ArrayList<Integer>();

    public ControlBiomes(IWidget parent, int x, int y, int width, int height) {
        super(parent, x, y, width * 16, height * 16);
        this.addAttribute(Attribute.MouseOver);
    }

    @Override
    public void getTooltip(Tooltip list) {
        int y;
        if (this.tolerated.isEmpty()) {
            return;
        }
        int x = (int)(this.getRelativeMousePosition().x() / 16.0f);
        int i = x + (y = (int)(this.getRelativeMousePosition().y() / 16.0f)) * 8;
        if (i < this.tolerated.size()) {
            list.add(BiomeGenBase.field_76773_a[this.tolerated.get((int)i).intValue()].field_76791_y);
        }
    }

    @Override
    public void onRenderForeground() {
        for (int i = 0; i < this.tolerated.size(); ++i) {
            int x = i % 8 * 16;
            int y = i / 8 * 16;
            if (BiomeGenBase.field_76773_a[i] != null) {
                this.getRenderer().setColour(BiomeGenBase.field_76773_a[i].field_76790_z);
            }
            this.getRenderer().renderTexture((Object)CraftGUITexture.Button, new Area(x, y, 16.0f, 16.0f));
        }
    }

    public void setSpecies(IAlleleBeeSpecies species) {
        this.tolerated.clear();
        if (species == null) {
            return;
        }
        IBeeGenome genome = Binnie.Genetics.getBeeRoot().templateAsGenome(Binnie.Genetics.getBeeRoot().getTemplate(species.getUID()));
        IBee bee = Binnie.Genetics.getBeeRoot().getBee(BinnieCore.proxy.getWorld(), genome);
        this.tolerated.addAll(bee.getSuitableBiomeIds());
    }
}

