/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.events.core;

import binnie.craftgui.core.IWidget;
import binnie.craftgui.events.Event;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@Retention(value=RetentionPolicy.RUNTIME)
public @interface EventHandler {
    public Origin origin() default Origin.Any;

    public static enum Origin {
        Any,
        Self,
        DirectChild,
        Parent,
        SuperParent;


        public boolean handlesEvent(IWidget widget, Event event) {
            IWidget origin = event.getOrigin();
            switch (this) {
                case Any: {
                    return true;
                }
                case DirectChild: {
                    for (IWidget child : widget.getWidgets()) {
                        if (child != origin) continue;
                        return true;
                    }
                    return false;
                }
                case Parent: {
                    return origin == widget.getParent();
                }
                case Self: {
                    return origin == widget;
                }
                case SuperParent: {
                    return origin == widget.getSuperParent();
                }
            }
            return false;
        }
    }
}

