/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.controls.tab;

import binnie.craftgui.controls.core.Control;
import binnie.craftgui.controls.core.IControlValue;
import binnie.craftgui.controls.tab.ControlTabBar;
import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.ITooltip;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.geometry.Position;
import binnie.craftgui.events.EventMouse;
import binnie.craftgui.events.EventValueChanged;
import binnie.craftgui.events.core.EventHandler;

public class ControlTab<T>
extends Control
implements ITooltip,
IControlValue<T> {
    private ControlTabBar<T> tabBar;
    private T value;

    @EventHandler(origin=EventHandler.Origin.Self)
    public void onMouseClick(EventMouse.Down event) {
        this.callEvent(new EventValueChanged<T>(this, this.value));
    }

    public ControlTab(ControlTabBar<T> parent, float x, float y, float w, float h, T value) {
        super(parent, x, y, w, h);
        this.setValue(value);
        this.tabBar = parent;
        this.addAttribute(Attribute.MouseOver);
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        tooltip.add(this.value.toString());
        if (this.value instanceof ITooltip) {
            ((ITooltip)this.value).getTooltip(tooltip);
        }
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        this.value = value;
    }

    public boolean isCurrentSelection() {
        return this.getValue() != null && this.getValue().equals(this.tabBar.getValue());
    }

    public Position getTabPosition() {
        return this.tabBar.position;
    }
}

