/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.triggers;

import binnie.core.machines.Machine;
import binnie.core.machines.power.IPoweredMachine;
import binnie.core.triggers.BinnieTrigger;
import binnie.core.triggers.TriggerData;

public class TriggerPower {
    public static TriggerData powerNone(Object tile) {
        return new TriggerData(BinnieTrigger.triggerPowerNone, TriggerPower.getPercentage(tile) < (double)0.05f);
    }

    public static TriggerData powerLow(Object tile) {
        return new TriggerData(BinnieTrigger.triggerPowerLow, TriggerPower.getPercentage(tile) < (double)0.35f);
    }

    public static TriggerData powerMedium(Object tile) {
        double p = TriggerPower.getPercentage(tile);
        return new TriggerData(BinnieTrigger.triggerPowerMedium, p >= (double)0.35f && p <= (double)0.65f);
    }

    public static TriggerData powerHigh(Object tile) {
        double p = TriggerPower.getPercentage(tile);
        return new TriggerData(BinnieTrigger.triggerPowerHigh, TriggerPower.getPercentage(tile) > (double)0.65f);
    }

    public static TriggerData powerFull(Object tile) {
        double p = TriggerPower.getPercentage(tile);
        return new TriggerData(BinnieTrigger.triggerPowerFull, TriggerPower.getPercentage(tile) > (double)0.95f);
    }

    private static double getPercentage(Object tile) {
        IPoweredMachine process = Machine.getInterface(IPoweredMachine.class, tile);
        if (process != null) {
            double percentage = process.getPowerHandler().getEnergyStored() / process.getPowerHandler().getMaxEnergyStored();
            return percentage;
        }
        return 0.0;
    }
}

