/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.config;

import binnie.core.config.BinnieConfiguration;
import binnie.core.config.ConfigProperty;
import binnie.core.config.ConfigurationManager;
import binnie.core.config.PropertyBase;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import net.minecraftforge.common.Property;

@Retention(value=RetentionPolicy.RUNTIME)
@ConfigProperty.Type(propertyClass=PropertyItemID.class, category="item")
public @interface PropItemID {
    public String name();

    public static class PropertyItemID
    extends PropertyBase<Integer, PropItemID> {
        public PropertyItemID(Field field, BinnieConfiguration file, ConfigProperty configProperty, PropItemID annotedProperty) throws IllegalArgumentException, IllegalAccessException {
            super(field, file, configProperty, annotedProperty);
            ConfigurationManager.addItemID(this.getConfigValue(), configProperty.key(), file);
        }

        @Override
        protected Property getProperty() {
            return this.file.getItem(this.getCategory(), this.getKey(), ((Integer)this.defaultValue).intValue());
        }

        @Override
        protected Integer getConfigValue() {
            return this.property.getInt(((Integer)this.defaultValue).intValue());
        }

        @Override
        protected void addComments() {
            this.addComment("Item ID for " + ((PropItemID)this.annotatedProperty).name() + ".");
            this.addComment("Default ID is " + this.defaultValue + ".");
        }
    }
}

