/*
 * Decompiled with CFR 0.152.
 */
package invtweaks.forge.asm;

import com.google.common.io.Resources;
import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class RemappingAccessTransformer
implements IClassTransformer {
    private static final int REMOVE_ALL_ACCESS = -8;
    private Set<String> alteredClasses = new HashSet<String>();
    private Map<String, List<MemberInfo>> alterationData = new HashMap<String, List<MemberInfo>>();

    public byte[] transform(String string, String string2, byte[] byArray) {
        List<MemberInfo> list;
        if (this.alteredClasses.contains(string2) && (list = this.alterationData.get(string2)) != null) {
            String string3;
            MemberInfo memberInfo32;
            MemberInfo memberInfo2 = null;
            ArrayList<MemberInfo> arrayList = new ArrayList<MemberInfo>();
            ArrayList<MemberInfo> arrayList2 = new ArrayList<MemberInfo>();
            for (MemberInfo memberInfo32 : list) {
                switch (memberInfo32.type) {
                    case CLASS: {
                        memberInfo2 = memberInfo32;
                        break;
                    }
                    case FIELD: {
                        arrayList.add(memberInfo32);
                        break;
                    }
                    case METHOD: {
                        arrayList2.add(memberInfo32);
                    }
                }
            }
            ClassReader classReader = new ClassReader(byArray);
            memberInfo32 = new ClassNode(262144);
            classReader.accept((ClassVisitor)memberInfo32, 0);
            if (memberInfo2 != null) {
                ((ClassNode)memberInfo32).access &= 0xFFFFFFF8;
                ((ClassNode)memberInfo32).access |= memberInfo2.desiredAccess;
            }
            if (((ClassNode)memberInfo32).fields != null && !arrayList.isEmpty()) {
                for (FieldNode fieldNode : ((ClassNode)memberInfo32).fields) {
                    string3 = FMLDeobfuscatingRemapper.INSTANCE.mapFieldName(string, fieldNode.name, fieldNode.desc);
                    for (MemberInfo object : arrayList) {
                        if (!string3.equals(object.memberName)) continue;
                        fieldNode.access &= 0xFFFFFFF8;
                        fieldNode.access |= object.desiredAccess;
                        switch (object.desiredFinal) {
                            case SETFINAL: {
                                fieldNode.access |= 0x10;
                                break;
                            }
                            case UNSETFINAL: {
                                fieldNode.access &= 0xFFFFFFEF;
                                break;
                            }
                        }
                    }
                }
            }
            if (((ClassNode)memberInfo32).methods != null && !arrayList2.isEmpty()) {
                for (FieldNode fieldNode : ((ClassNode)memberInfo32).methods) {
                    string3 = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(string, fieldNode.name, fieldNode.desc);
                    String string4 = FMLDeobfuscatingRemapper.INSTANCE.mapMethodDesc(fieldNode.desc);
                    for (MemberInfo memberInfo : arrayList2) {
                        if (!string3.equals(memberInfo.memberName) || !string4.equals(memberInfo.memberDesc)) continue;
                        fieldNode.access &= 0xFFFFFFF8;
                        fieldNode.access |= memberInfo.desiredAccess;
                    }
                }
            }
            ClassWriter classWriter = new ClassWriter(0);
            memberInfo32.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        return byArray;
    }

    protected void readFile(String string) {
        try {
            File file = new File(string);
            URL uRL = file.exists() ? file.toURI().toURL() : Resources.getResource((String)string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.commentChar(35);
            streamTokenizer.lowerCaseMode(false);
            streamTokenizer.wordChars(97, 122);
            streamTokenizer.wordChars(65, 90);
            streamTokenizer.wordChars(47, 47);
            streamTokenizer.wordChars(59, 59);
            streamTokenizer.wordChars(40, 41);
            streamTokenizer.wordChars(95, 95);
            streamTokenizer.wordChars(46, 46);
            streamTokenizer.wordChars(45, 45);
            streamTokenizer.whitespaceChars(32, 32);
            streamTokenizer.whitespaceChars(9, 9);
            streamTokenizer.eolIsSignificant(true);
            int n = 1;
            FinalState finalState = FinalState.UNDEFINED;
            MemberType memberType = MemberType.CLASS;
            String string2 = "";
            while (streamTokenizer.nextToken() != -1) {
                if (streamTokenizer.ttype == -3) {
                    if ("public".equals(streamTokenizer.sval)) {
                        n = 1;
                        continue;
                    }
                    if ("protetected".equals(streamTokenizer.sval)) {
                        n = 4;
                        continue;
                    }
                    if ("private".equals(streamTokenizer.sval)) {
                        n = 2;
                        continue;
                    }
                    if ("class".equals(streamTokenizer.sval)) {
                        memberType = MemberType.CLASS;
                        continue;
                    }
                    if ("field".equals(streamTokenizer.sval)) {
                        memberType = MemberType.FIELD;
                        continue;
                    }
                    if ("method".equals(streamTokenizer.sval)) {
                        memberType = MemberType.METHOD;
                        continue;
                    }
                    if ("final".equals(streamTokenizer.sval)) {
                        finalState = FinalState.SETFINAL;
                        continue;
                    }
                    if ("-final".equals(streamTokenizer.sval)) {
                        finalState = FinalState.UNSETFINAL;
                        continue;
                    }
                    string2 = streamTokenizer.sval;
                    continue;
                }
                if (streamTokenizer.ttype != 10) continue;
                this.processEntry(n, memberType, string2, finalState);
                string2 = "";
                finalState = FinalState.UNDEFINED;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void processEntry(int n, MemberType memberType, String string, FinalState finalState) {
        if (!string.isEmpty()) {
            switch (memberType) {
                case CLASS: {
                    this.alteredClasses.add(string);
                    List<MemberInfo> list = this.alterationData.get(string);
                    if (list == null) {
                        list = new ArrayList<MemberInfo>();
                        this.alterationData.put(string, list);
                    }
                    list.add(new MemberInfo(string, n, finalState));
                    break;
                }
                case FIELD: {
                    int n2 = string.lastIndexOf(46);
                    String string2 = string.substring(0, n2);
                    String string3 = string.substring(n2 + 1);
                    this.alteredClasses.add(string2);
                    List<MemberInfo> list = this.alterationData.get(string2);
                    if (list == null) {
                        list = new ArrayList<MemberInfo>();
                        this.alterationData.put(string2, list);
                    }
                    list.add(new MemberInfo(string2, string3, n, finalState));
                    break;
                }
                case METHOD: {
                    int n3 = string.lastIndexOf(46);
                    String string4 = string.substring(0, n3);
                    String string5 = string.substring(n3 + 1);
                    n3 = string5.indexOf(40);
                    String string6 = string5.substring(0, n3);
                    String string7 = string5.substring(n3);
                    this.alteredClasses.add(string4);
                    List<MemberInfo> list = this.alterationData.get(string4);
                    if (list == null) {
                        list = new ArrayList<MemberInfo>();
                        this.alterationData.put(string4, list);
                    }
                    list.add(new MemberInfo(string4, string6, string7, n, finalState));
                    break;
                }
            }
        }
    }

    private class MemberInfo {
        String classType;
        String memberName;
        String memberDesc;
        MemberType type = MemberType.CLASS;
        int desiredAccess = 1;
        FinalState desiredFinal = FinalState.UNDEFINED;

        MemberInfo(String string, int n, FinalState finalState) {
            this.classType = string;
            this.desiredAccess = n;
            this.desiredFinal = finalState;
        }

        MemberInfo(String string, String string2, int n, FinalState finalState) {
            this.classType = string;
            this.memberName = string2;
            this.desiredAccess = n;
            this.desiredFinal = finalState;
            this.type = MemberType.FIELD;
        }

        MemberInfo(String string, String string2, String string3, int n, FinalState finalState) {
            this.classType = string;
            this.memberName = string2;
            this.memberDesc = string3;
            this.desiredAccess = n;
            this.desiredFinal = finalState;
            this.type = MemberType.METHOD;
        }
    }

    private static enum FinalState {
        UNDEFINED,
        SETFINAL,
        UNSETFINAL;

    }

    private static enum MemberType {
        CLASS,
        FIELD,
        METHOD;

    }
}

