/*
 * Decompiled with CFR 0.152.
 */
package invtweaks.forge.asm;

import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ASMHelper {
    public static void generateBooleanMethodConst(ClassNode classNode, String string, boolean bl) {
        MethodNode methodNode = new MethodNode(262144, 4097, string, "()Z", null, null);
        InsnList insnList = methodNode.instructions;
        insnList.add((AbstractInsnNode)new InsnNode(bl ? 4 : 3));
        insnList.add((AbstractInsnNode)new InsnNode(172));
        classNode.methods.add(methodNode);
    }

    public static void generateIntegerMethodConst(ClassNode classNode, String string, short s) {
        MethodNode methodNode = new MethodNode(262144, 4097, string, "()I", null, null);
        InsnList insnList = methodNode.instructions;
        if (s >= -128 && s <= 127) {
            insnList.add((AbstractInsnNode)new IntInsnNode(16, (int)s));
        } else {
            insnList.add((AbstractInsnNode)new IntInsnNode(17, (int)s));
        }
        insnList.add((AbstractInsnNode)new InsnNode(172));
        classNode.methods.add(methodNode);
    }

    public static void generateSelfForwardingMethod(ClassNode classNode, String string, String string2, Type type) {
        MethodNode methodNode = new MethodNode(262144, 4097, string, "()" + type.getDescriptor(), null, null);
        ASMHelper.populateSelfForwardingMethod(methodNode, string2, type, Type.getObjectType((String)classNode.name));
        classNode.methods.add(methodNode);
    }

    public static void generateStaticForwardingMethod(ClassNode classNode, String string, String string2, Type type, Type type2) {
        MethodNode methodNode = new MethodNode(262144, 4105, string, "()" + type.getDescriptor(), null, null);
        ASMHelper.populateSelfForwardingMethod(methodNode, string2, type, type2);
        classNode.methods.add(methodNode);
    }

    public static void generateForwardingToStaticMethod(ClassNode classNode, String string, String string2, Type type, Type type2) {
        MethodNode methodNode = new MethodNode(262144, 4097, string, "()" + type.getDescriptor(), null, null);
        ASMHelper.populateForwardingToStaticMethod(methodNode, string2, type, Type.getObjectType((String)classNode.name), type2);
        classNode.methods.add(methodNode);
    }

    public static void generateForwardingToStaticMethod(ClassNode classNode, String string, String string2, Type type, Type type2, Type type3) {
        MethodNode methodNode = new MethodNode(262144, 4097, string, "()" + type.getDescriptor(), null, null);
        ASMHelper.populateForwardingToStaticMethod(methodNode, string2, type, type3, type2);
        classNode.methods.add(methodNode);
    }

    public static void replaceSelfForwardingMethod(MethodNode methodNode, String string, Type type) {
        Type type2 = Type.getMethodType((String)methodNode.desc);
        methodNode.instructions.clear();
        ASMHelper.populateSelfForwardingMethod(methodNode, string, type2.getReturnType(), type);
    }

    public static void generateForwardingMethod(ClassNode classNode, String string, String string2, Type type, Type type2) {
        MethodNode methodNode = new MethodNode(262144, 4097, string, "()" + type.getDescriptor(), null, null);
        ASMHelper.populateForwardingMethod(methodNode, string2, type, type2, Type.getObjectType((String)classNode.name));
        classNode.methods.add(methodNode);
    }

    public static void replaceForwardingMethod(MethodNode methodNode, String string, Type type) {
        Type type2 = Type.getMethodType((String)methodNode.desc);
        methodNode.instructions.clear();
        ASMHelper.populateForwardingMethod(methodNode, string, type2.getReturnType(), type2.getArgumentTypes()[0], type);
    }

    public static void populateForwardingToStaticMethod(MethodNode methodNode, String string, Type type, Type type2, Type type3) {
        InsnList insnList = methodNode.instructions;
        insnList.add((AbstractInsnNode)new VarInsnNode(type2.getOpcode(21), 0));
        insnList.add((AbstractInsnNode)new MethodInsnNode(184, type3.getInternalName(), string, Type.getMethodDescriptor((Type)type, (Type[])new Type[]{type2})));
        insnList.add((AbstractInsnNode)new InsnNode(type.getOpcode(172)));
    }

    public static void populateSelfForwardingMethod(MethodNode methodNode, String string, Type type, Type type2) {
        InsnList insnList = methodNode.instructions;
        insnList.add((AbstractInsnNode)new VarInsnNode(type2.getOpcode(21), 0));
        insnList.add((AbstractInsnNode)new MethodInsnNode(182, type2.getInternalName(), string, "()" + type.getDescriptor()));
        insnList.add((AbstractInsnNode)new InsnNode(type.getOpcode(172)));
    }

    public static void populateForwardingMethod(MethodNode methodNode, String string, Type type, Type type2, Type type3) {
        InsnList insnList = methodNode.instructions;
        insnList.add((AbstractInsnNode)new VarInsnNode(type2.getOpcode(21), 1));
        insnList.add((AbstractInsnNode)new MethodInsnNode(182, type2.getInternalName(), string, "()" + type.getDescriptor()));
        insnList.add((AbstractInsnNode)new InsnNode(type.getOpcode(172)));
    }
}

