/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.utils;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import mrtjp.projectred.core.utils.OpenGLLib;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.input.Mouse;

public class DirectionalRayTracer {
    private final double negX;
    private final double negY;
    private final double negZ;
    private final double posX;
    private final double posY;
    private final double posZ;

    public DirectionalRayTracer(double negX, double negY, double negZ, double posX, double posY, double posZ) {
        this.negX = negX;
        this.negY = negY;
        this.negZ = negZ;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public DirectionalRayTracer(double halfSize) {
        this.negY = this.negZ = -halfSize;
        this.negX = this.negZ;
        this.posY = this.posZ = halfSize;
        this.posX = this.posZ;
    }

    private static atc getMouseVector(float z2) {
        return OpenGLLib.unproject(Mouse.getX(), Mouse.getY(), z2);
    }

    private atc calculateXPoint(atc near, atc diff, double x) {
        double p = (x - near.c) / diff.c;
        double y = near.d + diff.d * p;
        double z2 = near.e + diff.e * p;
        if (this.negY <= y && y <= this.posY && this.negZ <= z2 && z2 <= this.posZ) {
            return atc.a((double)x, (double)y, (double)z2);
        }
        return null;
    }

    private atc calculateYPoint(atc near, atc diff, double y) {
        double p = (y - near.d) / diff.d;
        double x = near.c + diff.c * p;
        double z2 = near.e + diff.e * p;
        if (this.negX <= x && x <= this.posX && this.negZ <= z2 && z2 <= this.posZ) {
            return atc.a((double)x, (double)y, (double)z2);
        }
        return null;
    }

    private atc calculateZPoint(atc near, atc diff, double z2) {
        double p = (z2 - near.e) / diff.e;
        double x = near.c + diff.c * p;
        double y = near.d + diff.d * p;
        if (this.negX <= x && x <= this.posX && this.negY <= y && y <= this.posY) {
            return atc.a((double)x, (double)y, (double)z2);
        }
        return null;
    }

    private static void addPoint(Map<ForgeDirection, atc> map, ForgeDirection side, atc value) {
        if (value != null) {
            map.put(side, value);
        }
    }

    private Map<ForgeDirection, atc> calculateHitPoints(atc near, atc far) {
        atc diff = far.a(near);
        EnumMap result = Maps.newEnumMap(ForgeDirection.class);
        DirectionalRayTracer.addPoint(result, ForgeDirection.WEST, this.calculateXPoint(near, diff, this.negX));
        DirectionalRayTracer.addPoint(result, ForgeDirection.EAST, this.calculateXPoint(near, diff, this.posX));
        DirectionalRayTracer.addPoint(result, ForgeDirection.DOWN, this.calculateYPoint(near, diff, this.negY));
        DirectionalRayTracer.addPoint(result, ForgeDirection.UP, this.calculateYPoint(near, diff, this.posY));
        DirectionalRayTracer.addPoint(result, ForgeDirection.NORTH, this.calculateZPoint(near, diff, this.negZ));
        DirectionalRayTracer.addPoint(result, ForgeDirection.SOUTH, this.calculateZPoint(near, diff, this.posZ));
        return result;
    }

    public Map<ForgeDirection, atc> calculateMouseHits() {
        OpenGLLib.updateMatrices();
        atc near = DirectionalRayTracer.getMouseVector(0.0f);
        atc far = DirectionalRayTracer.getMouseVector(1.0f);
        return this.calculateHitPoints(near, far);
    }

    public HitCoord getNearestHit() {
        OpenGLLib.updateMatrices();
        atc near = DirectionalRayTracer.getMouseVector(0.0f);
        atc far = DirectionalRayTracer.getMouseVector(1.0f);
        Map<ForgeDirection, atc> hits = this.calculateHitPoints(near, far);
        if (hits.isEmpty()) {
            return null;
        }
        ForgeDirection minForgeDirection = null;
        double minDist = Double.MAX_VALUE;
        for (Map.Entry<ForgeDirection, atc> e : hits.entrySet()) {
            double dist = e.getValue().a(near).b();
            if (!(dist < minDist)) continue;
            minDist = dist;
            minForgeDirection = e.getKey();
        }
        if (minForgeDirection == null) {
            return null;
        }
        return new HitCoord(minForgeDirection, hits.get(minForgeDirection));
    }

    public static class HitCoord {
        public final ForgeDirection side;
        public final atc coord;

        public HitCoord(ForgeDirection side, atc coord) {
            this.side = side;
            this.coord = coord;
        }
    }
}

