/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.inventory;

import codechicken.core.gui.GuiDraw;
import codechicken.lib.render.FontUtils;
import java.util.ArrayList;
import java.util.List;
import mrtjp.projectred.core.PRColors;
import mrtjp.projectred.core.inventory.GhostWidget;
import mrtjp.projectred.core.utils.ItemKeyStack;
import org.lwjgl.opengl.GL11;

public class WidgetItemSelection
extends GhostWidget {
    int rows;
    int columns;
    int squareSize = 20;
    int currentPage = 0;
    int pagesNeeded = 0;
    boolean waitingForList = true;
    boolean downloadFinished = false;
    private ItemKeyStack selection = null;
    private ItemKeyStack hover = null;
    private int xLast;
    private int yLast;
    private String filter = "";
    public List<ItemKeyStack> displayList = new ArrayList<ItemKeyStack>();
    protected bgw renderItem = new bgw();

    public ItemKeyStack getSelection() {
        return this.selection;
    }

    public WidgetItemSelection(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.rows = height / this.squareSize;
        this.columns = width / this.squareSize;
    }

    public void setDisplayList(List<ItemKeyStack> list) {
        this.displayList = list;
        this.waitingForList = false;
        this.currentPage = 0;
    }

    public void setNewFilter(String filt) {
        this.filter = filt;
        this.yLast = -1;
        this.xLast = -1;
        this.currentPage = 0;
    }

    public void pageUp() {
        ++this.currentPage;
        if (this.currentPage > this.pagesNeeded) {
            this.currentPage = this.pagesNeeded;
        }
    }

    public void pageDown() {
        --this.currentPage;
        if (this.currentPage < 0) {
            this.currentPage = 0;
        }
    }

    public void resetDownloadStats() {
        this.waitingForList = true;
        this.downloadFinished = false;
    }

    private boolean filterAllows(ItemKeyStack stack) {
        return this.stringsCanSearch(stack.key().getName().toLowerCase(), this.filter.toLowerCase());
    }

    private int getSeachedCount() {
        int count = 0;
        for (ItemKeyStack stack : this.displayList) {
            if (!this.filterAllows(stack)) continue;
            ++count;
        }
        return count;
    }

    private boolean stringsCanSearch(String name, String filter) {
        boolean flag = true;
        for (String s : filter.split(" ")) {
            if (name.contains(s)) continue;
            flag = false;
        }
        return flag;
    }

    private void drawLoadingScreen() {
        int barSizeX = this.width / 2;
        long time = System.currentTimeMillis() / (long)(this.waitingForList ? 40 : 8);
        int percent = (int)(time % (long)barSizeX);
        if (!this.waitingForList && percent > barSizeX - 8) {
            this.downloadFinished = true;
        }
        int xStart = this.x + this.width / 2 - barSizeX / 2;
        int yStart = this.y + this.height / 3;
        FontUtils.drawCenteredString((String)"downloading data", (int)((this.x + this.width) / 2), (int)((this.y + this.height) / 3 + this.squareSize), (int)-15313551);
        int xSize = percent;
        int ySize = 9;
        avk.a((int)xStart, (int)yStart, (int)(xStart + xSize), (int)(yStart + ySize), (int)-15313551);
    }

    private void drawAllItems(int mx, int my2) {
        this.hover = null;
        this.selection = null;
        int xOffset = this.x - (this.squareSize - 2);
        int yOffset = this.y + 2;
        int renderPointerX = 1;
        int renderPointerY = 0;
        int itemNumber = 0;
        WidgetItemSelection.glItemPre();
        for (ItemKeyStack keystack : this.displayList) {
            if (!this.filterAllows(keystack) || ++itemNumber <= this.rows * this.columns * this.currentPage) continue;
            if (itemNumber > this.rows * this.columns * (this.currentPage + 1)) break;
            int localX = xOffset + renderPointerX * this.squareSize;
            int localY = yOffset + renderPointerY * this.squareSize;
            if (mx > localX && mx < localX + this.squareSize && my2 > localY && my2 < localY + this.squareSize) {
                this.hover = keystack;
            }
            if (this.xLast > localX && this.xLast < localX + this.squareSize && this.yLast > localY && this.yLast < localY + this.squareSize) {
                this.selection = keystack;
            }
            if (this.selection != null && this.selection.equals(keystack)) {
                WidgetItemSelection.a((int)(localX - 2), (int)(localY - 2), (int)(localX + this.squareSize - 2), (int)(localY + this.squareSize - 2), (int)-16777216);
                WidgetItemSelection.a((int)(localX - 1), (int)(localY - 1), (int)(localX + this.squareSize - 3), (int)(localY + this.squareSize - 3), (int)-2960686);
                WidgetItemSelection.a((int)localX, (int)localY, (int)(localX + this.squareSize - 4), (int)(localY + this.squareSize - 4), (int)-10921639);
            }
            this.inscribeItemStack(localX, localY, keystack.makeStack());
            if (++renderPointerX > this.columns) {
                renderPointerX = 1;
                ++renderPointerY;
            }
            if (renderPointerY <= this.rows) continue;
            break;
        }
        WidgetItemSelection.glItemPost();
    }

    private void inscribeItemStack(int xPos, int yPos, ye stack) {
        avi font = stack.b().getFontRenderer(stack);
        if (font == null) {
            font = this.fontRenderer;
        }
        this.renderItem.f = 100.0f;
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
        this.renderItem.b(font, this.renderEngine, stack, xPos, yPos);
        this.renderItem.a(font, this.renderEngine, stack, xPos, yPos, "");
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        this.renderItem.f = 0.0f;
        String s = stack.b == 1 ? "" : (stack.b < 1000 ? stack.b + "" : (stack.b < 100000 ? stack.b / 1000 + "K" : (stack.b < 1000000 ? "0M" + stack.b / 100000 : stack.b / 1000000 + "M")));
        font.a(s, xPos + 19 - 2 - font.a(s), yPos + 6 + 3, 0xFFFFFF);
    }

    private static void glItemPre() {
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        att.c();
        GL11.glEnable((int)32826);
        bma.a((int)bma.b, (float)240.0f, (float)240.0f);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
    }

    private static void glItemPost() {
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    @Override
    public void drawBack(int mousex, int mousey, float frame) {
        this.a(this.x, this.y, this.x + this.width, this.y + this.height, -8355712, -8355712);
        this.pagesNeeded = (this.getSeachedCount() - 1) / (this.rows * this.columns);
        if (this.pagesNeeded < 0) {
            this.pagesNeeded = 0;
        }
        if (this.currentPage > this.pagesNeeded) {
            this.currentPage = this.pagesNeeded;
        }
        if (!this.downloadFinished) {
            this.drawLoadingScreen();
        } else {
            this.drawAllItems(mousex, mousey);
        }
    }

    @Override
    public void drawFront(int mousex, int mousey) {
        if (this.hover != null) {
            GuiDraw.drawMultilineTip((int)(mousex + 12), (int)(mousey - 12), (List)this.hover.makeStack().a((uf)atv.w().h, atv.w().u.x));
        }
        FontUtils.drawCenteredString((String)("Page: " + (this.currentPage + 1) + "/" + (this.pagesNeeded + 1)), (int)(this.x + this.width / 2), (int)(this.y + this.height + 6), (int)PRColors.BLACK.rgb);
    }

    @Override
    public void mouseClicked(int x, int y, int button) {
        if (this.pointInside(x, y)) {
            this.xLast = x;
            this.yLast = y;
        }
    }
}

