/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.inventory;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.Vertex5;
import codechicken.lib.vec.Rotation;
import java.util.EnumSet;
import mrtjp.projectred.core.PRColors;
import mrtjp.projectred.core.inventory.ClickRotation;
import mrtjp.projectred.core.inventory.GhostWidget;
import mrtjp.projectred.core.utils.DirectionalRayTracer;
import mrtjp.projectred.core.utils.MathLib;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class WidgetHoloSideSelect
extends GhostWidget {
    private boolean activeHighlight = false;
    private bfr renderBlocks = new bfr();
    private ClickRotation.ClickRotationHook rotHook = new ClickRotation.ClickRotationHook(0, 40);
    private boolean init = false;
    private int sides = 0;
    private boolean exclusiveSide = false;
    private ForgeDirection lastSideHovered;
    private int ticksHeld = 0;
    private asp te = null;
    private aqz block = null;
    private int meta = 0;
    private int color;
    private double scale;
    private static CCModel[] highlights;

    public WidgetHoloSideSelect(int x, int y, int width, int height, double scale) {
        super(x, y, width, height);
        this.color = PRColors.LIME.rgb;
        this.scale = scale;
    }

    public WidgetHoloSideSelect setObject(asp te) {
        this.te = te;
        return this;
    }

    public WidgetHoloSideSelect setObject(aqz block, int meta) {
        this.block = block;
        this.meta = meta;
        return this;
    }

    public WidgetHoloSideSelect setSideHighlighting(boolean flag) {
        this.activeHighlight = flag;
        return this;
    }

    public WidgetHoloSideSelect setColor(int color) {
        this.color = color;
        return this;
    }

    public WidgetHoloSideSelect setExclusiveSides(boolean flag) {
        this.exclusiveSide = flag;
        return this;
    }

    public WidgetHoloSideSelect setSides(EnumSet<ForgeDirection> dirs) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!dirs.contains(dir)) continue;
            this.sides |= 1 << dir.ordinal();
        }
        return this;
    }

    @Override
    public void drawBack(int mouseX, int mouseY, float frame) {
        if (!this.init || Mouse.isButtonDown((int)2)) {
            this.rotHook.setTransform(MathLib.createEntityRotateMatrix((nn)this.mc.i));
            this.init = true;
        }
        GL11.glPushMatrix();
        bfq t = bfq.a;
        GL11.glTranslated((double)((double)this.x + this.scale / 2.0), (double)((double)this.y + this.scale / 2.0), (double)this.scale);
        GL11.glScaled((double)this.scale, (double)(-this.scale), (double)this.scale);
        this.rotHook.update(mouseX - this.width, -(mouseY - this.height), this.pointInside(mouseX, mouseY));
        if (this.te != null) {
            bjd.a.a(this.te, -0.5, -0.5, -0.5, 0.0f);
        } else {
            this.drawBlock(this.mc.N, t);
        }
        DirectionalRayTracer tracer = new DirectionalRayTracer(0.5);
        DirectionalRayTracer.HitCoord coord = tracer.getNearestHit();
        if (coord != null && !Mouse.isButtonDown((int)0)) {
            this.drawHighlight(t, coord.side, 0x444444);
        }
        if (this.activeHighlight) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if ((this.sides & 1 << dir.ordinal()) == 0) continue;
                this.drawHighlight(t, dir, 0xCC0000);
            }
        }
        this.lastSideHovered = coord == null ? ForgeDirection.UNKNOWN : coord.side;
        GL11.glPopMatrix();
    }

    private static void genHighlightModel() {
        CCModel model = CCModel.quadModel((int)4);
        model.verts[0] = new Vertex5(-0.5, -0.5, -0.5, 0.0, 0.0);
        model.verts[1] = new Vertex5(0.5, -0.5, -0.5, 0.0, 0.0);
        model.verts[2] = new Vertex5(0.5, -0.5, 0.5, 0.0, 0.0);
        model.verts[3] = new Vertex5(-0.5, -0.5, 0.5, 0.0, 0.0);
        highlights = new CCModel[6];
        WidgetHoloSideSelect.highlights[0] = model;
        for (int s = 1; s < 6; ++s) {
            WidgetHoloSideSelect.highlights[s] = model.copy().apply(Rotation.sideRotations[s]);
        }
    }

    private void drawHighlight(bfq t, ForgeDirection side2, int i) {
        WidgetHoloSideSelect.genHighlightModel();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        t.b();
        t.a(this.color, 64);
        highlights[side2.ordinal()].render();
        t.a();
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    private void drawBlock(bim renderEngine, bfq t) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderEngine.a(bik.b);
        this.renderBlocks.a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        t.b();
        this.renderBlocks.e(aqz.y, -0.5, -0.5, -0.5, this.block.a(4, this.meta));
        this.renderBlocks.f(aqz.y, -0.5, -0.5, -0.5, this.block.a(5, this.meta));
        this.renderBlocks.b(aqz.y, -0.5, -0.5, -0.5, this.block.a(1, this.meta));
        this.renderBlocks.a(aqz.y, -0.5, -0.5, -0.5, this.block.a(0, this.meta));
        this.renderBlocks.c(aqz.y, -0.5, -0.5, -0.5, this.block.a(2, this.meta));
        this.renderBlocks.d(aqz.y, -0.5, -0.5, -0.5, this.block.a(3, this.meta));
        t.a();
    }

    @Override
    public void mouseClicked(int x, int y, int button) {
        this.ticksHeld = 0;
        this.lastSideHovered = null;
    }

    @Override
    public void mouseMovedOrUp(int x, int y, int button) {
        if (button == 0 && this.ticksHeld < 5 && this.lastSideHovered != null && this.lastSideHovered != ForgeDirection.UNKNOWN) {
            this.toggleSide(this.lastSideHovered.ordinal());
            this.ticksHeld = 5;
        }
    }

    private void toggleSide(int side) {
        int old = this.sides;
        this.sides ^= 1 << side;
        if (this.exclusiveSide) {
            this.sides &= 1 << side;
        }
        if (old != this.sides) {
            this.onSideChanged();
        }
    }

    public void clearSides() {
        int old = this.sides;
        this.sides = 0;
        if (old != this.sides) {
            this.onSideChanged();
        }
    }

    @Override
    public void mouseDragged(int x, int y, int button, long time) {
        ++this.ticksHeld;
    }

    public EnumSet<ForgeDirection> getSides() {
        EnumSet<ForgeDirection> set = EnumSet.noneOf(ForgeDirection.class);
        for (int i = 0; i < 6; ++i) {
            if ((this.sides & 1 << i) == 0) continue;
            set.add(ForgeDirection.getOrientation((int)i));
        }
        return set;
    }

    public void onSideChanged() {
    }

    static {
        WidgetHoloSideSelect.genHighlightModel();
    }
}

