/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.inventory;

import codechicken.core.gui.GuiDraw;
import codechicken.lib.render.CCRenderState;
import java.util.LinkedList;
import java.util.List;
import mrtjp.projectred.core.inventory.GhostWidget;
import org.lwjgl.opengl.GL11;

public abstract class WidgetButton
extends GhostWidget {
    public String actionCommand;
    public String text = "";

    public WidgetButton(int x, int y, int l, int w) {
        super(x, y, l, w);
    }

    @Override
    public void mouseClicked(int x, int y, int button) {
        if (this.pointInside(x, y) && this.actionCommand != null) {
            this.sendAction(this.actionCommand, button);
            atv.w().v.a("random.click", 1.0f, 1.0f);
        }
    }

    @Override
    public void drawBack(int mousex, int mousey, float frame) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean mouseover = this.pointInside(mousex, mousey);
        this.drawButtonBackground(mousex, mousey, frame);
        this.drawButton(mouseover);
    }

    @Override
    public void drawFront(int mousex, int mousey) {
        boolean mouseover = this.pointInside(mousex, mousey);
        if (mouseover) {
            GuiDraw.drawMultilineTip((int)(mousex + 12), (int)(mousey - 12), this.getOverlayText());
        }
    }

    public void drawButtonBackground(int mousex, int mousey, float frame) {
        this.renderEngine.a(guiTex);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean mouseover = this.pointInside(mousex, mousey);
        int state = mouseover ? 2 : 1;
        this.b(this.x, this.y, 0, 46 + state * 20, this.width / 2, this.height / 2);
        this.b(this.x + this.width / 2, this.y, 200 - this.width / 2, 46 + state * 20, this.width / 2, this.height / 2);
        this.b(this.x, this.y + this.height / 2, 0, 46 + state * 20 + 20 - this.height / 2, this.width / 2, this.height / 2);
        this.b(this.x + this.width / 2, this.y + this.height / 2, 200 - this.width / 2, 46 + state * 20 + 20 - this.height / 2, this.width / 2, this.height / 2);
    }

    public void drawButton(boolean mouseover) {
    }

    public List<String> getOverlayText() {
        return new LinkedList<String>();
    }

    public WidgetButton setActionCommand(String string) {
        this.actionCommand = string;
        return this;
    }

    public WidgetButton setText(String text) {
        this.text = text;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public static class WidgetCheckBox
    extends WidgetButton {
        private boolean checked;

        public WidgetCheckBox(int x, int y, boolean state) {
            super(x - 7, y - 7, 14, 14);
            this.checked = state;
        }

        public boolean isChecked() {
            return this.checked;
        }

        @Override
        public void mouseClicked(int x, int y, int button) {
            if (this.pointInside(x, y)) {
                if (this.actionCommand != null) {
                    this.sendAction(this.actionCommand, button);
                }
                atv.w().v.a("random.click", 1.0f, 1.0f);
                boolean old = this.checked;
                this.checked = !this.checked;
                this.onStateChanged(old);
            }
        }

        @Override
        public void drawButton(boolean mouseover) {
            CCRenderState.changeTexture((String)"projectred:textures/gui/guiextras.png");
            int u = this.checked ? 17 : 1;
            this.b(this.x, this.y, u, 134, 14, 14);
        }

        public WidgetCheckBox setCheck(boolean flag) {
            boolean old = this.checked;
            this.checked = flag;
            if (old != this.checked) {
                this.onStateChanged(old);
            }
            return this;
        }

        public void onStateChanged(boolean oldState) {
        }
    }

    public static class WidgetDotSelector
    extends WidgetButton {
        public WidgetDotSelector(int x, int y) {
            super(x - 4, y - 4, 8, 8);
        }

        @Override
        public void drawButtonBackground(int mousex, int mousey, float f) {
            CCRenderState.changeTexture((String)"projectred:textures/gui/guiextras.png");
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean mouseover = this.pointInside(mousex, mousey);
            int u = mouseover ? 11 : 1;
            this.b(this.x, this.y, u, 1, 8, 8);
        }
    }

    public static class WidgetSimpleButton
    extends WidgetButton {
        public WidgetSimpleButton(int x, int y, int l, int w) {
            super(x, y, l, w);
        }

        @Override
        public void drawButton(boolean mouseover) {
            this.a(this.fontRenderer, this.getText(), this.x + this.width / 2, this.y + (this.height - 8) / 2, mouseover ? -96 : -2039584);
        }

        @Override
        public List<String> getOverlayText() {
            return new LinkedList<String>();
        }
    }
}

