/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.inventory;

import codechicken.lib.vec.BlockCoord;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.core.utils.ItemKey;

public abstract class InventoryWrapper {
    private mo inv;
    private my sidedInv;
    private int side;
    private int startIndex;
    private int endIndex;
    private int[] slots;
    private boolean hideOnePerSlot = false;
    private boolean hideOnePerType = false;
    private int fuzzyMathPercentage = 0;
    private boolean fuzzyMode = false;
    private static List<InventoryWrapper> wrappers = new ArrayList<InventoryWrapper>();

    public static void registerWrapper(InventoryWrapper wrapper) {
        for (InventoryWrapper w : wrappers) {
            if (!w.wrapperID().equals(wrapper.wrapperID())) continue;
            return;
        }
        wrappers.add(wrapper);
    }

    public static InventoryWrapper wrapInventory(mo inv) {
        for (InventoryWrapper w : wrappers) {
            if (!w.shouldUseWrapper(inv)) continue;
            return w.create(inv);
        }
        return new InventoryWrapperVanilla(inv);
    }

    private InventoryWrapper(mo inv) {
        this.inv = inv;
        if (inv instanceof my) {
            this.sidedInv = (my)inv;
        }
        this.startIndex = 0;
        this.endIndex = inv.j_();
    }

    public InventoryWrapper setSlotsFromSide(int side) {
        this.side = side;
        if (this.sidedInv == null) {
            return this.setSlotsAll();
        }
        this.slots = this.sidedInv.c(side);
        return this;
    }

    public InventoryWrapper setSlotsFromRange(int startIndex, int endIndex) {
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.slots = new int[endIndex - startIndex];
        for (int i = startIndex; i < endIndex; ++i) {
            this.slots[i] = i;
        }
        return this;
    }

    public InventoryWrapper setSlotsAll() {
        this.slots = new int[this.inv.j_()];
        for (int i = 0; i < this.inv.j_(); ++i) {
            this.slots[i] = i;
        }
        return this;
    }

    public InventoryWrapper setFuzzy(boolean flag) {
        this.fuzzyMode = flag;
        return this;
    }

    public InventoryWrapper setFuzzyPercent(int percent) {
        this.fuzzyMathPercentage = percent;
        return this;
    }

    public InventoryWrapper setHidePerSlot(boolean flag) {
        this.hideOnePerSlot = flag;
        if (flag) {
            this.hideOnePerType = false;
        }
        return this;
    }

    public InventoryWrapper setHidePerType(boolean flag) {
        this.hideOnePerType = flag;
        if (flag) {
            this.hideOnePerSlot = false;
        }
        return this;
    }

    public abstract String wrapperID();

    public abstract boolean shouldUseWrapper(mo var1);

    public abstract InventoryWrapper create(mo var1);

    public int getRoomAvailableForItem(ItemKey item) {
        int room = 0;
        ye item2 = item.makeStack(0);
        int slotStackLimit = Math.min(this.inv.d(), item2.e());
        for (int slot : this.slots) {
            ye s = this.inv.a(slot);
            if (!this.canInsertItem(slot, item2)) continue;
            if (s == null) {
                room += slotStackLimit;
                continue;
            }
            if (!InventoryWrapper.areItemsStackable(s, item2)) continue;
            room += slotStackLimit - s.b;
        }
        return room;
    }

    public int getItemCount(ItemKey item) {
        ye item2 = item.makeStack(0);
        int count = 0;
        boolean first = true;
        for (int slot : this.slots) {
            ye inSlot = this.inv.a(slot);
            if (inSlot == null || !InventoryWrapper.areItemsSame(inSlot, item2) && (!this.fuzzyMode || !InventoryWrapper.areItemsFuzzySame(inSlot, item2)) && (this.fuzzyMathPercentage <= 0 || !this.areItemDamagesInFuzzyGroup(inSlot, item2))) continue;
            int toAdd = inSlot.b - (this.hideOnePerSlot || this.hideOnePerType && first ? 1 : 0);
            first = false;
            count += toAdd;
        }
        return count;
    }

    public boolean hasItem(ItemKey item) {
        ye item2 = item.makeStack(0);
        boolean first = true;
        for (int slot : this.slots) {
            ye inSlot = this.inv.a(slot);
            if (inSlot == null || !InventoryWrapper.areItemsSame(inSlot, item2) && (!this.fuzzyMode || !InventoryWrapper.areItemsFuzzySame(inSlot, item2)) && (this.fuzzyMathPercentage <= 0 || !this.areItemDamagesInFuzzyGroup(inSlot, item2))) continue;
            return true;
        }
        return false;
    }

    public int injectItem(ye item, boolean doAdd) {
        if (!doAdd) {
            return Math.min(this.getRoomAvailableForItem(ItemKey.get(item)), item.b);
        }
        int itemsLeft = item.b;
        int slotStackLimit = Math.min(this.inv.d(), item.e());
        for (int pass = 0; pass < 2; ++pass) {
            for (int slot : this.slots) {
                if (!this.canInsertItem(slot, item)) continue;
                ye inSlot = this.inv.a(slot);
                if (inSlot != null && InventoryWrapper.areItemsStackable(item, inSlot)) {
                    int fit = Math.min(slotStackLimit - inSlot.b, itemsLeft);
                    inSlot.b += fit;
                    itemsLeft -= fit;
                    this.inv.a(slot, inSlot);
                } else if (pass == 1 && inSlot == null) {
                    ye toInsert = item.m();
                    toInsert.b = Math.min(this.inv.d(), itemsLeft);
                    itemsLeft -= toInsert.b;
                    this.inv.a(slot, toInsert);
                }
                if (itemsLeft != 0) continue;
                return item.b;
            }
        }
        return item.b - itemsLeft;
    }

    public int extractItem(ItemKey item, int toExtract) {
        if (toExtract <= 0) {
            return 0;
        }
        ye item2 = item.makeStack(0);
        int left = toExtract;
        boolean first = true;
        for (int slot : this.slots) {
            if (!this.canExtractItem(slot, item2)) continue;
            ye inSlot = this.inv.a(slot);
            if (inSlot != null && (InventoryWrapper.areItemsSame(inSlot, item2) || this.fuzzyMode && InventoryWrapper.areItemsFuzzySame(inSlot, item2) || this.fuzzyMathPercentage > 0 && this.areItemDamagesInFuzzyGroup(inSlot, item2))) {
                left -= this.inv.a((int)slot, (int)Math.min((int)left, (int)(inSlot.b - (this.hideOnePerSlot || this.hideOnePerType && first ? 1 : 0)))).b;
                first = false;
            }
            if (left > 0) continue;
            return toExtract;
        }
        return toExtract - left;
    }

    public Map<ItemKey, Integer> getAllItemStacks() {
        LinkedHashMap<ItemKey, Integer> items = new LinkedHashMap<ItemKey, Integer>();
        for (int slot : this.slots) {
            ye inSlot = this.inv.a(slot);
            if (inSlot == null) continue;
            ItemKey key = ItemKey.get(inSlot);
            int stackSize = inSlot.b - (this.hideOnePerSlot ? 1 : 0);
            Integer currentSize = (Integer)items.get(key);
            if (currentSize == null) {
                items.put(key, stackSize - (this.hideOnePerType ? 1 : 0));
                continue;
            }
            items.put(key, currentSize + stackSize);
        }
        return items;
    }

    private boolean canInsertItem(int slot, ye item) {
        return this.sidedInv == null ? this.inv.b(slot, item) : this.sidedInv.a(slot, item, this.side);
    }

    private boolean canExtractItem(int slot, ye item) {
        return this.sidedInv == null ? this.inv.b(slot, item) : this.sidedInv.b(slot, item, this.side);
    }

    private boolean areItemDamagesInFuzzyGroup(ye stack1, ye stack2) {
        if (stack1 == null || stack2 == null) {
            return stack1 == stack2;
        }
        if (!stack1.g() || !stack2.g()) {
            return false;
        }
        double percentDamage1 = (double)stack1.k() / (double)stack1.l() * 100.0;
        double percentDamage2 = (double)stack2.k() / (double)stack2.l() * 100.0;
        boolean isUpperGroup1 = percentDamage1 >= (double)this.fuzzyMathPercentage;
        boolean isUpperGroup2 = percentDamage2 >= (double)this.fuzzyMathPercentage;
        return isUpperGroup1 == isUpperGroup2;
    }

    public static boolean areItemsStackable(ye stack1, ye stack2) {
        return stack1 == null || stack2 == null || InventoryWrapper.areItemsSame(stack1, stack2) && stack1.f() && stack2.f();
    }

    public static boolean areItemsSame(ye stack1, ye stack2) {
        if (stack1 == null || stack2 == null) {
            return stack1 == stack2;
        }
        return stack1.d == stack2.d && stack2.k() == stack1.k() && ye.a((ye)stack2, (ye)stack1);
    }

    public static boolean areItemsFuzzySame(ye stack1, ye stack2) {
        if (stack1 == null || stack2 == null) {
            return stack1 == stack2;
        }
        return stack1.d == stack2.d && stack2.k() == stack1.k();
    }

    public static mo getInventory(abw world, BlockCoord wc) {
        mo inv = BasicUtils.getTileEntity((acf)world, wc, mo.class);
        if (inv instanceof ary) {
            ary chest = (ary)inv;
            ary lower = null;
            ary upper = null;
            if (chest.d != null) {
                upper = chest.d;
                lower = chest;
            }
            if (chest.c != null) {
                upper = chest;
                lower = chest.c;
            }
            if (chest.b != null) {
                upper = chest.b;
                lower = chest;
            }
            if (chest.e != null) {
                upper = chest;
                lower = chest.e;
            }
            if (lower != null && upper != null) {
                return new HashableLargeChest("Large Chest", (mo)upper, (mo)lower);
            }
            return inv;
        }
        return inv;
    }

    public static class HashableLargeChest
    extends mn {
        private final mo upper;
        private final mo lower;

        public HashableLargeChest(String name, mo inv1, mo inv2) {
            super(name, inv1, inv2);
            this.upper = inv1;
            this.lower = inv2;
        }

        public boolean equals(Object o) {
            if (o instanceof HashableLargeChest) {
                HashableLargeChest chest = (HashableLargeChest)((Object)o);
                return this.upper == chest.upper && this.lower == chest.lower;
            }
            return false;
        }

        public int hashCode() {
            return this.upper.hashCode() ^ this.lower.hashCode();
        }
    }

    public static class InventoryWrapperVanilla
    extends InventoryWrapper {
        private InventoryWrapperVanilla(mo inv) {
            super(inv);
        }

        @Override
        public String wrapperID() {
            return "vanilla";
        }

        @Override
        public boolean shouldUseWrapper(mo inv) {
            return true;
        }

        @Override
        public InventoryWrapper create(mo inv) {
            return new InventoryWrapperVanilla(inv);
        }
    }
}

